/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiFocusable;

public class PageLabelButton
extends GuiButtonCore {
    public int mPage;
    public int mPages;
    public int mColor;
    public int mHoveredPage = -1;
    private float mShowTick;

    public PageLabelButton(GuiFocusable screen, int x, int y, int width, int height, int page, int pages, int color) {
        super(screen, x, y, width, height);
        this.mColor = color;
        this.refreshPages(page, pages);
    }

    @Override
    public void drawButton(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        int pos;
        int pages = this.mPages;
        if (pages <= 0) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int dotSize = this.height;
        int dotsWidth = pages * dotSize + (pages - 1);
        int startX = this.x + (this.width - dotsWidth) / 2;
        boolean hovered = this.isMouseHovered(mouseX, mouseY);
        this.mHoveredPage = hovered ? ((pos = (int)Math.floor((float)(mouseX - startX) / ((float)dotSize + 1.0f))) < 0 || pos >= pages ? -1 : pos) : -1;
        for (int i = 0; i < pages; ++i) {
            if (i == this.mPage) {
                gr.m_280509_(startX, this.y, startX + dotSize, this.y + dotSize, this.mColor | 0xF0000000);
            } else if (i == this.mHoveredPage) {
                gr.m_280509_(startX, this.y, startX + dotSize, this.y + dotSize, -1065320320);
            } else {
                int inset = dotSize / 4;
                gr.m_280509_(startX + inset, this.y + inset, startX + dotSize - inset, this.y + dotSize - inset, -1065320320);
            }
            startX += dotSize + 1;
        }
        if (this.mHoveredPage != -1) {
            gr.m_280137_(this.screen.getMinecraft().f_91062_, this.mHoveredPage + 1 + " / " + pages, this.x + this.width / 2, this.y + 6, this.mColor);
        } else if (this.mShowTick > 0.0f) {
            int alpha = (int)Math.min(255.0f, this.mShowTick * 24.0f);
            if (alpha > 3) {
                gr.m_280137_(this.screen.getMinecraft().f_91062_, this.mPage + 1 + " / " + pages, this.x + this.width / 2, this.y + 6, this.mColor | alpha << 24);
            }
            this.mShowTick -= deltaTicks;
        }
    }

    public void refreshPages(int page, int pages) {
        if (this.mPage != page || this.mPages != pages) {
            this.mPage = page;
            this.mPages = pages;
            this.mHoveredPage = -1;
            this.mShowTick = 20.0f;
        }
    }
}

