/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.button;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class FluxEditBox
extends EditBox {
    private final Font mFont;
    private final String mHeader;
    private final int mHeaderWidth;
    private String mOrigin;
    private boolean mHexOnly;
    private boolean mDigitsOnly;
    private long mMaxValue = Integer.MAX_VALUE;
    private boolean mAllowNegatives = false;
    private int mOutlineColor = -4934476;

    private FluxEditBox(String header, Font font, int x, int y, int totalWidth, int height, int headerWidth) {
        super(font, x + headerWidth, y, totalWidth - headerWidth, height, CommonComponents.f_237098_);
        this.mHeader = header;
        this.mHeaderWidth = headerWidth;
        this.mFont = font;
    }

    @Nonnull
    public static FluxEditBox create(String header, Font font, int x, int y, int width, int height) {
        return new FluxEditBox(header, font, x, y, width, height, font.m_92895_(header));
    }

    public int getIntegerFromText(boolean allowNegatives) {
        if (this.m_94155_().isEmpty() || this.m_94155_().equals("-")) {
            return 0;
        }
        int parseInt = Integer.parseInt(this.m_94155_());
        return allowNegatives ? parseInt : Math.max(parseInt, 0);
    }

    public long getLongFromText(boolean allowNegatives) {
        if (this.m_94155_().isEmpty() || this.m_94155_().equals("-")) {
            return 0L;
        }
        long parseLong = Long.parseLong(this.m_94155_());
        return allowNegatives ? parseLong : Math.max(parseLong, 0L);
    }

    public int getIntegerFromHex() {
        return Integer.parseInt(this.m_94155_(), 16);
    }

    public void m_87963_(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        if (this.m_94213_()) {
            gr.m_280509_(this.m_252754_() - this.mHeaderWidth, this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, 0x30000000);
            gr.m_280509_(this.m_252754_() - this.mHeaderWidth - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_ + 1, this.m_252907_(), this.mOutlineColor);
            gr.m_280509_(this.m_252754_() - this.mHeaderWidth - 1, this.m_252907_() + this.f_93619_, this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_ + 1, this.mOutlineColor);
            gr.m_280509_(this.m_252754_() - this.mHeaderWidth - 1, this.m_252907_(), this.m_252754_() - this.mHeaderWidth, this.m_252907_() + this.f_93619_, this.mOutlineColor);
            gr.m_280509_(this.m_252754_() + this.f_93618_, this.m_252907_(), this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_, this.mOutlineColor);
        }
        gr.m_280168_().m_85836_();
        int dy = (this.f_93619_ - 8) / 2;
        gr.m_280168_().m_252880_(4.0f, (float)dy, 0.0f);
        this.m_94182_(false);
        super.m_87963_(gr, mouseX, mouseY, deltaTicks);
        gr.m_280488_(this.mFont, this.mHeader, this.m_252754_() - this.mHeaderWidth, this.m_252907_(), this.mOutlineColor);
        gr.m_280168_().m_85849_();
    }

    public void m_94164_(@Nonnull String textToWrite) {
        char c;
        int i;
        if (this.mDigitsOnly) {
            for (i = 0; i < textToWrite.length(); ++i) {
                c = textToWrite.charAt(i);
                if (Character.isDigit(c)) continue;
                if (this.m_94155_().isEmpty()) {
                    if (c == '-') continue;
                    return;
                }
                return;
            }
        }
        if (this.mHexOnly) {
            for (i = 0; i < textToWrite.length(); ++i) {
                c = textToWrite.charAt(i);
                if (c != '-') continue;
                return;
            }
            String origin = this.m_94155_();
            super.m_94164_(textToWrite);
            try {
                Integer.parseInt(this.m_94155_(), 16);
            }
            catch (NumberFormatException ignored) {
                this.m_94144_(origin);
            }
            return;
        }
        super.m_94164_(textToWrite);
    }

    public void m_93692_(boolean isFocused) {
        if (isFocused) {
            if (this.mDigitsOnly) {
                this.mOrigin = this.m_94155_();
            }
        } else if (this.m_93696_() && this.mDigitsOnly) {
            try {
                this.m_94144_(String.valueOf(this.getValidLong()));
            }
            catch (NumberFormatException ignored) {
                this.m_94144_(this.mOrigin);
            }
        }
        super.m_93692_(isFocused);
    }

    public long getValidLong() {
        return Math.min(this.getLongFromText(this.mAllowNegatives), this.mMaxValue);
    }

    public int getValidInt() {
        return (int)Math.min(this.getValidLong(), Integer.MAX_VALUE);
    }

    public FluxEditBox setOutlineColor(int color) {
        this.mOutlineColor = color;
        return this;
    }

    public int getOutlineColor() {
        return this.mOutlineColor;
    }

    public FluxEditBox setTextInvisible() {
        this.m_94149_(FluxEditBox::getInvisibleText);
        return this;
    }

    @Nonnull
    public static FormattedCharSequence getInvisibleText(String string, int cursorPos) {
        return FormattedCharSequence.m_13714_((String)"\u2022".repeat(string.length()), (Style)Style.f_131099_);
    }

    public FluxEditBox setDigitsOnly() {
        this.mDigitsOnly = true;
        return this;
    }

    public FluxEditBox setAllowNegatives(boolean allowNegatives) {
        this.mAllowNegatives = allowNegatives;
        return this;
    }

    public FluxEditBox setMaxValue(long max) {
        this.mMaxValue = max;
        return this;
    }

    public FluxEditBox setHexOnly() {
        this.mHexOnly = true;
        return this;
    }
}

