/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.world.presets;

import de.melanx.skyblockbuilder.config.common.DimensionsConfig;
import de.melanx.skyblockbuilder.config.common.WorldConfig;
import de.melanx.skyblockbuilder.util.BiomeSourceConverter;
import de.melanx.skyblockbuilder.util.WorldPresetUtil;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyblockbuilder.world.chunkgenerators.SkyblockEndChunkGenerator;
import de.melanx.skyblockbuilder.world.chunkgenerators.SkyblockNoiseBasedChunkGenerator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import org.moddingx.libx.util.lazy.LazyValue;

public class SkyblockPreset
extends WorldPreset {
    private final LazyValue<WorldPreset> actualPreset = new LazyValue(() -> new WorldPreset(SkyblockPreset.dimensions(dimensionTypes, noises, noiseGeneratorSettings, (HolderLookup<Biome>)biomes)));
    private final HolderLookup.RegistryLookup<Biome> biomes;

    public SkyblockPreset(HolderGetter<DimensionType> dimensionTypes, HolderGetter<MultiNoiseBiomeSourceParameterList> noises, HolderGetter<NoiseGeneratorSettings> noiseGeneratorSettings, HolderLookup.RegistryLookup<Biome> biomes) {
        super(Map.of());
        this.biomes = biomes;
    }

    public HolderLookup.RegistryLookup<Biome> getBiomes() {
        return this.biomes;
    }

    @Nonnull
    public WorldDimensions m_247748_() {
        return ((WorldPreset)this.actualPreset.get()).m_247748_();
    }

    @Nonnull
    public Optional<LevelStem> m_226420_() {
        return ((WorldPreset)this.actualPreset.get()).m_226420_();
    }

    public static Map<ResourceKey<LevelStem>, LevelStem> dimensions(HolderGetter<DimensionType> dimensionTypes, HolderGetter<MultiNoiseBiomeSourceParameterList> noises, HolderGetter<NoiseGeneratorSettings> noiseGeneratorSettings, HolderLookup<Biome> biomes) {
        return Map.of(LevelStem.f_63971_, new LevelStem((Holder)dimensionTypes.m_255043_(BuiltinDimensionTypes.f_223538_), SkyblockPreset.configuredOverworldChunkGenerator(noises, noiseGeneratorSettings, biomes)), LevelStem.f_63972_, new LevelStem((Holder)dimensionTypes.m_255043_(BuiltinDimensionTypes.f_223539_), DimensionsConfig.Nether.Default ? WorldPresetUtil.defaultNetherGenerator(noises, noiseGeneratorSettings) : SkyblockPreset.netherChunkGenerator(noises, noiseGeneratorSettings, biomes)), LevelStem.f_63973_, new LevelStem((Holder)dimensionTypes.m_255043_(BuiltinDimensionTypes.f_223540_), DimensionsConfig.End.Default ? WorldPresetUtil.defaultEndGenerator(noiseGeneratorSettings, biomes) : SkyblockPreset.endChunkGenerator(noiseGeneratorSettings, biomes)));
    }

    public static ChunkGenerator configuredOverworldChunkGenerator(HolderGetter<MultiNoiseBiomeSourceParameterList> noises, HolderGetter<NoiseGeneratorSettings> noiseGeneratorSettings, HolderLookup<Biome> biomes) {
        return DimensionsConfig.Overworld.Default ? new NoiseBasedChunkGenerator((BiomeSource)MultiNoiseBiomeSource.m_274591_((Holder)noises.m_255043_(MultiNoiseBiomeSourceParameterLists.f_273878_)), (Holder)noiseGeneratorSettings.m_255043_(NoiseGeneratorSettings.f_64432_)) : SkyblockPreset.overworldChunkGenerator(noises, noiseGeneratorSettings, biomes);
    }

    public static ChunkGenerator overworldChunkGenerator(HolderGetter<MultiNoiseBiomeSourceParameterList> noises, HolderGetter<NoiseGeneratorSettings> noiseGeneratorSettings, HolderLookup<Biome> biomes) {
        MultiNoiseBiomeSource biomeSource = (MultiNoiseBiomeSource)BiomeSourceConverter.customBiomeSource((ResourceKey<Level>)Level.f_46428_, (BiomeSource)MultiNoiseBiomeSource.m_274591_((Holder)noises.m_255043_(MultiNoiseBiomeSourceParameterLists.f_273878_)), biomes);
        Holder.Reference settings = noiseGeneratorSettings.m_255043_(NoiseGeneratorSettings.f_64432_);
        return new SkyblockNoiseBasedChunkGenerator((BiomeSource)biomeSource, (Holder<NoiseGeneratorSettings>)settings, (ResourceKey<Level>)Level.f_46428_, SkyblockPreset.getLayers((ResourceKey<Level>)Level.f_46428_));
    }

    private static ChunkGenerator netherChunkGenerator(HolderGetter<MultiNoiseBiomeSourceParameterList> noises, HolderGetter<NoiseGeneratorSettings> noiseGeneratorSettings, HolderLookup<Biome> biomes) {
        BiomeSource biomeSource = BiomeSourceConverter.customBiomeSource((ResourceKey<Level>)Level.f_46429_, (BiomeSource)MultiNoiseBiomeSource.m_274591_((Holder)noises.m_255043_(MultiNoiseBiomeSourceParameterLists.f_273830_)), biomes);
        Holder.Reference settings = noiseGeneratorSettings.m_255043_(NoiseGeneratorSettings.f_64434_);
        return new SkyblockNoiseBasedChunkGenerator(biomeSource, (Holder<NoiseGeneratorSettings>)settings, (ResourceKey<Level>)Level.f_46429_, SkyblockPreset.getLayers((ResourceKey<Level>)Level.f_46429_));
    }

    private static ChunkGenerator endChunkGenerator(HolderGetter<NoiseGeneratorSettings> noiseGeneratorSettings, HolderLookup<Biome> biomes) {
        TheEndBiomeSource biomeSource = (TheEndBiomeSource)BiomeSourceConverter.customBiomeSource((ResourceKey<Level>)Level.f_46430_, (BiomeSource)TheEndBiomeSource.m_254978_(biomes), biomes);
        Holder.Reference settings = noiseGeneratorSettings.m_255043_(NoiseGeneratorSettings.f_64435_);
        return new SkyblockEndChunkGenerator((BiomeSource)biomeSource, (Holder<NoiseGeneratorSettings>)settings, (ResourceKey<Level>)Level.f_46430_, SkyblockPreset.getLayers((ResourceKey<Level>)Level.f_46430_));
    }

    public static List<FlatLayerInfo> getLayers(ResourceKey<Level> levelKey) {
        return WorldConfig.surface ? WorldUtil.layersInfoFromString(WorldConfig.surfaceSettings.getOrDefault(levelKey.m_135782_().toString(), "")) : List.of();
    }
}

