/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.world.chunkgenerators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.skyblockbuilder.config.common.StructuresConfig;
import de.melanx.skyblockbuilder.config.common.WorldConfig;
import de.melanx.skyblockbuilder.util.WorldUtil;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;

public class SkyblockNoiseBasedChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<SkyblockNoiseBasedChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(generator -> generator.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(generator -> generator.generatorSettings), (App)Level.f_46427_.fieldOf("dimension").forGetter(generator -> generator.dimension), (App)FlatLayerInfo.f_70329_.listOf().fieldOf("layers").forGetter(generator -> generator.layerInfos)).apply((Applicative)instance, instance.stable(SkyblockNoiseBasedChunkGenerator::new)));
    public final Holder<NoiseGeneratorSettings> generatorSettings;
    public final ResourceKey<Level> dimension;
    protected final NoiseBasedChunkGenerator parent;
    protected final List<FlatLayerInfo> layerInfos;
    private final int layerHeight;

    public SkyblockNoiseBasedChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> generatorSettings, ResourceKey<Level> dimension, List<FlatLayerInfo> layerInfos) {
        super(biomeSource, generatorSettings);
        this.generatorSettings = generatorSettings;
        this.parent = new NoiseBasedChunkGenerator(biomeSource, generatorSettings);
        this.dimension = dimension;
        this.layerInfos = layerInfos;
        this.layerHeight = WorldUtil.calculateHeightFromLayers(this.layerInfos);
    }

    @Nonnull
    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public int m_6337_() {
        return WorldConfig.seaHeight;
    }

    public void m_214194_(@Nonnull WorldGenRegion level, @Nonnull StructureManager structureManager, @Nonnull RandomState randomState, @Nonnull ChunkAccess chunk) {
        if (!this.layerInfos.isEmpty()) {
            ChunkPos cp = chunk.m_7697_();
            int xs = cp.m_45604_();
            int zs = cp.m_45605_();
            int xe = cp.m_45608_();
            int ze = cp.m_45609_();
            int y = level.m_141937_();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (FlatLayerInfo info : this.layerInfos) {
                BlockState state = info.m_70344_();
                for (int i = 0; i < info.m_70337_(); ++i) {
                    for (int x = xs; x <= xe; ++x) {
                        for (int z = zs; z <= ze; ++z) {
                            pos.m_142451_(x);
                            pos.m_142448_(y);
                            pos.m_142443_(z);
                            chunk.m_6978_((BlockPos)pos, state, false);
                        }
                    }
                    ++y;
                }
            }
        }
    }

    @Nonnull
    public CompletableFuture<ChunkAccess> m_213974_(@Nonnull Executor executor, @Nonnull Blender blender, @Nonnull RandomState randomState, @Nonnull StructureManager manager, @Nonnull ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    @Nullable
    public Pair<BlockPos, Holder<Structure>> m_223037_(@Nonnull ServerLevel level, @Nonnull HolderSet<Structure> structureHolderSet, @Nonnull BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        List<Holder> holders = structureHolderSet.m_203614_().filter(holder -> holder.m_203543_().isPresent() && StructuresConfig.generationStructures.test(((ResourceKey)holder.m_203543_().get()).m_135782_())).toList();
        HolderSet.Direct modifiedStructureHolderSet = HolderSet.m_205800_(holders);
        for (Holder holder2 : modifiedStructureHolderSet) {
            if (!holder2.m_203543_().isPresent() || !StructuresConfig.generationStructures.test(((ResourceKey)holder2.m_203543_().get()).m_135782_())) continue;
            return super.m_223037_(level, (HolderSet)modifiedStructureHolderSet, pos, searchRadius, skipKnownStructures);
        }
        return null;
    }

    public int m_214096_(int x, int z, @Nonnull Heightmap.Types heightmapType, @Nonnull LevelHeightAccessor level, @Nonnull RandomState randomState) {
        if (WorldConfig.surface) {
            return level.m_141937_() + this.layerHeight;
        }
        return this.parent.m_214096_(x, z, heightmapType, level, randomState);
    }

    public void m_213679_(@Nonnull WorldGenRegion level, long seed, @Nonnull RandomState random, @Nonnull BiomeManager biomeManager, @Nonnull StructureManager structureManager, @Nonnull ChunkAccess chunk, @Nonnull GenerationStep.Carving step) {
        if (this.layerInfos.isEmpty()) {
            return;
        }
        NoiseChunk noiseChunk = chunk.m_223012_(otherChunk -> this.m_224256_((ChunkAccess)otherChunk, structureManager, Blender.m_190202_((WorldGenRegion)level), random));
        ChunkPos chunkPos = chunk.m_7697_();
        Aquifer aquifer = noiseChunk.m_188817_();
        CarvingMask carvingMask = ((ProtoChunk)chunk).m_183613_(step);
        WorldgenRandom worldGenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_224599_()));
        BiomeManager differentBiomeManager = biomeManager.m_186687_((x, y, z) -> this.f_62137_.m_203407_(x, y, z, random.m_224579_()));
        CarvingContext carvingContext = new CarvingContext((NoiseBasedChunkGenerator)this, level.m_9598_(), chunk.m_183618_(), noiseChunk, random, ((NoiseGeneratorSettings)this.f_64318_.m_203334_()).f_188871_());
        int i = 8;
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                ChunkPos tempChunkPos = new ChunkPos(chunkPos.f_45578_ + j, chunkPos.f_45579_ + k);
                BiomeGenerationSettings biomeGenerationSettings = level.m_6325_(tempChunkPos.f_45578_, tempChunkPos.f_45579_).m_223014_(() -> this.m_223131_(this.f_62137_.m_203407_(QuartPos.m_175400_((int)tempChunkPos.m_45604_()), 0, QuartPos.m_175400_((int)tempChunkPos.m_45605_()), random.m_224579_())));
                int l = 0;
                for (Holder holder : biomeGenerationSettings.m_204187_(step)) {
                    if (holder.m_203543_().isPresent() && !WorldConfig.carvers.get(this.dimension.m_135782_().toString()).test(((ResourceKey)holder.m_203543_().get()).m_135782_())) continue;
                    ConfiguredWorldCarver configuredCarver = (ConfiguredWorldCarver)holder.m_203334_();
                    worldGenRandom.m_190068_(seed + (long)l, tempChunkPos.f_45578_, tempChunkPos.f_45579_);
                    if (configuredCarver.m_224896_((RandomSource)worldGenRandom)) {
                        configuredCarver.m_224898_(carvingContext, chunk, arg_0 -> ((BiomeManager)differentBiomeManager).m_204214_(arg_0), (RandomSource)worldGenRandom, aquifer, tempChunkPos, carvingMask);
                    }
                    ++l;
                }
            }
        }
    }

    @Nonnull
    public NoiseColumn m_214184_(int posX, int posZ, @Nonnull LevelHeightAccessor level, @Nonnull RandomState randomState) {
        return new NoiseColumn(0, new BlockState[0]);
    }

    public void m_213609_(@Nonnull WorldGenLevel level, @Nonnull ChunkAccess chunk, @Nonnull StructureManager structureManager) {
        ChunkPos chunkPos = chunk.m_7697_();
        SectionPos sectionPos = SectionPos.m_123196_((ChunkPos)chunkPos, (int)level.m_151560_());
        BlockPos blockpos = sectionPos.m_123249_();
        Registry structureRegistry = level.m_9598_().m_175515_(Registries.f_256944_);
        Map<Integer, List<Structure>> map = structureRegistry.m_123024_().collect(Collectors.groupingBy(structure -> structure.m_226619_().ordinal()));
        List stepFeatureDataList = (List)this.f_223020_.get();
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_224599_()));
        long decorationSeed = worldgenRandom.m_64690_(level.m_7328_(), blockpos.m_123341_(), blockpos.m_123343_());
        ObjectArraySet possibleBiomes = new ObjectArraySet();
        ChunkPos.m_45596_((ChunkPos)sectionPos.m_123251_(), (int)1).forEach(arg_0 -> SkyblockNoiseBasedChunkGenerator.lambda$applyBiomeDecoration$10(level, (Set)possibleBiomes, arg_0));
        possibleBiomes.retainAll(this.f_62137_.m_207840_());
        int dataSize = stepFeatureDataList.size();
        try {
            Registry placedFeatureRegistry = level.m_9598_().m_175515_(Registries.f_256988_);
            int maxDecorations = Math.max(GenerationStep.Decoration.values().length, dataSize);
            for (int i = 0; i < maxDecorations; ++i) {
                Structure structure22;
                int index = 0;
                if (structureManager.m_220467_()) {
                    for (Structure structure22 : map.getOrDefault(i, Collections.emptyList())) {
                        ResourceLocation location = level.m_9598_().m_175515_(Registries.f_256944_).m_7981_((Object)structure22);
                        if (!StructuresConfig.generationStructures.test(location)) continue;
                        worldgenRandom.m_190064_(decorationSeed, index, i);
                        Supplier<String> currentlyGenerating = () -> structureRegistry.m_7854_((Object)structure22).map(Object::toString).orElseGet(structure22::toString);
                        try {
                            level.m_143497_(currentlyGenerating);
                            structureManager.m_220504_(sectionPos, structure22).forEach(structureStart -> structureStart.m_226850_(level, structureManager, (ChunkGenerator)this, (RandomSource)worldgenRandom, SkyblockNoiseBasedChunkGenerator.m_187717_((ChunkAccess)chunk), chunkPos));
                        }
                        catch (Exception e) {
                            CrashReport report = CrashReport.m_127521_((Throwable)e, (String)"Feature placement");
                            report.m_127514_("Feature").m_128165_("Description", currentlyGenerating::get);
                            throw new ReportedException(report);
                        }
                        ++index;
                    }
                }
                if (i >= dataSize) continue;
                IntArraySet mapping = new IntArraySet();
                structure22 = possibleBiomes.iterator();
                while (structure22.hasNext()) {
                    Holder holder = (Holder)structure22.next();
                    List holderSets = ((BiomeGenerationSettings)this.f_223021_.apply(holder)).m_47818_();
                    if (i >= holderSets.size()) continue;
                    HolderSet featureHolderSet = (HolderSet)holderSets.get(i);
                    FeatureSorter.StepFeatureData stepFeatureData = (FeatureSorter.StepFeatureData)stepFeatureDataList.get(i);
                    featureHolderSet.m_203614_().map(Holder::m_203334_).forEach(arg_0 -> SkyblockNoiseBasedChunkGenerator.lambda$applyBiomeDecoration$13((IntSet)mapping, stepFeatureData, arg_0));
                }
                int mappingSize = mapping.size();
                int[] array = mapping.toIntArray();
                Arrays.sort(array);
                FeatureSorter.StepFeatureData stepFeatureData = (FeatureSorter.StepFeatureData)stepFeatureDataList.get(i);
                for (int j = 0; j < mappingSize; ++j) {
                    int featureIndex = array[j];
                    PlacedFeature placedfeature = (PlacedFeature)stepFeatureData.f_220624_().get(featureIndex);
                    Optional optionalResourceKey = placedfeature.f_191775_().m_203543_();
                    if (optionalResourceKey.isPresent() && !StructuresConfig.generationFeatures.test(((ResourceKey)optionalResourceKey.get()).m_135782_())) continue;
                    Supplier<String> currentlyGenerating = () -> placedFeatureRegistry.m_7854_((Object)placedfeature).map(Object::toString).orElseGet(() -> ((PlacedFeature)placedfeature).toString());
                    worldgenRandom.m_190064_(decorationSeed, featureIndex, i);
                    try {
                        level.m_143497_(currentlyGenerating);
                        placedfeature.m_226377_(level, (ChunkGenerator)this, (RandomSource)worldgenRandom, blockpos);
                        continue;
                    }
                    catch (Exception e) {
                        CrashReport report = CrashReport.m_127521_((Throwable)e, (String)"Feature placement");
                        report.m_127514_("Feature").m_128165_("Description", currentlyGenerating::get);
                        throw new ReportedException(report);
                    }
                }
            }
            level.m_143497_(null);
        }
        catch (Exception e) {
            CrashReport report = CrashReport.m_127521_((Throwable)e, (String)"Biome decoration");
            report.m_127514_("Generation").m_128159_("CenterX", (Object)chunkPos.f_45578_).m_128159_("CenterZ", (Object)chunkPos.f_45579_).m_128159_("Seed", (Object)decorationSeed);
            throw new ReportedException(report);
        }
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public List<FlatLayerInfo> getLayerInfos() {
        return this.layerInfos;
    }

    private static /* synthetic */ void lambda$applyBiomeDecoration$13(IntSet mapping, FeatureSorter.StepFeatureData stepFeatureData, PlacedFeature p_223174_) {
        mapping.add(stepFeatureData.f_220625_().applyAsInt(p_223174_));
    }

    private static /* synthetic */ void lambda$applyBiomeDecoration$10(WorldGenLevel level, Set possibleBiomes, ChunkPos pos) {
        ChunkAccess chunkaccess = level.m_6325_(pos.f_45578_, pos.f_45579_);
        for (LevelChunkSection chunkSection : chunkaccess.m_7103_()) {
            chunkSection.m_187996_().m_196879_(possibleBiomes::add);
        }
    }
}

