/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.util.SkyPaths;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.moddingx.libx.config.ConfigManager;
import org.moddingx.libx.impl.config.ConfigImpl;
import org.moddingx.libx.impl.config.ConfigKey;
import org.moddingx.libx.impl.config.ConfigState;

public class DumpUtil {
    public static int MANIFEST_VERSION = 1;
    public static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private static final Map<String, IModInfo> MOD_INFO_MAP = ModList.get().getMods().stream().collect(Collectors.toMap(IModInfo::getModId, info -> info));

    public static Component getIssueUrl() {
        String url;
        IModInfo modInfo = MOD_INFO_MAP.get(SkyblockBuilder.getInstance().modid);
        IModFileInfo owningFile = modInfo.getOwningFile();
        if (owningFile instanceof ModFileInfo) {
            ModFileInfo info = (ModFileInfo)owningFile;
            url = info.getIssueURL().toString();
        } else {
            url = "https://www.github.com/ChaoticTrials/SkyblockBuilder";
        }
        return Component.m_237113_((String)url).m_130948_(Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE}).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url + "/new?template=dump_bug_report.yml")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.link.open"))));
    }

    public static Path createZip(boolean includeConfigs, boolean includeTemplates, boolean includeLevelDat, boolean includeLog, boolean includeCrashReport, boolean includeSkyblockBuilderWorldData) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        Path file = SkyPaths.DUMPS.resolve(DATE_FORMAT.format(new Date()) + ".zip");
        try (ZipOutputStream zipStream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0])));){
            zipStream.setLevel(9);
            JsonObject settings = new JsonObject();
            settings.addProperty("configs", Boolean.valueOf(includeConfigs));
            settings.addProperty("templates", Boolean.valueOf(includeTemplates));
            settings.addProperty("level_dat", Boolean.valueOf(includeLevelDat));
            settings.addProperty("log", Boolean.valueOf(includeLog));
            settings.addProperty("crash_report", Boolean.valueOf(includeCrashReport));
            settings.addProperty("world_data", Boolean.valueOf(includeSkyblockBuilderWorldData));
            JsonObject modVersions = new JsonObject();
            modVersions.addProperty(SkyblockBuilder.getInstance().modid, MOD_INFO_MAP.get(SkyblockBuilder.getInstance().modid).getVersion().toString());
            for (IModInfo.ModVersion dependency : MOD_INFO_MAP.get(SkyblockBuilder.getInstance().modid).getDependencies()) {
                IModInfo modInfo = MOD_INFO_MAP.get(dependency.getModId());
                if (modInfo == null) continue;
                modVersions.addProperty(dependency.getModId(), modInfo.getVersion().toString());
            }
            JsonArray filesArray = new JsonArray();
            if (includeConfigs) {
                DumpUtil.addDirToZip(filesArray, SkyPaths.MOD_CONFIG, zipStream, Paths.get("config", new String[0]));
                Map<ResourceLocation, String> diffs = DumpUtil.configDiffs();
                for (Map.Entry entry : diffs.entrySet()) {
                    ResourceLocation key = (ResourceLocation)entry.getKey();
                    String value = (String)entry.getValue();
                    Path filePath = Paths.get("config", "changed_values", key.m_135815_() + ".json5");
                    DumpUtil.addStringToZip(filesArray, zipStream, value, filePath);
                }
            }
            if (includeTemplates) {
                DumpUtil.addDirToZip(filesArray, SkyPaths.TEMPLATES_DIR, zipStream);
            }
            if (server != null) {
                Path data;
                Optional<Path> crashReportOptional;
                Path latestLog;
                Path levelDat;
                server.f_129744_.m_78313_();
                Path levelPath = server.f_129744_.getWorldDir().resolve(server.f_129744_.m_78277_()).toRealPath(new LinkOption[0]);
                if (includeLevelDat && (levelDat = server.f_129744_.m_78283_(LevelResource.f_78178_)).toFile().exists()) {
                    DumpUtil.addFileToZip(filesArray, zipStream, levelDat);
                }
                if (includeLog && (latestLog = FMLPaths.GAMEDIR.get().resolve("logs").resolve("latest.log")).toFile().exists()) {
                    DumpUtil.addFileToZip(filesArray, zipStream, latestLog, Paths.get("logs", "latest.log"));
                }
                if (includeCrashReport && (crashReportOptional = DumpUtil.findLatestCrashReport()).isPresent()) {
                    DumpUtil.addFileToZip(filesArray, zipStream, crashReportOptional.get(), Paths.get("logs", "crash-report.txt"));
                }
                if (includeSkyblockBuilderWorldData && (data = levelPath.resolve("data").resolve("skyblock_builder.dat")).toFile().exists()) {
                    DumpUtil.addFileToZip(filesArray, zipStream, data, Paths.get("data", "skyblock_builder.dat"));
                }
            }
            JsonObject manifest = new JsonObject();
            manifest.addProperty("manifest_version", (Number)MANIFEST_VERSION);
            manifest.addProperty("manifest_id", UUID.randomUUID().toString());
            manifest.add("settings", (JsonElement)settings);
            manifest.add("versions", (JsonElement)modVersions);
            manifest.add("files", (JsonElement)filesArray);
            DumpUtil.addStringToZip(filesArray, zipStream, SkyblockBuilder.PRETTY_GSON.toJson((JsonElement)manifest), Paths.get("manifest.json", new String[0]));
        }
        catch (IOException e) {
            SkyblockBuilder.getLogger().error("Failed to create zip file", (Throwable)e);
        }
        return file;
    }

    private static void addDirToZip(JsonArray fileCollector, Path dirPath, ZipOutputStream zipStream) throws IOException {
        DumpUtil.addDirToZip(fileCollector, dirPath, zipStream, dirPath.getFileName());
    }

    private static void addDirToZip(JsonArray fileCollector, Path dirPath, ZipOutputStream zipStream, Path parentFolder) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dirPath);){
            for (Path path : directoryStream) {
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                Path zipEntryName = parentFolder.resolve(path.getFileName());
                DumpUtil.addFileToZip(fileCollector, zipStream, path, zipEntryName);
            }
        }
    }

    private static void addFileToZip(JsonArray fileCollector, ZipOutputStream zipStream, Path filePath) throws IOException {
        DumpUtil.addFileToZip(fileCollector, zipStream, filePath, filePath.getFileName());
    }

    private static void addFileToZip(JsonArray fileCollector, ZipOutputStream zipStream, Path filePath, Path zipEntryPath) throws IOException {
        try (InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);){
            int len;
            String name = zipEntryPath.toString().replace(File.separatorChar, '/');
            ZipEntry zipEntry = new ZipEntry(name);
            zipStream.putNextEntry(zipEntry);
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > 0) {
                zipStream.write(buffer, 0, len);
            }
            zipStream.closeEntry();
            JsonObject fileData = new JsonObject();
            fileData.addProperty("name", zipEntryPath.getFileName().toString());
            fileData.addProperty("path", name);
            fileCollector.add((JsonElement)fileData);
        }
    }

    private static void addStringToZip(JsonArray fileCollector, ZipOutputStream zipStream, String content, Path zipEntryPath) throws IOException {
        String name = zipEntryPath.toString().replace(File.separatorChar, '/');
        ZipEntry zipEntry = new ZipEntry(name);
        zipStream.putNextEntry(zipEntry);
        zipStream.write(content.getBytes());
        zipStream.closeEntry();
        JsonObject fileData = new JsonObject();
        fileData.addProperty("name", zipEntryPath.getFileName().toString());
        fileData.addProperty("path", name);
        fileCollector.add((JsonElement)fileData);
    }

    private static Optional<Path> findLatestCrashReport() {
        Optional<Path> optional;
        block9: {
            Path crashReports = FMLPaths.GAMEDIR.get().resolve("crash-reports");
            if (!Files.exists(crashReports, new LinkOption[0]) || !Files.isDirectory(crashReports, new LinkOption[0])) {
                return Optional.empty();
            }
            Stream<Path> paths = Files.list(crashReports);
            try {
                optional = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).max(Comparator.comparingLong(path -> {
                    try {
                        return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                    }
                    catch (IOException e) {
                        return 0L;
                    }
                }));
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Optional.empty();
                }
            }
            paths.close();
        }
        return optional;
    }

    private static Map<ResourceLocation, String> configDiffs() {
        HashMap<ResourceLocation, String> configDiffs = new HashMap<ResourceLocation, String>();
        for (ResourceLocation id : ConfigManager.configs()) {
            if (!id.m_135827_().equals(SkyblockBuilder.getInstance().modid)) continue;
            ConfigImpl config = ConfigImpl.getConfig((ResourceLocation)id);
            ConfigState currentState = config.stateFromValues();
            ConfigState defaultState = DumpUtil.getDefaultConfigState(config);
            if (defaultState == null) continue;
            HashSet<ConfigKey> changedValues = new HashSet<ConfigKey>();
            for (ConfigKey configKey : config.keys.values()) {
                if (currentState.getValue(configKey).equals(defaultState.getValue(configKey))) continue;
                changedValues.add(configKey);
            }
            if (changedValues.isEmpty()) continue;
            String configDiff = "{\n" + DumpUtil.applyIndent(currentState.writeObject(changedValues, config.groups, 0)) + "\n}\n";
            configDiffs.put(id, configDiff);
        }
        return configDiffs;
    }

    @Nullable
    private static ConfigState getDefaultConfigState(ConfigImpl instance) {
        try {
            Field defaultStateField = ConfigImpl.class.getDeclaredField("defaultState");
            defaultStateField.setAccessible(true);
            return (ConfigState)defaultStateField.get(instance);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }

    private static String applyIndent(String input) {
        return "  " + input.replace("\n", "\n  ");
    }
}

