/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import com.mojang.datafixers.util.Pair;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.common.WorldConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import org.moddingx.libx.util.data.ResourceList;

public class BiomeSourceConverter {
    public static BiomeSource customBiomeSource(ResourceKey<Level> level, BiomeSource baseSource, HolderLookup<Biome> biomes) {
        ResourceList resourceList = WorldConfig.biomes.get(level.m_135782_().toString());
        if (resourceList != null) {
            HashSet newBiomes = new HashSet();
            for (Holder possibleBiome : baseSource.m_207840_()) {
                Optional optionalResourceKey = possibleBiome.m_203543_();
                optionalResourceKey.ifPresent(key -> {
                    ResourceLocation location = key.m_135782_();
                    if (resourceList.test(location)) {
                        newBiomes.add(possibleBiome);
                    }
                });
            }
            if (newBiomes.isEmpty()) {
                biomes.m_255209_().filter(biomeKey -> resourceList.test(biomeKey.m_135782_())).forEach(key -> newBiomes.add(biomes.m_255043_(key)));
            } else {
                SkyblockBuilder.getLogger().warn("Skipping biome filtering as all biomes were filtered out: {}", level);
                newBiomes.addAll(baseSource.m_207840_());
            }
            if (newBiomes.isEmpty()) {
                throw new IllegalStateException("No biomes selected for " + level);
            }
            if (baseSource instanceof MultiNoiseBiomeSource) {
                List parameters = new ArrayList(((MultiNoiseBiomeSource)baseSource).m_274409_().m_186850_()).stream().filter(pair -> {
                    Holder holder = (Holder)pair.getSecond();
                    Optional optionalResourceKey = holder.m_203543_();
                    return optionalResourceKey.filter(biomeResourceKey -> resourceList.test(biomeResourceKey.m_135782_())).isPresent();
                }).collect(Collectors.toList());
                if (parameters.isEmpty()) {
                    newBiomes.forEach(holder -> parameters.add(Pair.of((Object)new Climate.ParameterPoint(Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), 0L), (Object)holder)));
                }
                return MultiNoiseBiomeSource.m_274596_((Climate.ParameterList)new Climate.ParameterList(parameters));
            }
            if (baseSource instanceof TheEndBiomeSource) {
                if (newBiomes.size() == 5) {
                    List newBiomesList = newBiomes.stream().toList();
                    return new TheEndBiomeSource((Holder)newBiomesList.get(0), (Holder)newBiomesList.get(1), (Holder)newBiomesList.get(2), (Holder)newBiomesList.get(3), (Holder)newBiomesList.get(4));
                }
                SkyblockBuilder.getLogger().warn("Need to be exactly 5 biomes for '{}', currently {}", level, (Object)newBiomes.size());
            }
            SkyblockBuilder.getLogger().warn("Unable to modify dimension '{}' properly, using default", level);
        }
        return baseSource;
    }
}

