/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.network;

import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.item.ItemStructureSaver;
import de.melanx.skyblockbuilder.util.SkyPaths;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record SaveStructureMessage(ItemStack stack, String name, boolean saveToConfig, boolean ignoreAir, boolean asSnbt, boolean netherValidation) {

    public static class Serializer
    implements PacketSerializer<SaveStructureMessage> {
        public Class<SaveStructureMessage> messageClass() {
            return SaveStructureMessage.class;
        }

        public void encode(SaveStructureMessage msg, FriendlyByteBuf buffer) {
            buffer.m_130055_(msg.stack);
            buffer.m_130070_(msg.name);
            buffer.writeBoolean(msg.saveToConfig);
            buffer.writeBoolean(msg.ignoreAir);
            buffer.writeBoolean(msg.asSnbt);
            buffer.writeBoolean(msg.netherValidation);
        }

        public SaveStructureMessage decode(FriendlyByteBuf buffer) {
            return new SaveStructureMessage(buffer.m_130267_(), buffer.m_130136_(Short.MAX_VALUE), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean());
        }
    }

    public static class Handler
    implements PacketHandler<SaveStructureMessage> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(SaveStructureMessage msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return true;
            }
            ServerLevel level = (ServerLevel)player.m_9236_();
            String name = ItemStructureSaver.saveSchematic((Level)level, msg.stack, msg.saveToConfig, msg.ignoreAir, msg.asSnbt, msg.netherValidation, msg.name);
            if (name == null) {
                player.m_5661_((Component)Component.m_237113_((String)"Failed to save, look at latest.log for more information").m_130940_(ChatFormatting.RED), false);
                return true;
            }
            ItemStack stack = ItemStructureSaver.removeTags(msg.stack);
            player.m_21008_(InteractionHand.MAIN_HAND, stack);
            Path fullPath = msg.saveToConfig ? SkyPaths.MOD_CONFIG.resolve(name) : SkyPaths.MOD_EXPORTS.resolve(name);
            Path savedPath = FMLPaths.GAMEDIR.get().relativize(fullPath);
            MutableComponent component = Component.m_237110_((String)"skyblockbuilder.schematic.saved", (Object[])new Object[]{savedPath.toString().replace('\\', '/')});
            SkyblockBuilder.getLogger().info("Saved structure (and spawn points) to: {}", (Object)fullPath);
            player.m_5661_((Component)component, true);
            return true;
        }
    }
}

