/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.network;

import de.melanx.skyblockbuilder.util.DumpUtil;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record CreateSkyblockDump(boolean includeConfigs, boolean includeTemplates, boolean includeLevelDat, boolean includeLog, boolean includeCrashReport, boolean includeSkyblockBuilderWorldData) {

    public static class Serializer
    implements PacketSerializer<CreateSkyblockDump> {
        public Class<CreateSkyblockDump> messageClass() {
            return CreateSkyblockDump.class;
        }

        public void encode(CreateSkyblockDump msg, FriendlyByteBuf buffer) {
            buffer.writeBoolean(msg.includeConfigs);
            buffer.writeBoolean(msg.includeTemplates);
            buffer.writeBoolean(msg.includeLevelDat);
            buffer.writeBoolean(msg.includeLog);
            buffer.writeBoolean(msg.includeCrashReport);
            buffer.writeBoolean(msg.includeSkyblockBuilderWorldData);
        }

        public CreateSkyblockDump decode(FriendlyByteBuf buffer) {
            return new CreateSkyblockDump(buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean());
        }
    }

    public static class Handler
    implements PacketHandler<CreateSkyblockDump> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(CreateSkyblockDump msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return true;
            }
            if (!player.m_20310_(3)) {
                player.m_213846_((Component)Component.m_237115_((String)"skyblockbuilder.screen.dump.failure").m_130940_(ChatFormatting.RED));
                return true;
            }
            Path zip = DumpUtil.createZip(msg.includeConfigs, msg.includeTemplates, msg.includeLevelDat, msg.includeLog, msg.includeCrashReport, msg.includeSkyblockBuilderWorldData);
            player.m_213846_((Component)Component.m_237110_((String)"skyblockbuilder.screen.dump.success", (Object[])new Object[]{FMLPaths.GAMEDIR.get().relativize(zip)}).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"skyblockbuilder.screen.dump.success.server")));
            player.m_213846_((Component)Component.m_237115_((String)"skyblockbuilder.screen.dump.create_issue").m_130946_(" ").m_7220_(DumpUtil.getIssueUrl()));
            return true;
        }
    }
}

