/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.data;

import de.melanx.skyblockbuilder.commands.invitation.InviteCommand;
import de.melanx.skyblockbuilder.compat.minemention.MineMentionCompat;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyblockbuilder.world.IslandPos;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;

public class Team {
    private final SkyblockSavedData data;
    private final Set<UUID> players;
    private final Set<UUID> joinRequests;
    private final Set<TemplatesConfig.Spawn> possibleSpawns;
    private final Set<TemplatesConfig.Spawn> defaultPossibleSpawns;
    private final Map<String, Set<PlacedSpread>> placedSpreads;
    private UUID teamId;
    private IslandPos island;
    private String name;
    private boolean allowVisits;
    private boolean allowJoinRequests;
    private long createdAt;
    private long lastChanged;

    private Team(SkyblockSavedData data) {
        this(data, null, null);
    }

    public Team(SkyblockSavedData data, IslandPos island) {
        this(data, island, UUID.randomUUID());
    }

    public Team(SkyblockSavedData data, IslandPos island, UUID teamId) {
        this.data = data;
        this.island = island;
        this.players = new HashSet<UUID>();
        this.possibleSpawns = new HashSet<TemplatesConfig.Spawn>();
        this.defaultPossibleSpawns = new HashSet<TemplatesConfig.Spawn>();
        this.placedSpreads = new HashMap<String, Set<PlacedSpread>>();
        this.joinRequests = new HashSet<UUID>();
        this.teamId = teamId;
        this.allowVisits = false;
        this.createdAt = System.currentTimeMillis();
        this.lastChanged = System.currentTimeMillis();
    }

    public static Team create(SkyblockSavedData data, CompoundTag tag) {
        Team team = new Team(data);
        team.deserializeNBT(tag);
        return team;
    }

    public boolean isSpawn() {
        return Objects.equals(this.teamId, SkyblockSavedData.SPAWN_ID);
    }

    public String getName() {
        return this.name;
    }

    public UUID getId() {
        return this.teamId;
    }

    public void setName(String name) {
        this.name = name;
        this.updateLastChanged();
    }

    public IslandPos getIsland() {
        return this.island;
    }

    public void setIsland(IslandPos island) {
        this.island = island;
        this.updateLastChanged();
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }

    public void setPlayers(Collection<UUID> players) {
        this.players.clear();
        PlayerList playerList = this.getLevel().m_7654_().m_6846_();
        if (ModList.get().isLoaded("minemention")) {
            for (UUID id : players) {
                MineMentionCompat.updateMentions(playerList.m_11259_(id));
            }
        }
        this.players.addAll(players);
        this.updateLastChanged();
    }

    public Set<TemplatesConfig.Spawn> getPossibleSpawns() {
        return Set.copyOf(this.possibleSpawns);
    }

    public Set<TemplatesConfig.Spawn> getDefaultPossibleSpawns() {
        return Set.copyOf(this.defaultPossibleSpawns);
    }

    public void setPossibleSpawns(Collection<TemplatesConfig.Spawn> spawns) {
        this.possibleSpawns.clear();
        this.defaultPossibleSpawns.clear();
        this.possibleSpawns.addAll(spawns);
        this.defaultPossibleSpawns.addAll(spawns);
        this.updateLastChanged();
    }

    public void addPossibleSpawn(TemplatesConfig.Spawn spawn) {
        this.possibleSpawns.add(spawn);
        this.updateLastChanged();
    }

    public void addPossibleSpawn(BlockPos pos, WorldUtil.Directions direction) {
        this.addPossibleSpawn(new TemplatesConfig.Spawn(pos, direction));
    }

    public boolean removePossibleSpawn(BlockPos pos) {
        if (this.possibleSpawns.size() <= 1) {
            return false;
        }
        for (TemplatesConfig.Spawn possibleSpawn : this.possibleSpawns) {
            if (!possibleSpawn.pos().equals((Object)pos)) continue;
            boolean remove = this.possibleSpawns.remove(possibleSpawn);
            this.updateLastChanged();
            return remove;
        }
        return false;
    }

    public boolean allowsVisits() {
        return this.allowVisits;
    }

    public boolean toggleAllowVisits() {
        this.allowVisits = !this.allowVisits;
        this.updateLastChanged();
        return this.allowVisits;
    }

    public void setAllowVisit(boolean enabled) {
        if (this.allowVisits != enabled) {
            this.allowVisits = enabled;
            this.updateLastChanged();
        }
    }

    public boolean addPlayer(UUID player) {
        boolean added = this.players.add(player);
        if (added) {
            if (ModList.get().isLoaded("minemention")) {
                MineMentionCompat.updateMentions(this.getLevel().m_7654_().m_6846_().m_11259_(player));
            }
            if (!this.isSpawn()) {
                this.data.getSpawn().removePlayer(player);
            }
            this.data.getOrCreateMetaInfo(player).setTeamId(this.teamId);
            this.updateLastChanged();
        }
        return added;
    }

    public boolean addPlayer(Player player) {
        return this.addPlayer(player.m_36316_().getId());
    }

    public boolean addPlayers(Collection<UUID> players) {
        boolean added = this.players.addAll(players);
        if (added) {
            if (ModList.get().isLoaded("minemention")) {
                for (UUID id : players) {
                    MineMentionCompat.updateMentions(this.getLevel().m_7654_().m_6846_().m_11259_(id));
                    this.data.getOrCreateMetaInfo(id).setTeamId(this.teamId);
                }
            }
            this.updateLastChanged();
        }
        return added;
    }

    public boolean removePlayer(Player player) {
        return this.removePlayer(player.m_36316_().getId());
    }

    public boolean removePlayer(UUID player) {
        boolean removed = this.players.remove(player);
        if (ModList.get().isLoaded("minemention")) {
            MineMentionCompat.updateMentions(this.getLevel().m_7654_().m_6846_().m_11259_(player));
        }
        if (removed) {
            this.data.getOrCreateMetaInfo(player).addPreviousTeamId(this.teamId);
            this.lastChanged = System.currentTimeMillis();
        }
        this.data.m_77762_();
        return removed;
    }

    public void removePlayers(Collection<UUID> players) {
        for (UUID id : players) {
            boolean removed = this.players.remove(id);
            if (ModList.get().isLoaded("minemention")) {
                MineMentionCompat.updateMentions(this.getLevel().m_7654_().m_6846_().m_11259_(id));
            }
            if (!removed) continue;
            this.data.getOrCreateMetaInfo(id).addPreviousTeamId(this.teamId);
        }
        this.updateLastChanged();
    }

    public void removeAllPlayers() {
        this.removePlayers(this.players);
    }

    public boolean hasPlayer(UUID player) {
        return this.players.contains(player);
    }

    public boolean hasPlayer(Player player) {
        return this.hasPlayer(player.m_36316_().getId());
    }

    public boolean isEmpty() {
        return this.players.isEmpty();
    }

    public boolean allowsJoinRequests() {
        return this.allowJoinRequests;
    }

    public boolean toggleAllowJoinRequest() {
        this.allowJoinRequests = !this.allowJoinRequests;
        this.updateLastChanged();
        return this.allowJoinRequests;
    }

    public void setAllowJoinRequest(boolean enabled) {
        if (this.allowJoinRequests != enabled) {
            this.allowJoinRequests = enabled;
            this.updateLastChanged();
        }
    }

    public Set<UUID> getJoinRequests() {
        return this.joinRequests;
    }

    public void addJoinRequest(Player player) {
        this.addJoinRequest(player.m_36316_().getId());
    }

    public void addJoinRequest(UUID id) {
        this.joinRequests.add(id);
        this.data.m_77762_();
    }

    public void removeJoinRequest(Player player) {
        this.removeJoinRequest(player.m_36316_().getId());
    }

    public void removeJoinRequest(UUID id) {
        this.joinRequests.remove(id);
        this.data.m_77762_();
    }

    public void resetJoinRequests() {
        this.joinRequests.clear();
        this.data.m_77762_();
    }

    public void addSpread(String spreadName, BlockPos pos, BlockPos size) {
        this.addSpread(new PlacedSpread(spreadName, pos, size));
    }

    public void addSpread(PlacedSpread placedSpread) {
        this.placedSpreads.computeIfAbsent(placedSpread.name(), s -> new HashSet()).add(placedSpread);
        this.data.m_77762_();
    }

    public Map<String, Set<PlacedSpread>> getPlacedSpreads() {
        return this.placedSpreads;
    }

    public Set<PlacedSpread> getPlacedSpreads(String spreadName) {
        return this.placedSpreads.containsKey(spreadName) ? this.placedSpreads.get(spreadName) : Set.of();
    }

    public Set<String> getAllSpreadNames() {
        return this.placedSpreads.keySet();
    }

    public void sendJoinRequest(Player requestingPlayer) {
        this.addJoinRequest(requestingPlayer.m_36316_().getId());
        MutableComponent component = Component.m_237110_((String)"skyblockbuilder.event.join_request0", (Object[])new Object[]{requestingPlayer.m_5446_()});
        component.m_7220_((Component)Component.m_237113_((String)("/skyblock team accept " + requestingPlayer.m_5446_().getString())).m_6270_(Style.f_131099_.m_131144_(InviteCommand.COPY_TEXT).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/skyblock team accept " + requestingPlayer.m_5446_().getString())).m_131152_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GOLD})));
        component.m_7220_((Component)Component.m_237115_((String)"skyblockbuilder.event.join_request1"));
        this.broadcast(component, Style.f_131099_.m_131157_(ChatFormatting.GOLD));
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getLastChanged() {
        return this.lastChanged;
    }

    public void updateLastChanged() {
        this.lastChanged = System.currentTimeMillis();
        this.data.m_77762_();
    }

    @Nullable
    public ServerLevel getLevel() {
        return this.data.getLevel();
    }

    public void broadcast(MutableComponent msg, Style style) {
        if (this.getLevel() == null || this.getLevel().f_46443_) {
            return;
        }
        PlayerList playerList = this.getLevel().m_7654_().m_6846_();
        this.players.forEach(uuid -> {
            ServerPlayer player = playerList.m_11259_(uuid);
            if (player != null) {
                MutableComponent component = Component.m_237113_((String)("[" + this.name + "] ")).m_6270_(Style.f_131099_);
                player.m_213846_((Component)component.m_7220_((Component)msg.m_130948_(style)));
            }
        });
    }

    @Nonnull
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("TeamId", this.teamId);
        nbt.m_128365_("Island", (Tag)this.island.toTag());
        nbt.m_128359_("Name", this.name != null ? this.name : "");
        nbt.m_128379_("Visits", this.allowVisits);
        nbt.m_128379_("AllowJoinRequests", this.allowJoinRequests);
        nbt.m_128356_("CreatedAt", this.createdAt);
        nbt.m_128356_("LastChanged", this.lastChanged);
        ListTag players = new ListTag();
        for (UUID uUID : this.players) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128362_("Player", uUID);
            players.add((Object)compoundTag);
        }
        ListTag spawns = new ListTag();
        for (TemplatesConfig.Spawn spawn : this.possibleSpawns) {
            CompoundTag compoundTag = WorldUtil.getPosTag(spawn.pos());
            compoundTag.m_128359_("Direction", spawn.direction().name());
            spawns.add((Object)compoundTag);
        }
        ListTag listTag = new ListTag();
        for (TemplatesConfig.Spawn spawn : this.defaultPossibleSpawns) {
            CompoundTag posTag = WorldUtil.getPosTag(spawn.pos());
            posTag.m_128359_("Direction", spawn.direction().name());
            listTag.add((Object)posTag);
        }
        ListTag listTag2 = new ListTag();
        for (UUID id : this.joinRequests) {
            CompoundTag idTag = new CompoundTag();
            idTag.m_128362_("Id", id);
            listTag2.add((Object)idTag);
        }
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<String, Set<PlacedSpread>> entry : this.placedSpreads.entrySet()) {
            ListTag namedSpreads = new ListTag();
            for (PlacedSpread placedSpread : entry.getValue()) {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("Name", placedSpread.name());
                tag.m_128365_("Pos", (Tag)WorldUtil.getPosTag(placedSpread.pos()));
                tag.m_128365_("Size", (Tag)WorldUtil.getPosTag(placedSpread.size()));
                namedSpreads.add((Object)tag);
            }
            compoundTag.m_128365_(entry.getKey(), (Tag)namedSpreads);
        }
        nbt.m_128365_("PlacedSpreads", (Tag)compoundTag);
        nbt.m_128365_("Players", (Tag)players);
        nbt.m_128365_("Spawns", (Tag)spawns);
        nbt.m_128365_("DefaultSpawns", (Tag)listTag);
        nbt.m_128365_("JoinRequests", (Tag)listTag2);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.teamId = nbt.m_128342_("TeamId");
        this.island = IslandPos.fromTag(nbt.m_128469_("Island"));
        this.name = nbt.m_128461_("Name");
        this.allowVisits = nbt.m_128471_("Visits");
        this.allowJoinRequests = nbt.m_128471_("AllowJoinRequests");
        this.createdAt = nbt.m_128454_("CreatedAt");
        this.lastChanged = nbt.m_128454_("LastChanged");
        ListTag players = nbt.m_128437_("Players", 10);
        this.players.clear();
        for (Object player : players) {
            this.players.add(((CompoundTag)player).m_128342_("Player"));
        }
        ListTag spawns = nbt.m_128437_("Spawns", 10);
        this.possibleSpawns.clear();
        for (Object tag : spawns) {
            CompoundTag posTag = (CompoundTag)tag;
            BlockPos pos = WorldUtil.getPosFromTag(posTag);
            WorldUtil.Directions direction = WorldUtil.Directions.valueOf(posTag.m_128461_("Direction"));
            this.possibleSpawns.add(new TemplatesConfig.Spawn(pos, direction));
        }
        ListTag defaultSpawns = nbt.m_128437_("DefaultSpawns", 10);
        this.defaultPossibleSpawns.clear();
        for (Object tag : defaultSpawns) {
            CompoundTag posTag = (CompoundTag)tag;
            BlockPos pos = WorldUtil.getPosFromTag(posTag);
            WorldUtil.Directions direction = WorldUtil.Directions.valueOf(posTag.m_128461_("Direction"));
            this.defaultPossibleSpawns.add(new TemplatesConfig.Spawn(pos, direction));
        }
        ListTag joinRequests = nbt.m_128437_("JoinRequests", 10);
        this.joinRequests.clear();
        for (Tag id : joinRequests) {
            this.joinRequests.add(((CompoundTag)id).m_128342_("Id"));
        }
        CompoundTag placedSpreads = nbt.m_128469_("PlacedSpreads");
        this.placedSpreads.clear();
        for (String key : placedSpreads.m_128431_()) {
            ListTag list = placedSpreads.m_128437_(key, 10);
            HashSet<PlacedSpread> namedSpreads = new HashSet<PlacedSpread>();
            for (Tag tag : list) {
                CompoundTag ctag = (CompoundTag)tag;
                String name = ctag.m_128461_("Name");
                BlockPos pos = WorldUtil.getPosFromTag(ctag.m_128469_("Pos"));
                BlockPos size = WorldUtil.getPosFromTag(ctag.m_128469_("Size"));
                PlacedSpread placedSpread = new PlacedSpread(name, pos, size);
                namedSpreads.add(placedSpread);
            }
            this.placedSpreads.put(key, namedSpreads);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Team)) {
            return false;
        }
        Team team = (Team)o;
        return this.name.equals(team.name) && this.island.equals(team.island);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result * this.island.hashCode();
        return result;
    }

    public record PlacedSpread(String name, BlockPos pos, BlockPos size) {
    }
}

