/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.operator;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.config.common.InventoryConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.data.TemplateData;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.util.NameGenerator;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class ManageCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"manage").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"islandShape").then(Commands.m_82129_((String)"template", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.TEMPLATES).executes(context -> ManageCommand.refreshIsland((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"template")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"teams").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").executes(context -> ManageCommand.deleteEmptyTeams((CommandSourceStack)context.getSource()))).then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.ALL_TEAMS).executes(context -> ManageCommand.clearTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"create").executes(context -> ManageCommand.createTeam((CommandSourceStack)context.getSource(), false))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> ManageCommand.createTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), false))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"createAndJoin").executes(context -> ManageCommand.createTeam((CommandSourceStack)context.getSource(), true))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> ManageCommand.createTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), true))))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.ALL_TEAMS).executes(context -> ManageCommand.deleteTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team"))))))).then(Commands.m_82127_((String)"addPlayer").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.ALL_TEAMS).executes(context -> ManageCommand.addToTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team"), EntityArgument.m_91477_((CommandContext)context, (String)"players"))))))).then(Commands.m_82127_((String)"kickPlayer").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> ManageCommand.removeFromTeam((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
    }

    private static int refreshIsland(CommandSourceStack source, String name) {
        TemplateLoader.setTemplate(TemplateLoader.getConfiguredTemplate(name));
        TemplateData.get(source.m_81372_()).refreshTemplate();
        source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.success.reset_island", (Object[])new Object[]{name}), true);
        return 1;
    }

    private static int deleteEmptyTeams(CommandSourceStack source) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        int i = 0;
        Iterator<Team> itr = data.getTeams().iterator();
        while (itr.hasNext()) {
            Team team = itr.next();
            if (SkyblockHooks.onManageDeleteTeam(source, team) || !team.isEmpty()) continue;
            itr.remove();
            ++i;
        }
        data.m_77762_();
        int teamsAmount = i;
        source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.success.delete_multiple_teams", (Object[])new Object[]{teamsAmount}).m_130940_(ChatFormatting.GREEN), true);
        return 1;
    }

    private static int clearTeam(CommandSourceStack source, String teamName) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Team team = data.getTeam(teamName);
        if (team == null) {
            source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.error.team_not_exist").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (SkyblockHooks.onManageClearTeam(source, team)) {
            source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.denied.clear_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        int i = team.getPlayers().size();
        data.removeAllPlayersFromTeam(team);
        RandomUtility.deleteTeamIfEmpty(data, team);
        source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.success.remove_all_players_from_team", (Object[])new Object[]{i}).m_130940_(ChatFormatting.RED), true);
        return 1;
    }

    private static int createTeam(CommandSourceStack source, boolean join) throws CommandSyntaxException {
        String team;
        WorldUtil.checkSkyblock(source);
        Random rand = new Random();
        do {
            team = NameGenerator.randomName(rand);
        } while (SkyblockSavedData.get((Level)source.m_81372_()).teamExists(team));
        return ManageCommand.createTeam(source, team, join);
    }

    private static int createTeam(CommandSourceStack source, String name, boolean join) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Pair<Boolean, String> result = SkyblockHooks.onManageCreateTeam(source, name, join);
        if (((Boolean)result.getLeft()).booleanValue()) {
            source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.denied.create_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        Team team = data.createTeam((String)result.getRight());
        if (team == null) {
            source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.error.team_already_exist", (Object[])new Object[]{result.getRight()}).m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (join) {
            try {
                ServerPlayer player = source.m_81375_();
                if (data.getTeamFromPlayer((Player)player) != null) {
                    source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.error.user_has_team").m_130940_(ChatFormatting.RED), false);
                    return 0;
                }
                data.addPlayerToTeam(team, (Player)player);
                WorldUtil.teleportToIsland(player, team);
            }
            catch (CommandSyntaxException e) {
                source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.error.user_no_player").m_130940_(ChatFormatting.RED), false);
                return 1;
            }
        }
        source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.success.create_team", (Object[])new Object[]{result.getRight()}).m_130940_(ChatFormatting.GREEN), true);
        return 1;
    }

    private static int deleteTeam(CommandSourceStack source, String team) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        if (!data.teamExists(team)) {
            source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.error.team_not_exist").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (SkyblockHooks.onManageDeleteTeam(source, data.getTeam(team))) {
            source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.denied.delete_team"), false);
            return 0;
        }
        HashSet<UUID> players = new HashSet<UUID>(data.getTeam(team).getPlayers());
        if (!data.deleteTeam(team)) {
            source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.error.delete_team", (Object[])new Object[]{team}).m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        PlayerList playerList = source.m_81377_().m_6846_();
        Team spawn = data.getSpawn();
        players.forEach(id -> {
            ServerPlayer player = playerList.m_11259_(id);
            if (player != null) {
                if (InventoryConfig.dropItems) {
                    RandomUtility.dropInventories((Player)player);
                }
                WorldUtil.teleportToIsland(player, spawn);
            }
        });
        source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.success.delete_one_team", (Object[])new Object[]{team}).m_130940_(ChatFormatting.GREEN), true);
        return 1;
    }

    private static int addToTeam(CommandSourceStack source, String teamName, Collection<ServerPlayer> players) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        if (!data.teamExists(teamName)) {
            source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.error.team_not_exist").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        Team island = data.getTeam(teamName);
        Pair<Boolean, Set<ServerPlayer>> result = SkyblockHooks.onManageAddToTeam(source, island, players);
        if (((Boolean)result.getLeft()).booleanValue()) {
            source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.denied.add_players_to_team"), false);
            return 0;
        }
        ServerPlayer added = null;
        int i = 0;
        for (ServerPlayer addedPlayer : (Set)result.getRight()) {
            if (data.hasPlayerTeam((Player)addedPlayer)) continue;
            data.addPlayerToTeam(teamName, (Player)addedPlayer);
            WorldUtil.teleportToIsland(addedPlayer, island);
            if (i == 0) {
                added = addedPlayer;
            }
            ++i;
        }
        if (i == 0) {
            source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.error.no_player_added").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (i == 1) {
            ServerPlayer finalAdded = added;
            source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.success.add_one_player", (Object[])new Object[]{finalAdded.m_5446_().getString(), teamName}).m_130940_(ChatFormatting.GREEN), true);
        } else {
            int playerAmount = i;
            source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.success.add_multiple_players", (Object[])new Object[]{playerAmount, teamName}).m_130940_(ChatFormatting.GREEN), true);
        }
        return 1;
    }

    private static int removeFromTeam(CommandSourceStack source, ServerPlayer player) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Team team = data.getTeamFromPlayer((Player)player);
        if (team == null) {
            source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.error.player_has_no_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        Pair<Boolean, Set<ServerPlayer>> result = SkyblockHooks.onManageRemoveFromTeam(source, team, (Collection<ServerPlayer>)ImmutableSet.of((Object)player));
        if (((Boolean)result.getLeft()).booleanValue()) {
            source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.denied.remove_players_from_team"), false);
            return 0;
        }
        String teamName = team.getName();
        Team spawn = data.getSpawn();
        int i = 0;
        for (ServerPlayer target : (Set)result.getRight()) {
            if (!team.hasPlayer((Player)target)) continue;
            data.removePlayerFromTeam((Player)target);
            if (InventoryConfig.dropItems) {
                RandomUtility.dropInventories((Player)target);
            }
            WorldUtil.teleportToIsland(target, spawn);
            ++i;
        }
        RandomUtility.deleteTeamIfEmpty(data, team);
        int playerAmount = i;
        source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.success.remove_multiple_players", (Object[])new Object[]{playerAmount, teamName}).m_130940_(ChatFormatting.GREEN), true);
        return 1;
    }
}

