/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.helper;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.util.SkyPaths;
import de.melanx.skyblockbuilder.util.TemplateUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public class ConvertCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"convert").requires(source -> source.m_6761_(2))).executes(ConvertCommand::convert);
    }

    private static int convert(CommandContext<CommandSourceStack> context) {
        for (File original : Objects.requireNonNull(SkyPaths.CONVERT_INPUT.toFile().listFiles())) {
            CompoundTag nbt;
            Path converted;
            String convertedName;
            Path fileName = original.toPath().getFileName();
            if (original.toString().endsWith(".nbt")) {
                convertedName = fileName.toString().substring(0, fileName.toString().length() - ".nbt".length()) + ".snbt";
                converted = SkyPaths.CONVERT_OUTPUT.resolve(convertedName);
                try {
                    nbt = TemplateUtil.readTemplate(original.toPath(), false);
                    TemplateUtil.writeTemplate(converted, nbt, true);
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.success.convert_template", (Object[])new Object[]{fileName, convertedName}), true);
                }
                catch (CommandSyntaxException | IOException e) {
                    SkyblockBuilder.getLogger().error("Failed to convert {} to {}", new Object[]{original, convertedName, e});
                }
                continue;
            }
            if (!original.toString().endsWith(".snbt")) continue;
            convertedName = fileName.toString().substring(0, fileName.toString().length() - ".snbt".length()) + ".nbt";
            converted = SkyPaths.CONVERT_OUTPUT.resolve(convertedName);
            try {
                nbt = TemplateUtil.readTemplate(original.toPath(), true);
                TemplateUtil.writeTemplate(converted, nbt, false);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.success.convert_template", (Object[])new Object[]{fileName, convertedName}), true);
            }
            catch (CommandSyntaxException | IOException e) {
                SkyblockBuilder.getLogger().error("Failed to convert {} to {}", new Object[]{original, convertedName, e});
            }
        }
        return 1;
    }
}

