/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.template.TemplateRenderer;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyPaths;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class ScreenCustomizeSkyblock
extends Screen {
    private final Screen parent;
    private final List<ConfiguredTemplate> templateMap;
    private final Consumer<ConfiguredTemplate> applyTemplate;
    private TemplateList list;
    private Button doneButton;
    private ConfiguredTemplate template;

    public ScreenCustomizeSkyblock(CreateWorldScreen parent, WorldCreationContext context) {
        super((Component)Component.m_237115_((String)"generator.skyblockbuilder.skyblock"));
        this.parent = parent;
        TemplateLoader.updateTemplates();
        this.template = TemplateLoader.getConfiguredTemplate();
        this.templateMap = TemplateLoader.getConfiguredTemplates();
        this.applyTemplate = TemplateLoader::setTemplate;
    }

    protected void m_7856_() {
        this.list = new TemplateList();
        this.m_7787_((GuiEventListener)this.list);
        this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            this.applyTemplate.accept(this.template);
            this.f_96541_.m_91152_(this.parent);
        }).m_252794_(this.f_96543_ / 2 - 155, this.f_96544_ - 28).m_253046_(150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.f_96541_.m_91152_(this.parent)).m_252794_(this.f_96543_ / 2 + 5, this.f_96544_ - 28).m_253046_(150, 20).m_253136_());
        if (this.template != null) {
            this.list.setSelected(this.list.m_6702_().stream().filter(entry -> Objects.equals(entry.template.getTemplate(), this.template.getTemplate())).findFirst().orElse(null));
        }
    }

    private void updateButtonValidity() {
        this.doneButton.f_93623_ = this.list.m_93511_() != null;
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280039_(guiGraphics);
        this.list.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, Color.WHITE.getRGB());
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"screen.skyblockbuilder.select_template"), this.f_96543_ / 2, 28, Color.GRAY.getRGB());
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.list.renderEntries(guiGraphics, mouseX, mouseY, partialTick);
    }

    private class TemplateList
    extends ObjectSelectionList<TemplateEntry> {
        private final Set<File> loggedLocations;
        private final transient Map<String, TemplateRenderer> structureCache;

        public TemplateList() {
            super(Objects.requireNonNull(ScreenCustomizeSkyblock.this.f_96541_), ScreenCustomizeSkyblock.this.f_96543_, ScreenCustomizeSkyblock.this.f_96544_, 40, ScreenCustomizeSkyblock.this.f_96544_ - 37, 40);
            this.loggedLocations = new HashSet<File>();
            this.structureCache = new HashMap<String, TemplateRenderer>();
            ScreenCustomizeSkyblock.this.templateMap.stream().sorted(Comparator.comparing(ConfiguredTemplate::getName)).forEach(entry -> this.m_7085_((AbstractSelectionList.Entry)new TemplateEntry((ConfiguredTemplate)entry)));
        }

        public boolean m_93696_() {
            return ScreenCustomizeSkyblock.this.m_7222_() == this;
        }

        public void setSelected(@Nullable TemplateEntry entry) {
            super.m_6987_((AbstractSelectionList.Entry)entry);
            if (entry != null) {
                ScreenCustomizeSkyblock.this.template = entry.template;
            }
            ScreenCustomizeSkyblock.this.updateButtonValidity();
        }

        public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            if (this.m_93511_() != null) {
                boolean useIcon;
                RenderSystem.enableBlend();
                int size = (this.f_93388_ - 220) / 2 - 40;
                boolean bl = useIcon = ((TemplateEntry)this.m_93511_()).icon != null;
                if (useIcon) {
                    int iconSize = ((TemplateEntry)this.m_93511_()).icon.m_117991_().m_85084_();
                    guiGraphics.m_280411_(((TemplateEntry)this.m_93511_()).iconLocation, 20, 85, size, size, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                } else {
                    String templateName = ((TemplateEntry)this.m_93511_()).name.getString();
                    if (!this.structureCache.containsKey(templateName)) {
                        this.structureCache.put(templateName, new TemplateRenderer(((TemplateEntry)this.m_93511_()).template.getTemplate(), size));
                    }
                    this.structureCache.get(templateName).render(guiGraphics, 103, 182);
                }
                RenderSystem.disableBlend();
            }
        }

        protected void m_239227_(@Nonnull GuiGraphics guiGraphics, int x, int y, float partialTick) {
        }

        protected void renderEntries(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.m_239227_(guiGraphics, mouseX, mouseY, partialTick);
        }

        private class TemplateEntry
        extends ObjectSelectionList.Entry<TemplateEntry> {
            private final Component name;
            private final Component desc;
            private final ConfiguredTemplate template;
            private final boolean tooLong;
            private final ResourceLocation iconLocation;
            private File iconFile;
            private final DynamicTexture icon;

            public TemplateEntry(ConfiguredTemplate template) {
                this.name = template.getNameComponent();
                this.desc = this.shortened(template.getDescriptionComponent());
                this.template = template;
                this.tooLong = !this.desc.getString().equals(template.getDescriptionComponent().getString());
                this.iconLocation = SkyblockBuilder.getInstance().resource(Util.m_137483_((String)template.getName(), ResourceLocation::m_135828_) + "/icon");
                this.iconFile = SkyPaths.ICONS_DIR.resolve(template.getName().toLowerCase(Locale.ROOT) + ".png").toFile();
                if (!this.iconFile.isFile()) {
                    if (!TemplateList.this.loggedLocations.contains(this.iconFile)) {
                        TemplateList.this.loggedLocations.add(this.iconFile);
                        SkyblockBuilder.getLogger().info("No icon set for template '{}'. Should be at this location: '{}'", (Object)template.getName(), (Object)this.iconFile);
                    }
                    this.iconFile = null;
                }
                this.icon = this.loadIcon();
            }

            public void m_6311_(@Nonnull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.m_280430_(ScreenCustomizeSkyblock.this.f_96547_, this.name, left + 5, top + 7, Color.WHITE.getRGB());
                guiGraphics.m_280430_(ScreenCustomizeSkyblock.this.f_96547_, this.desc, left + 5, top + 22, Color.GRAY.getRGB());
                if (isMouseOver && this.tooLong) {
                    guiGraphics.m_280557_(ScreenCustomizeSkyblock.this.f_96547_, this.template.getDescriptionComponent(), mouseX, mouseY);
                }
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    TemplateList.this.setSelected(this);
                    return true;
                }
                return false;
            }

            @Nonnull
            public Component m_142172_() {
                return this.name;
            }

            private DynamicTexture loadIcon() {
                if (this.iconFile != null && this.iconFile.isFile()) {
                    try {
                        DynamicTexture texture;
                        try (FileInputStream in = new FileInputStream(this.iconFile);){
                            NativeImage image = NativeImage.m_85058_((InputStream)in);
                            Validate.validState((image.m_84982_() == image.m_85084_() ? 1 : 0) != 0, (String)"Height and width must be equal.", (Object[])new Object[0]);
                            DynamicTexture tempTexture = new DynamicTexture(image);
                            Minecraft.m_91087_().f_90987_.m_118495_(this.iconLocation, (AbstractTexture)tempTexture);
                            texture = tempTexture;
                        }
                        return texture;
                    }
                    catch (Throwable throwable) {
                        SkyblockBuilder.getLogger().error("Invalid icon for template {}", (Object)this.template.getName(), (Object)throwable);
                        return null;
                    }
                }
                Minecraft.m_91087_().f_90987_.m_118513_(this.iconLocation);
                return null;
            }

            private Component shortened(Component text) {
                String string = text.getString();
                String shorten = RandomUtility.shorten(Minecraft.m_91087_().f_91062_, string, 210);
                return Component.m_237113_((String)shorten);
            }
        }
    }
}

