/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.miniserv.client;

import java.util.function.Consumer;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.miniserv.client.Client;

public abstract class ClientTask<T extends ClientTask> {
    private Consumer<T> finishCallback;
    private volatile boolean canceled;
    protected boolean runCallbackOnMcThread;
    protected final Client client = Client.getInstance();

    public abstract void start();

    public abstract void abort();

    public void onFinished() {
        if (this.finishCallback != null && !this.isCanceled()) {
            if (this.runCallbackOnMcThread) {
                WebDisplays.PROXY.enqueue(() -> this.finishCallback.accept(this));
            } else {
                this.finishCallback.accept(this);
            }
        }
    }

    public void setFinishCallback(Consumer<T> finishCallback) {
        this.finishCallback = finishCallback;
    }

    public void setRunCallbackOnMinecraftThread(boolean runCallbackOnMcThread) {
        this.runCallbackOnMcThread = runCallbackOnMcThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        ClientTask clientTask = this;
        synchronized (clientTask) {
            this.canceled = true;
        }
        Client.getInstance().wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isCanceled() {
        boolean ret;
        ClientTask clientTask = this;
        synchronized (clientTask) {
            ret = this.canceled;
        }
        return ret;
    }
}

