/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.controls.builtin;

import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.controls.ScreenControl;
import net.montoyo.wd.core.MissingPermissionException;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.utilities.data.BlockSide;
import net.montoyo.wd.utilities.data.Rotation;
import net.montoyo.wd.utilities.math.Vector2i;

public class ScreenModifyControl
extends ScreenControl {
    public static final ResourceLocation id = new ResourceLocation("webdisplays:mod_screen");
    ControlType type;
    Vector2i res;
    Rotation rotation;

    public ScreenModifyControl(Vector2i res) {
        super(id);
        this.type = ControlType.RESOLUTION;
        this.res = res;
    }

    public ScreenModifyControl(Rotation rotation) {
        super(id);
        this.type = ControlType.ROTATION;
        this.rotation = rotation;
    }

    public ScreenModifyControl(FriendlyByteBuf buf) {
        super(id);
        this.type = ControlType.values()[buf.readByte()];
        if (this.type.equals((Object)ControlType.RESOLUTION)) {
            this.res = new Vector2i((ByteBuf)buf);
        } else {
            this.rotation = Rotation.values()[buf.readByte()];
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.type.ordinal());
        if (this.res != null) {
            this.res.writeTo((ByteBuf)buf);
        } else if (this.rotation != null) {
            buf.writeByte(this.rotation.ordinal());
        }
    }

    @Override
    public void handleServer(BlockPos pos, BlockSide side, ScreenBlockEntity tes, NetworkEvent.Context ctx, Function<Integer, Boolean> permissionChecker) throws MissingPermissionException {
        this.checkPerms(32, permissionChecker, ctx.getSender());
        switch (this.type) {
            case RESOLUTION: {
                tes.setResolution(side, this.res);
                break;
            }
            case ROTATION: {
                tes.setRotation(side, this.rotation);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(BlockPos pos, BlockSide side, ScreenBlockEntity tes, NetworkEvent.Context ctx) {
        switch (this.type) {
            case RESOLUTION: {
                tes.setResolution(side, this.res);
                break;
            }
            case ROTATION: {
                tes.setRotation(side, this.rotation);
            }
        }
    }

    public static enum ControlType {
        RESOLUTION,
        ROTATION;

    }
}

