/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.config;

import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.config.annoconfg.AnnoCFG;
import net.montoyo.wd.config.annoconfg.annotation.format.CFGSegment;
import net.montoyo.wd.config.annoconfg.annotation.format.Comment;
import net.montoyo.wd.config.annoconfg.annotation.format.Config;
import net.montoyo.wd.config.annoconfg.annotation.format.Name;
import net.montoyo.wd.config.annoconfg.annotation.format.Translation;
import net.montoyo.wd.config.annoconfg.annotation.value.Default;
import net.montoyo.wd.config.annoconfg.annotation.value.IntRange;
import net.montoyo.wd.config.annoconfg.annotation.value.LongRange;

@Config(type=ModConfig.Type.COMMON)
public class CommonConfig {
    private static final AnnoCFG CFG = new AnnoCFG(FMLJavaModLoadingContext.get().getModEventBus(), CommonConfig.class);
    @Name(value="hard_recipes")
    @Comment(value={"If true, breaking the minePad is required to craft upgrades."})
    @Translation(value="config.webdisplays.hard_recipes")
    @Default(valueBoolean=true)
    public static boolean hardRecipes = true;
    @Name(value="join_message")
    @Comment(value={"Whether or not webdisplays should thank the user for using the mod"})
    @Translation(value="config.webdisplays.join_message")
    @Default(valueBoolean=true)
    public static boolean joinMessage = true;
    @Name(value="disable_ownership_thief")
    @Comment(value={"If true, the ownership thief item will be disabled"})
    @Translation(value="config.webdisplays.disable_thief")
    @Default(valueBoolean=false)
    public static boolean disableOwnershipThief = false;

    public static void init() {
    }

    public static void postLoad() {
        WebDisplays.INSTANCE.miniservPort = MiniServ.miniservPort;
        WebDisplays.INSTANCE.miniservQuota = MiniServ.miniservQuota * 1024L;
    }

    @Comment(value={"Options for the miniserver"})
    @CFGSegment(value="mini_server")
    public static class MiniServ {
        @Name(value="miniserv_port")
        @Comment(value={"The port used by miniserv. 0 to disable"})
        @Translation(value="config.webdisplays.miniserv_port")
        @IntRange(minV=0, maxV=32767)
        @Default(valueI=25566)
        public static int miniservPort = 25566;
        @Name(value="miniserv_quota")
        @Comment(value={"The amount of data that can be uploaded to miniserv, in KiB (so 1024 = 1 MiO)"})
        @Translation(value="config.webdisplays.miniserv_quota")
        @LongRange(minV=0L, maxV=0x7FFFFFFFFFFFFFFFL)
        @Default(valueL=1920L)
        public static long miniservQuota = 1024L;
    }

    @Comment(value={"Options for the in world screen blocks"})
    @CFGSegment(value="screen_options")
    public static class Screen {
        @Name(value="max_resolution_x")
        @Comment(value={"The maximum value screen's horizontal resolution, in pixels"})
        @Translation(value="config.webdisplays.max_res_x")
        @IntRange(minV=0, maxV=0x7FFFFFFF)
        @Default(valueI=1920)
        public static int maxResolutionX = 1920;
        @Name(value="max_resolution_y")
        @Comment(value={"The maximum value screen's vertical resolution, in pixels"})
        @Translation(value="config.webdisplays.max_res_y")
        @IntRange(minV=0, maxV=0x7FFFFFFF)
        @Default(valueI=1080)
        public static int maxResolutionY = 1080;
        @Name(value="max_width")
        @Comment(value={"The maximum width for the screen multiblock, in blocks"})
        @Translation(value="config.webdisplays.max_width")
        @IntRange(minV=0, maxV=0x7FFFFFFF)
        @Default(valueI=16)
        public static int maxScreenSizeX = 16;
        @Name(value="max_height")
        @Comment(value={"The maximum height for the screen multiblock, in blocks"})
        @Translation(value="config.webdisplays.max_height")
        @IntRange(minV=0, maxV=0x7FFFFFFF)
        @Default(valueI=16)
        public static int maxScreenSizeY = 16;
    }

    @Comment(value={"Options for the browsers (both the minePad and the screens)"})
    @CFGSegment(value="browser_options")
    public static class Browser {
        @Name(value="blacklist")
        @Comment(value={"The page which screens should open up to when turning on"})
        @Translation(value="config.webdisplays.blacklist")
        @Default(valueStr="")
        public static String[] blacklist = new String[0];
        @Name(value="home_page")
        @Comment(value={"The page which screens should open up to when turning on"})
        @Translation(value="config.webdisplays.home_page")
        @Default(valueStr="mod://webdisplays/main.html")
        public static String homepage = "mod://webdisplays/main.html";
    }
}

