/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.montoyo.wd.miniserv.client.Client;
import net.montoyo.wd.miniserv.client.ClientTaskGetFile;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.serialization.Util;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandler;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;

public class WDScheme
implements CefResourceHandler {
    private static final String ERROR_PAGE = "<!DOCTYPE html><html><head></head><body><h1>%d %s</h1><hr /><i>Miniserv powered by WebDisplays</i></body></html>";
    private ClientTaskGetFile task;
    private boolean isErrorPage;
    String url;
    boolean onlyError = false;
    private byte[] dataToWrite;
    private int dataOffset;
    private int amountToWrite;

    public WDScheme(String url) {
        this.url = url;
    }

    public boolean processRequest(CefRequest cefRequest, CefCallback cefCallback) {
        UUID uuid;
        this.url = cefRequest.getURL();
        this.url = this.url.substring("webdisplays://".length());
        int pos = this.url.indexOf(47);
        if (pos < 0) {
            return false;
        }
        String uuidStr = this.url.substring(0, pos);
        String fileStr = this.url.substring(pos + 1);
        fileStr = URLDecoder.decode(fileStr, StandardCharsets.UTF_8);
        if (uuidStr.isEmpty() || Util.isFileNameInvalid(fileStr)) {
            this.onlyError = true;
            cefCallback.Continue();
            return true;
        }
        try {
            uuid = UUID.fromString(uuidStr);
        }
        catch (IllegalArgumentException ex) {
            this.onlyError = true;
            cefCallback.Continue();
            return true;
        }
        this.task = new ClientTaskGetFile(uuid, fileStr);
        boolean doContinue = Client.getInstance().addTask(this.task);
        if (doContinue) {
            cefCallback.Continue();
        }
        return doContinue;
    }

    public void getResponseHeaders(CefResponse cefResponse, IntRef contentLength, StringRef redir) {
        String errStr;
        int errCode;
        int status;
        if (this.onlyError) {
            status = 1;
        } else {
            Log.info("Waiting for response...", new Object[0]);
            status = this.task.waitForResponse();
            Log.info("Got response %d", status);
            if (status == 0) {
                String mime;
                int extPos = this.task.getFileName().lastIndexOf(46);
                if (extPos >= 0 && (mime = WDScheme.mapMime(this.task.getFileName().substring(extPos + 1))) != null) {
                    cefResponse.setMimeType(mime);
                }
                cefResponse.setStatus(200);
                cefResponse.setStatusText("OK");
                contentLength.set(0);
                return;
            }
        }
        if (status == 2) {
            errCode = 404;
            errStr = "Not Found";
        } else if (status == 5) {
            errCode = 408;
            errStr = "Timed Out";
        } else if (status == 1) {
            errCode = 418;
            errStr = "I'm a teapot";
        } else {
            errCode = 500;
            errStr = "Internal Server Error";
        }
        cefResponse.setStatus(200);
        cefResponse.setStatusText("OK");
        cefResponse.setMimeType("text/html");
        this.dataToWrite = String.format(ERROR_PAGE, errCode, errStr).getBytes(StandardCharsets.UTF_8);
        this.dataOffset = 0;
        this.amountToWrite = this.dataToWrite.length;
        this.isErrorPage = true;
        contentLength.set(0);
    }

    public boolean readResponse(byte[] output, int bytesToRead, IntRef bytesRead, CefCallback cefCallback) {
        int toWrite;
        if (this.dataToWrite == null) {
            if (this.isErrorPage) {
                bytesRead.set(0);
                return false;
            }
            this.dataToWrite = this.task.waitForData();
            this.dataOffset = 3;
            this.amountToWrite = this.task.getDataLength();
            if (this.amountToWrite <= 0) {
                this.dataToWrite = null;
                bytesRead.set(0);
                return false;
            }
        }
        if ((toWrite = bytesToRead) > this.amountToWrite) {
            toWrite = this.amountToWrite;
        }
        System.arraycopy(this.dataToWrite, this.dataOffset, output, 0, toWrite);
        bytesRead.set(toWrite);
        this.dataOffset += toWrite;
        this.amountToWrite -= toWrite;
        if (this.amountToWrite <= 0) {
            if (!this.isErrorPage) {
                this.task.nextData();
            }
            this.dataToWrite = null;
        }
        return true;
    }

    public void cancel() {
        Log.info("Scheme query canceled or finished.", new Object[0]);
        if (!this.onlyError) {
            this.task.cancel();
        }
    }

    public static String mapMime(String ext) {
        switch (ext) {
            case "htm": 
            case "html": {
                return "text/html";
            }
            case "css": {
                return "text/css";
            }
            case "js": {
                return "text/javascript";
            }
            case "png": {
                return "image/png";
            }
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "gif": {
                return "image/gif";
            }
            case "svg": {
                return "image/svg+xml";
            }
            case "xml": {
                return "text/xml";
            }
            case "txt": {
                return "text/plain";
            }
        }
        return null;
    }
}

