/*
 * Decompiled with CFR 0.152.
 */
package com.suppergerrie2.panorama;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.suppergerrie2.panorama.Config;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import oshi.util.tuples.Pair;

public class PanoramaClientEvents {
    public static final KeyMapping createPanoramaKey = new KeyMapping("spanorama.key.createPanorama", 72, "key.categories.spanorama");
    private static final Logger LOGGER = LogManager.getLogger();
    static final HashMap<Path, DynamicTexture[]> skyboxTextureCache = new HashMap();

    public PanoramaClientEvents() {
        MinecraftForge.EVENT_BUS.addListener(this::inputEvent);
        MinecraftForge.EVENT_BUS.addListener(this::openMainMenu);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(Config::onModConfigEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerKeyMappingsEvent);
        Config.panoramaSaveFolder = Minecraft.m_91087_().f_91069_.toPath().resolve("panoramas");
    }

    public void registerKeyMappingsEvent(RegisterKeyMappingsEvent event) {
        event.register(createPanoramaKey);
    }

    private static void takeScreenshot(RenderTarget rendertarget, int stage, long time, boolean sendMessage) {
        NativeImage screenshot = Screenshot.m_92279_((RenderTarget)rendertarget);
        Util.m_183992_().execute(() -> {
            NativeImage squareScreenshot = null;
            try {
                Path panoramaFolder = Config.panoramaSaveFolder.resolve(String.format("%s", time));
                if (!(panoramaFolder.toFile().exists() && panoramaFolder.toFile().isDirectory() || panoramaFolder.toFile().mkdirs())) {
                    throw new IOException(String.format("Failed to create folder %s", panoramaFolder.toAbsolutePath()));
                }
                int width = screenshot.m_84982_();
                int height = screenshot.m_85084_();
                int x = 0;
                int y = 0;
                int size = Math.min(width, height);
                if (width > height) {
                    x = (width - height) / 2;
                } else {
                    y = (height - width) / 2;
                }
                squareScreenshot = new NativeImage(size, size, false);
                screenshot.m_85034_(x, y, size, size, squareScreenshot);
                Path path = panoramaFolder.resolve(String.format("panorama_%d.png", stage));
                LOGGER.info("Writing to {}", (Object)path.toAbsolutePath());
                squareScreenshot.m_85066_(path);
                if (sendMessage) {
                    File target = path.getParent().toFile();
                    MutableComponent textComponent = Component.m_237113_((String)target.getName()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(p_238335_1_ -> p_238335_1_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, target.getAbsolutePath())));
                    Minecraft.m_91087_().execute(() -> PanoramaClientEvents.lambda$takeScreenshot$1((Component)textComponent));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to save screenshot!");
                e.printStackTrace();
                Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"spanorama.panorama.failed")));
            }
            finally {
                screenshot.close();
                if (squareScreenshot != null) {
                    squareScreenshot.close();
                }
            }
        });
    }

    @Nullable
    static Pair<DynamicTexture[], String> getRandomPanorama() {
        Random random = new Random();
        try {
            if (!Config.panoramaSaveFolder.toFile().exists() && !Config.panoramaSaveFolder.toFile().mkdirs()) {
                LOGGER.error("Failed to create panorama save folder: {}", (Object)Config.panoramaSaveFolder.toAbsolutePath());
                return null;
            }
            Path[] paths = (Path[])Files.list(Config.panoramaSaveFolder).filter(path -> {
                for (int i = 0; i < 6; ++i) {
                    if (path.resolve(String.format("panorama_%d.png", i)).toFile().exists()) continue;
                    return false;
                }
                return true;
            }).toArray(Path[]::new);
            if (paths.length == 0) {
                return null;
            }
            Path theChosenOne = paths[random.nextInt(paths.length)];
            return new Pair((Object)skyboxTextureCache.computeIfAbsent(theChosenOne, path -> {
                try {
                    DynamicTexture[] textures = new DynamicTexture[6];
                    for (int i = 0; i < textures.length; ++i) {
                        InputStream stream = Files.newInputStream(path.resolve(String.format("panorama_%d.png", i)), new OpenOption[0]);
                        NativeImage image = NativeImage.m_85058_((InputStream)stream);
                        textures[i] = new DynamicTexture(image);
                        image.close();
                        stream.close();
                    }
                    return textures;
                }
                catch (Exception e) {
                    return null;
                }
            }), (Object)theChosenOne.getFileName().toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setRandomPanorama(@Nullable TitleScreen screen) {
        ResourceLocation base;
        Pair<DynamicTexture[], String> textures;
        Object object = textures = Config.useCustomPanorama ? PanoramaClientEvents.getRandomPanorama() : null;
        if (textures == null) {
            base = new ResourceLocation("minecraft", "textures/gui/title/background/panorama");
        } else {
            base = new ResourceLocation("spanorama", "textures/gui/title/background/panorama/" + (String)textures.getB());
            for (int i = 0; i < 6; ++i) {
                Minecraft.m_91087_().m_91097_().m_118495_(new ResourceLocation(base.m_135827_(), base.m_135815_() + "_" + i + ".png"), (AbstractTexture)((DynamicTexture[])textures.getA())[i]);
            }
        }
        TitleScreen.f_96716_ = new CubeMap(base);
        if (screen != null) {
            screen.f_96729_ = new PanoramaRenderer(TitleScreen.f_96716_);
        }
    }

    public void openMainMenu(ScreenEvent.Opening event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)screen;
            this.setRandomPanorama(titleScreen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createPanorama() {
        long currentTime = System.currentTimeMillis();
        Minecraft instance = Minecraft.m_91087_();
        Window window = instance.m_91268_();
        LocalPlayer player = instance.f_91074_;
        GameRenderer gameRenderer = instance.f_91063_;
        LevelRenderer levelRenderer = instance.f_91060_;
        int oldWidth = window.m_85441_();
        int oldHeight = window.m_85442_();
        TextureTarget rendertarget = new TextureTarget(Config.renderResolution, Config.renderResolution, true, Minecraft.f_91002_);
        float oldXRot = player.m_146909_();
        float oldYRot = player.m_146908_();
        float oldXRot0 = player.f_19860_;
        float oldYRot0 = player.f_19859_;
        RenderTarget oldMainTarget = instance.m_91385_();
        gameRenderer.m_172775_(false);
        try {
            gameRenderer.m_172779_(true);
            levelRenderer.m_173014_();
            window.m_166450_(Config.renderResolution);
            window.m_166452_(Config.renderResolution);
            instance.f_91042_ = rendertarget;
            for (int stage = 0; stage < 6; ++stage) {
                this.applyRotationForStage((Player)player, oldYRot, stage);
                player.f_19859_ = player.m_146908_();
                player.f_19860_ = player.m_146909_();
                rendertarget.m_83947_(true);
                gameRenderer.m_109089_(1.0f, 0L, new PoseStack());
                PanoramaClientEvents.takeScreenshot((RenderTarget)rendertarget, stage, currentTime, stage == 5);
            }
        }
        finally {
            player.m_146926_(oldXRot);
            player.m_146922_(oldYRot);
            player.f_19860_ = oldXRot0;
            player.f_19859_ = oldYRot0;
            gameRenderer.m_172775_(true);
            window.m_166450_(oldWidth);
            window.m_166452_(oldHeight);
            rendertarget.m_83930_();
            gameRenderer.m_172779_(false);
            levelRenderer.m_173014_();
            instance.f_91042_ = oldMainTarget;
            instance.m_91385_().m_83947_(true);
        }
    }

    private void applyRotationForStage(Player player, float baseYRot, int stage) {
        if (stage < 0 || stage > 5) {
            return;
        }
        switch (stage) {
            case 0: {
                player.m_146922_(baseYRot);
                player.m_146926_(0.0f);
                break;
            }
            case 1: {
                player.m_146922_((baseYRot + 90.0f) % 360.0f);
                player.m_146926_(0.0f);
                break;
            }
            case 2: {
                player.m_146922_((baseYRot + 180.0f) % 360.0f);
                player.m_146926_(0.0f);
                break;
            }
            case 3: {
                player.m_146922_((baseYRot - 90.0f) % 360.0f);
                player.m_146926_(0.0f);
                break;
            }
            case 4: {
                player.m_146922_(baseYRot);
                player.m_146926_(-90.0f);
                break;
            }
            case 5: {
                player.m_146922_(baseYRot);
                player.m_146926_(90.0f);
            }
        }
    }

    @SubscribeEvent
    void inputEvent(InputEvent.Key event) {
        if (createPanoramaKey.m_90859_()) {
            this.createPanorama();
        }
    }

    private static /* synthetic */ void lambda$takeScreenshot$1(Component textComponent) {
        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"spanorama.panorama.success", (Object[])new Object[]{textComponent}));
    }
}

