/*
 * Decompiled with CFR 0.152.
 */
package com.suppergerrie2.panorama;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    private static final Logger LOGGER;
    public static Path panoramaSaveFolder;
    public static boolean useCustomPanorama;
    public static int renderResolution;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == CLIENT_SPEC) {
            Config.bakeClient();
            LOGGER.debug("Baked client config");
        }
    }

    private static void bakeClient() {
        panoramaSaveFolder = new File((String)Config.CLIENT.savePath.get()).toPath();
        useCustomPanorama = (Boolean)Config.CLIENT.useCustomPanoramas.get();
        renderResolution = (Integer)Config.CLIENT.renderResolution.get();
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        LOGGER = LogManager.getLogger((String)"spanorama Mod Event Subscriber");
        panoramaSaveFolder = new File("./panoramas/").toPath();
        useCustomPanorama = true;
        renderResolution = 1920;
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.ConfigValue<String> savePath;
        public final ForgeConfigSpec.BooleanValue useCustomPanoramas;
        public final ForgeConfigSpec.IntValue renderResolution;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Save Settings");
            this.savePath = builder.comment("Where to save the panoramas").define("panoramaSaveFolder", (Object)panoramaSaveFolder.toString());
            this.renderResolution = builder.comment("The resolution of one image in the panorama. Increasing the resolution will lead to higher quality images but at the cost of performance and storage space").defineInRange("renderResolution", 1920, 240, 8192);
            builder.pop();
            builder.push("Main menu");
            this.useCustomPanoramas = builder.comment("Whether to use custom panoramas on the main menu").define("useCustomPanoramas", true);
            builder.pop();
        }
    }
}

