/*
 * Decompiled with CFR 0.152.
 */
package yuuki1293.pccard.mixins;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class PCCardMixinPlugin
implements IMixinConfigPlugin {
    private static final String COMMON_MIXIN_PACKAGE = "yuuki1293.pccard.mixins.common.";
    private static final Map<String, Set<String>> LOAD_WHEN_MOD_PRESENT = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> EXCLUDE_WHEN_MOD_PRESENT = new HashMap<String, Set<String>>();
    private static final Set<String> EXCLUDE_ALWAYS = new HashSet<String>();
    private static final String DISABLE_SLOT_PROPERTY = "pccard.disableSlot";
    private static Set<String> jvmArguments = Set.of();

    public void onLoad(String mixinPackage) {
        jvmArguments = PCCardMixinPlugin.gatherJvmArguments();
        if (PCCardMixinPlugin.shouldSkipAddUpgradesSlotMixins()) {
            EXCLUDE_ALWAYS.addAll(Set.of("yuuki1293.pccard.mixins.common.MixinAddUpgradeSlot", "yuuki1293.pccard.mixins.common.MixinPatternProviderScreen", "yuuki1293.pccard.mixins.common.MixinPatternProviderMenu", "yuuki1293.pccard.mixins.common.MixinPatternProviderLogicHost", "yuuki1293.pccard.mixins.advanced_ae.MixinAdvAddUpgradeSlot", "yuuki1293.pccard.mixins.advanced_ae.MixinSmallAdvPatternProviderScreen", "yuuki1293.pccard.mixins.advanced_ae.MixinAdvPatternProviderMenu", "yuuki1293.pccard.mixins.advanced_ae.MixinAdvPatternProviderLogicHost"));
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        boolean load = mixinClassName.startsWith(COMMON_MIXIN_PACKAGE);
        if (!load) {
            for (Map.Entry<String, Set<String>> entry : LOAD_WHEN_MOD_PRESENT.entrySet()) {
                String requiredModId = entry.getKey();
                Set<String> mixinsForMod = entry.getValue();
                if (!mixinsForMod.contains(mixinClassName) || FMLLoader.getLoadingModList().getModFileById(requiredModId) == null) continue;
                load = true;
            }
        }
        if (load) {
            for (Map.Entry<String, Set<String>> entry : EXCLUDE_WHEN_MOD_PRESENT.entrySet()) {
                String conflictingModId = entry.getKey();
                Set<String> mixinsToExclude = entry.getValue();
                if (!mixinsToExclude.contains(mixinClassName) || FMLLoader.getLoadingModList().getModFileById(conflictingModId) == null) continue;
                load = false;
            }
        }
        if (load && EXCLUDE_ALWAYS.contains(mixinClassName)) {
            load = false;
        }
        return load;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static Set<String> gatherJvmArguments() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return new HashSet<String>(runtimeMXBean.getInputArguments());
    }

    private static boolean shouldSkipAddUpgradesSlotMixins() {
        if (Boolean.getBoolean(DISABLE_SLOT_PROPERTY)) {
            return true;
        }
        return PCCardMixinPlugin.hasJvmArgument("-Dpccard.disableSlot");
    }

    private static boolean hasJvmArgument(String argument) {
        return jvmArguments.stream().anyMatch(arg -> arg.equals(argument) || arg.startsWith(argument + "="));
    }

    static {
        LOAD_WHEN_MOD_PRESENT.put("appflux", Set.of("yuuki1293.pccard.mixins.appflux.MixinAppFluxAddUpgradeSlot", "yuuki1293.pccard.mixins.appflux.MixinAppFluxAdvAddUpgradeSlot"));
        EXCLUDE_WHEN_MOD_PRESENT.put("appflux", Set.of("yuuki1293.pccard.mixins.common.MixinAddUpgradeSlot", "yuuki1293.pccard.mixins.common.MixinPatternProviderScreen", "yuuki1293.pccard.mixins.common.MixinPatternProviderMenu", "yuuki1293.pccard.mixins.common.MixinPatternProviderLogicHost", "yuuki1293.pccard.mixins.advanced_ae.MixinAdvAddUpgradeSlot", "yuuki1293.pccard.mixins.advanced_ae.MixinSmallAdvPatternProviderScreen", "yuuki1293.pccard.mixins.advanced_ae.MixinAdvPatternProviderMenu", "yuuki1293.pccard.mixins.advanced_ae.MixinAdvPatternProviderLogicHost"));
        LOAD_WHEN_MOD_PRESENT.put("advanced_ae", Set.of("yuuki1293.pccard.mixins.advanced_ae.MixinAdvAddUpgradeSlot", "yuuki1293.pccard.mixins.advanced_ae.MixinAdvCraftingCPULogic", "yuuki1293.pccard.mixins.advanced_ae.MixinAdvPatternProviderLogic", "yuuki1293.pccard.mixins.advanced_ae.MixinAdvPatternProviderLogicHost", "yuuki1293.pccard.mixins.advanced_ae.MixinAdvPatternProviderMenu", "yuuki1293.pccard.mixins.advanced_ae.MixinAdvPatternProviderScreen", "yuuki1293.pccard.mixins.advanced_ae.MixinAdvProcessingPattern", "yuuki1293.pccard.mixins.advanced_ae.MixinSmallAdvPatternProviderScreen"));
    }
}

