/*
 * Decompiled with CFR 0.152.
 */
package yuuki1293.pccard.impl;

import appeng.api.crafting.IPatternDetails;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.parts.storagebus.StorageBusPart;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IHasCircuitSlot;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.slf4j.Logger;
import yuuki1293.pccard.ConfigCommon;
import yuuki1293.pccard.TagUtils;
import yuuki1293.pccard.wrapper.IAEPattern;
import yuuki1293.pccard.wrapper.IPatternP2PTunnelLogicMixin;
import yuuki1293.pccard.wrapper.IPatternProviderLogicMixin;

public class PatternProviderLogicImpl {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static ItemStack updatePatterns(IPatternProviderLogicMixin self, ItemStack stack) {
        if (self.pCCard$hasPCCard()) {
            ItemStack newStack = stack.m_41777_();
            Optional<ListTag> inputs = TagUtils.getInputsFromPattern(newStack);
            CompoundTag tagRoot = newStack.m_41783_();
            if (tagRoot == null) {
                tagRoot = new CompoundTag();
            }
            if (inputs.isPresent()) {
                Integer number = TagUtils.getCircuitNumber(inputs.get()).orElse(0);
                tagRoot.m_128405_("circuit", number.intValue());
                TagUtils.removeCircuit(inputs.get());
            }
            return newStack;
        }
        return stack;
    }

    public static void setPCNumber(IPatternProviderLogicMixin self, IPatternDetails patternDetails) {
        try {
            if (self.pCCard$hasPCCard() && patternDetails instanceof IAEPattern) {
                IAEPattern patternDetailsW = (IAEPattern)patternDetails;
                BlockEntity be = self.pCCard$getBlockEntity();
                Level level = be.m_58904_();
                if (level == null) {
                    return;
                }
                List<BlockPos> blockPoses = self.pCCard$getSendPos();
                for (BlockPos blockPos : blockPoses) {
                    MetaMachine gtMachine = SimpleTieredMachine.getMachine((BlockGetter)level, (BlockPos)blockPos);
                    if (gtMachine == null) {
                        return;
                    }
                    if (!(gtMachine instanceof IHasCircuitSlot)) continue;
                    IHasCircuitSlot machine = (IHasCircuitSlot)gtMachine;
                    NotifiableItemStackHandler inv = machine.getCircuitInventory();
                    PatternProviderLogicImpl.setInvNumber(inv, patternDetailsW);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to set PC number", (Throwable)e);
        }
    }

    private static void setInvNumber(NotifiableItemStackHandler inv, IAEPattern details) throws IndexOutOfBoundsException {
        ItemStack machineStack = GTItems.PROGRAMMED_CIRCUIT.asStack();
        int number = details.pCCard$getNumber();
        IntCircuitBehaviour.setCircuitConfiguration((ItemStack)machineStack, (int)number);
        inv.setStackInSlot(0, machineStack);
    }

    public static List<BlockPos> getSendPos(Level level, IPatternProviderLogicMixin self) {
        Tuple<BlockPos, Direction> rootPosDir = PatternProviderLogicImpl.getSendPosDirect(self);
        ArrayList<BlockPos> allLeafNodes = new ArrayList<BlockPos>();
        HashSet<Tuple> visited = new HashSet<Tuple>();
        LinkedList<Tuple> queue = new LinkedList<Tuple>();
        queue.offer(new Tuple(rootPosDir, (Object)0));
        while (!queue.isEmpty()) {
            Tuple current = (Tuple)queue.poll();
            Tuple posDir = (Tuple)current.m_14418_();
            int depth = (Integer)current.m_14419_();
            if (visited.contains(posDir) || depth > ConfigCommon.getSearchDepth()) continue;
            visited.add(posDir);
            List<Tuple<BlockPos, Direction>> children = PatternProviderLogicImpl.getSendPosSubnet(level, (BlockPos)posDir.m_14418_(), ((Direction)posDir.m_14419_()).m_122424_());
            if (children.isEmpty()) {
                allLeafNodes.add((BlockPos)posDir.m_14418_());
                continue;
            }
            for (Tuple<BlockPos, Direction> childPosDir : children) {
                queue.offer(new Tuple(childPosDir, (Object)(depth + 1)));
            }
        }
        if (allLeafNodes.isEmpty()) {
            allLeafNodes.add((BlockPos)rootPosDir.m_14418_());
        }
        return allLeafNodes;
    }

    public static Tuple<BlockPos, Direction> getSendPosDirect(IPatternProviderLogicMixin self) {
        try {
            Level level = self.pCCard$getLevel();
            if (level == null) {
                return new Tuple((Object)BlockPos.f_121853_, (Object)Direction.UP);
            }
            Direction dir = self.pCCard$getSendDirection();
            BlockEntity be = self.pCCard$getBlockEntity();
            BlockPos adjPos = be.m_58899_().m_121945_(dir);
            BlockEntity adjBe = level.m_7702_(adjPos);
            Direction adjBeSide = dir.m_122424_();
            ICraftingMachine craftingMachine = ICraftingMachine.of((Level)level, (BlockPos)adjPos, (Direction)adjBeSide, (BlockEntity)adjBe);
            if (craftingMachine instanceof IPatternP2PTunnelLogicMixin) {
                IPatternP2PTunnelLogicMixin patternP2P = (IPatternP2PTunnelLogicMixin)craftingMachine;
                BlockPos patternP2PPos = patternP2P.pCCard$getLastBlockPos();
                Direction patternP2PDirection = patternP2P.pCCard$getLastDirection();
                return new Tuple((Object)patternP2PPos, (Object)patternP2PDirection);
            }
            return new Tuple((Object)adjPos, (Object)dir);
        }
        catch (Exception e) {
            LOGGER.error("Error while getting sendPos", (Throwable)e);
            return new Tuple((Object)BlockPos.f_121853_, (Object)Direction.UP);
        }
    }

    public static List<Tuple<BlockPos, Direction>> getSendPosSubnet(Level level, BlockPos pos, Direction side) {
        IActionHost host = PatternProviderLogicImpl.getActionHost(level, pos, side);
        IGrid grid = PatternProviderLogicImpl.getGrid(host);
        Set<StorageBusPart> parts = PatternProviderLogicImpl.getStorageBusParts(grid);
        return PatternProviderLogicImpl.getBlockPoses(parts);
    }

    private static IActionHost getActionHost(Level level, BlockPos pos, Direction side) {
        IPartHost partHost;
        IPart part;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof IActionHost) {
            IActionHost host = (IActionHost)be;
            return host;
        }
        if (be instanceof IPartHost && (part = (partHost = (IPartHost)be).getPart(side)) instanceof IActionHost) {
            IActionHost host = (IActionHost)part;
            return host;
        }
        return null;
    }

    private static IGrid getGrid(IActionHost host) {
        if (host == null) {
            return null;
        }
        IGridNode node = host.getActionableNode();
        if (node != null) {
            return node.getGrid();
        }
        return null;
    }

    private static Set<StorageBusPart> getStorageBusParts(IGrid grid) {
        if (grid == null) {
            return Set.of();
        }
        return grid.getMachines(StorageBusPart.class);
    }

    private static List<Tuple<BlockPos, Direction>> getBlockPoses(Iterable<StorageBusPart> parts) {
        ArrayList<Tuple<BlockPos, Direction>> poses = new ArrayList<Tuple<BlockPos, Direction>>();
        for (StorageBusPart part : parts) {
            BlockPos pos = part.getBlockEntity().m_58899_();
            Direction side = part.getSide();
            BlockPos machinePos = pos.m_121945_(side);
            poses.add((Tuple<BlockPos, Direction>)new Tuple((Object)machinePos, (Object)side.m_122424_()));
        }
        return poses;
    }
}

