/*
 * Decompiled with CFR 0.152.
 */
package yuuki1293.pccard;

import appeng.api.ids.AECreativeTabIds;
import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEParts;
import appeng.core.localization.GuiText;
import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import yuuki1293.pccard.ConfigClient;
import yuuki1293.pccard.ConfigCommon;

@Mod(value="pccard")
public class PCCard {
    public static final String MODID = "pccard";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"pccard");
    public static final RegistryObject<Item> PROGRAMMED_CIRCUIT_CARD_ITEM = ITEMS.register("card_programmed_circuit", () -> Upgrades.createUpgradeCardItem((Item.Properties)new Item.Properties()));

    public PCCard(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::onBuildCreativeModeTabContentsEvent);
        modEventBus.addListener(this::commonSetup);
        ITEMS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigClient.spec);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigCommon.spec);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(this::postRegistrationInitialization).whenComplete((res, err) -> {
            if (err != null) {
                LOGGER.warn(err.getMessage());
            }
        });
    }

    public void postRegistrationInitialization() {
        String patternProviderGroup = GuiText.CraftingInterface.getTranslationKey();
        Item item = (Item)PROGRAMMED_CIRCUIT_CARD_ITEM.get();
        Upgrades.add((ItemLike)item, (ItemLike)AEParts.PATTERN_PROVIDER, (int)1, (String)patternProviderGroup);
        Upgrades.add((ItemLike)item, (ItemLike)AEBlocks.PATTERN_PROVIDER, (int)1, (String)patternProviderGroup);
        String exPatternProviderGroup = "gui.expatternprovider.ex_pattern_provider";
        ResourceLocation resourceExBE = ResourceLocation.fromNamespaceAndPath((String)"expatternprovider", (String)"ex_pattern_provider");
        ResourceLocation resourceExPart = ResourceLocation.fromNamespaceAndPath((String)"expatternprovider", (String)"ex_pattern_provider_part");
        Block patternProviderExBE = (Block)ForgeRegistries.BLOCKS.getValue(resourceExBE);
        Item patternProviderExPart = (Item)ForgeRegistries.ITEMS.getValue(resourceExPart);
        if (patternProviderExBE != null && patternProviderExPart != null) {
            Upgrades.add((ItemLike)item, (ItemLike)patternProviderExBE, (int)1, (String)exPatternProviderGroup);
            Upgrades.add((ItemLike)item, (ItemLike)patternProviderExPart, (int)1, (String)exPatternProviderGroup);
        }
        String adPatternProviderGroup = "gui.advanced_ae.AdvPatternProvider";
        String namespaceAd = "advanced_ae";
        ResourceLocation resourceAdBE = ResourceLocation.fromNamespaceAndPath((String)namespaceAd, (String)"small_adv_pattern_provider");
        ResourceLocation resourceAdPart = ResourceLocation.fromNamespaceAndPath((String)namespaceAd, (String)"small_adv_pattern_provider_part");
        ResourceLocation resourceAdExBE = ResourceLocation.fromNamespaceAndPath((String)namespaceAd, (String)"adv_pattern_provider");
        ResourceLocation resourceAdExPart = ResourceLocation.fromNamespaceAndPath((String)namespaceAd, (String)"adv_pattern_provider_part");
        Block patternProviderAdBE = (Block)ForgeRegistries.BLOCKS.getValue(resourceAdBE);
        Item patternProviderAdPart = (Item)ForgeRegistries.ITEMS.getValue(resourceAdPart);
        Block patternProviderAdExBE = (Block)ForgeRegistries.BLOCKS.getValue(resourceAdExBE);
        Item patternProviderAdExPart = (Item)ForgeRegistries.ITEMS.getValue(resourceAdExPart);
        if (patternProviderAdBE != null && patternProviderAdPart != null && patternProviderAdExBE != null && patternProviderAdExPart != null) {
            Upgrades.add((ItemLike)item, (ItemLike)patternProviderAdBE, (int)1, (String)adPatternProviderGroup);
            Upgrades.add((ItemLike)item, (ItemLike)patternProviderAdPart, (int)1, (String)adPatternProviderGroup);
            Upgrades.add((ItemLike)item, (ItemLike)patternProviderAdExBE, (int)1, (String)adPatternProviderGroup);
            Upgrades.add((ItemLike)item, (ItemLike)patternProviderAdExPart, (int)1, (String)adPatternProviderGroup);
        }
        String expPatternProviderGroup = "gui.expandedae.exp_pattern_provider";
        String namespaceExp = "expandedae";
        ResourceLocation resourceExpBE = ResourceLocation.fromNamespaceAndPath((String)namespaceExp, (String)"exp_pattern_provider");
        ResourceLocation resourceExpPart = ResourceLocation.fromNamespaceAndPath((String)namespaceExp, (String)"exp_pattern_provider_part");
        Block patternProviderExpBE = (Block)ForgeRegistries.BLOCKS.getValue(resourceExpBE);
        Item patternProviderExpPart = (Item)ForgeRegistries.ITEMS.getValue(resourceExpPart);
        if (patternProviderExpBE != null && patternProviderExpPart != null) {
            Upgrades.add((ItemLike)item, (ItemLike)patternProviderExpBE, (int)1, (String)expPatternProviderGroup);
            Upgrades.add((ItemLike)item, (ItemLike)patternProviderExpPart, (int)1, (String)expPatternProviderGroup);
        }
        String megaPatternProviderGroup = "block.megacells.mega_pattern_provider";
        String namespaceMega = "megacells";
        ResourceLocation resourceMegaBE = ResourceLocation.fromNamespaceAndPath((String)namespaceMega, (String)"mega_pattern_provider");
        ResourceLocation resourceMegaPart = ResourceLocation.fromNamespaceAndPath((String)namespaceMega, (String)"cable_mega_pattern_provider");
        Block patternProviderMegaBE = (Block)ForgeRegistries.BLOCKS.getValue(resourceMegaBE);
        Item patternProviderMegaPart = (Item)ForgeRegistries.ITEMS.getValue(resourceMegaPart);
        if (patternProviderMegaBE != null && patternProviderMegaPart != null) {
            Upgrades.add((ItemLike)item, (ItemLike)patternProviderMegaBE, (int)1, (String)megaPatternProviderGroup);
            Upgrades.add((ItemLike)item, (ItemLike)patternProviderMegaPart, (int)1, (String)megaPatternProviderGroup);
        }
    }

    @SubscribeEvent
    public void onBuildCreativeModeTabContentsEvent(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals((Object)AECreativeTabIds.MAIN)) {
            event.accept(PROGRAMMED_CIRCUIT_CARD_ITEM);
            LOGGER.debug("Add Programmed Circuit Card in AE2 creative tab");
        }
    }
}

