/*
 * Decompiled with CFR 0.152.
 */
package dev.lasm.betterp2p.network.data;

import appeng.parts.p2p.P2PTunnelPart;
import dev.lasm.betterp2p.network.data.P2PLocation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0003\u0010\u0007\u001a\u0017\u0010\t\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001d\u0010\t\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\f\u001a\u0015\u0010\u000e\u001a\u00020\u0002*\u0006\u0012\u0002\b\u00030\r\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lnet/minecraft/nbt/CompoundTag;", "tag", "Ldev/lasm/betterp2p/network/data/P2PLocation;", "readP2PLocation", "(Lnet/minecraft/nbt/CompoundTag;)Ldev/lasm/betterp2p/network/data/P2PLocation;", "Lnet/minecraft/network/FriendlyByteBuf;", "buf", "(Lnet/minecraft/network/FriendlyByteBuf;)Ldev/lasm/betterp2p/network/data/P2PLocation;", "loc", "writeP2PLocation", "(Ldev/lasm/betterp2p/network/data/P2PLocation;)Lnet/minecraft/nbt/CompoundTag;", "", "(Lnet/minecraft/network/FriendlyByteBuf;Ldev/lasm/betterp2p/network/data/P2PLocation;)V", "Lappeng/parts/p2p/P2PTunnelPart;", "toLoc", "(Lappeng/parts/p2p/P2PTunnelPart;)Ldev/lasm/betterp2p/network/data/P2PLocation;", "betterp2p"})
public final class P2PLocationKt {
    public static final void writeP2PLocation(@NotNull FriendlyByteBuf buf, @NotNull P2PLocation loc) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        buf.writeLong(loc.getPos().m_121878_());
        buf.writeByte(loc.getFacing().ordinal());
        buf.m_236858_(loc.getDim());
    }

    @Nullable
    public static final P2PLocation readP2PLocation(@NotNull FriendlyByteBuf buf) {
        P2PLocation p2PLocation;
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        try {
            BlockPos blockPos = BlockPos.m_122022_((long)buf.readLong());
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"of(buf.readLong())");
            Direction direction = Direction.values()[buf.readByte()];
            ResourceKey resourceKey = buf.m_236801_(Registries.f_256858_);
            Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"buf.readResourceKey(Registries.DIMENSION)");
            p2PLocation = new P2PLocation(blockPos, direction, (ResourceKey<Level>)resourceKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            p2PLocation = null;
        }
        return p2PLocation;
    }

    @NotNull
    public static final CompoundTag writeP2PLocation(@Nullable P2PLocation loc) {
        CompoundTag nbt = new CompoundTag();
        if (loc != null) {
            nbt.m_128356_("pos", loc.getPos().m_121878_());
            nbt.m_128344_("facing", (byte)loc.getFacing().ordinal());
            nbt.m_128359_("dim", loc.getDim().m_135782_().toString());
        }
        return nbt;
    }

    @Nullable
    public static final P2PLocation readP2PLocation(@NotNull CompoundTag tag) {
        P2PLocation p2PLocation;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        try {
            BlockPos blockPos = BlockPos.m_122022_((long)tag.m_128454_("pos"));
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"of(tag.getLong(\"pos\"))");
            Direction direction = Direction.values()[tag.m_128445_("facing")];
            ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dim")));
            Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"create(Registries.DIMENS\u2026on(tag.getString(\"dim\")))");
            p2PLocation = new P2PLocation(blockPos, direction, (ResourceKey<Level>)resourceKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            p2PLocation = null;
        }
        return p2PLocation;
    }

    @NotNull
    public static final P2PLocation toLoc(@NotNull P2PTunnelPart<?> $this$toLoc) {
        Intrinsics.checkNotNullParameter($this$toLoc, (String)"<this>");
        BlockPos blockPos = $this$toLoc.getBlockEntity().m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockEntity.blockPos");
        Direction direction = $this$toLoc.getSide();
        Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"side");
        ResourceKey resourceKey = $this$toLoc.getLevel().m_46472_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"level.dimension()");
        return new P2PLocation(blockPos, direction, (ResourceKey<Level>)resourceKey);
    }
}

