/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.recipes_lib.elements.recipes.nbt.shapless_nbt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.NBTRecipeFactory;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.NBTRecipeSerializer;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.shapless_nbt.ShapelessNBTRecipe;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.shapless_nbt.ShapelessNBTRecipeFactory;
import de.geheimagentnr1.recipes_lib.util.Pair;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class ShapelessNBTRecipeSerializer
extends NBTRecipeSerializer<ShapelessNBTRecipe> {
    @NotNull
    private static final ShapelessNBTRecipeFactory SHAPELESS_NBT_RECIPE_FACTORY = new ShapelessNBTRecipeFactory();

    @Override
    @NotNull
    protected Pair<NonNullList<Ingredient>, NBTRecipeFactory<ShapelessNBTRecipe>> readRecipeData(@NotNull JsonObject json) {
        NonNullList<Ingredient> ingredients = this.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (ingredients.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
        }
        return new Pair<NonNullList<Ingredient>, NBTRecipeFactory<ShapelessNBTRecipe>>(ingredients, SHAPELESS_NBT_RECIPE_FACTORY);
    }

    @NotNull
    private NonNullList<Ingredient> readIngredients(@NotNull JsonArray ingredientsJson) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (int i = 0; i < ingredientsJson.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientsJson.get(i));
            if (ingredient.m_43947_()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    @Override
    @NotNull
    protected Pair<Integer, NBTRecipeFactory<ShapelessNBTRecipe>> readRecipeData(@NotNull FriendlyByteBuf buffer) {
        return new Pair<Integer, NBTRecipeFactory<ShapelessNBTRecipe>>(buffer.m_130242_(), SHAPELESS_NBT_RECIPE_FACTORY);
    }

    @Override
    protected void writeRecipeData(@NotNull FriendlyByteBuf buffer, @NotNull ShapelessNBTRecipe recipe) {
        buffer.m_130130_(recipe.m_7527_().size());
    }
}

