/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.recipe.logic;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.startechnology.start_core.api.custom_tooltips.StarTCustomTooltipsManager;
import com.startechnology.start_core.machine.hellforge.StarTHellForgeMachine;
import com.startechnology.start_core.materials.StarTHellForgeHeatingLiquids;
import com.startechnology.start_core.recipe.StarTRecipeTypes;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class HellForgeHeatingLogic
implements GTRecipeType.ICustomRecipeLogic {
    public void buildRepresentativeRecipes() {
        StarTHellForgeMachine.fluidsMap.forEach((material, heat) -> {
            FluidStack heatingFluidInput = material.getFluid(1000);
            Integer temperature = heatingFluidInput.getFluid().getFluidType().getTemperature();
            StarTCustomTooltipsManager.writeCustomTooltipsToItem(heatingFluidInput.getOrCreateTag(), LocalizationUtils.format((String)"behaviour.start_core.hellforge.input_heat", (Object[])new Object[]{FormattingUtil.formatNumbers((int)(temperature / 1000000))}), LocalizationUtils.format((String)"behaviour.start_core.hellforge.max_heat", (Object[])new Object[]{FormattingUtil.formatNumbers((Object)heat)}));
            GTRecipe heatingRecipe = StarTRecipeTypes.HELL_FORGE_RECIPES.recipeBuilder(material.getName() + "_hellforge_heating", new Object[0]).inputFluids(heatingFluidInput).outputFluids(StarTHellForgeHeatingLiquids.InfernalTar.getFluid(500)).duration(64).EUt(GTValues.V[10]).buildRawRecipe();
            heatingRecipe.setId(heatingRecipe.m_6423_().m_246208_("/"));
            StarTRecipeTypes.HELL_FORGE_RECIPES.addToCategoryMap(GTRecipeCategories.get((String)"hellforge_heating"), heatingRecipe);
        });
    }

    @Nullable
    public GTRecipe createCustomRecipe(IRecipeCapabilityHolder holder) {
        List handlers = Objects.requireNonNullElseGet((List)holder.getCapabilitiesProxy().get((Object)IO.IN, (Object)FluidRecipeCapability.CAP), Collections::emptyList).stream().filter(NotifiableFluidTank.class::isInstance).map(NotifiableFluidTank.class::cast).filter(i -> i.getTanks() >= 1).collect(Collectors.toList());
        if (handlers.isEmpty()) {
            return null;
        }
        for (NotifiableFluidTank handler : handlers) {
            GTRecipe recipe = this.createHeatingRecipe(handler);
            if (recipe == null) continue;
            return recipe;
        }
        return null;
    }

    private GTRecipe createHeatingRecipe(NotifiableFluidTank handler) {
        for (int i = 0; i < handler.getTanks(); ++i) {
            Material fluidMaterial;
            FluidStack fluidInSlot = handler.getFluidInTank(i);
            if (fluidInSlot == null || fluidInSlot.isEmpty() || (fluidMaterial = ChemicalHelper.getMaterial((Fluid)fluidInSlot.getFluid())) == null || !StarTHellForgeMachine.fluidsMap.containsKey(fluidMaterial)) continue;
            FluidStack fluidInput = fluidInSlot.copy();
            fluidInput.setAmount(1000);
            return StarTRecipeTypes.HELL_FORGE_RECIPES.recipeBuilder("heating", new Object[0]).inputFluids(fluidInput).outputFluids(StarTHellForgeHeatingLiquids.InfernalTar.getFluid(500)).duration(64).EUt(GTValues.V[10]).buildRawRecipe();
        }
        return null;
    }
}

