/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.recipe.logic;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.startechnology.start_core.StarTCore;
import com.startechnology.start_core.api.bacteria.StarTBacteriaManager;
import com.startechnology.start_core.api.bacteria.StarTBacteriaStats;
import com.startechnology.start_core.api.custom_tooltips.StarTCustomTooltipsManager;
import com.startechnology.start_core.item.StarTBacteriaItems;
import com.startechnology.start_core.item.components.StarTBacteriaBehaviour;
import com.startechnology.start_core.recipe.StarTRecipeTypes;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.latvian.mods.kubejs.KubeJS;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class BacterialRunicMutatorLogic
implements GTRecipeType.ICustomRecipeLogic {
    public GTRecipe createCustomRecipe(IRecipeCapabilityHolder holder) {
        GTRecipe recipe;
        Map<Boolean, List<NotifiableItemStackHandler>> handlers = Objects.requireNonNullElseGet((List)holder.getCapabilitiesProxy().get((Object)IO.IN, (Object)ItemRecipeCapability.CAP), Collections::emptyList).stream().filter(NotifiableItemStackHandler.class::isInstance).map(NotifiableItemStackHandler.class::cast).filter(i -> i.getSlots() >= 1).collect(Collectors.groupingBy(NotifiableRecipeHandlerTrait::isDistinct));
        if (handlers.isEmpty()) {
            return null;
        }
        Iterator iterator = handlers.getOrDefault(true, Collections.emptyList()).iterator();
        while (iterator.hasNext()) {
            ItemStack runic = ItemStack.f_41583_;
            ItemStack bacteria = ItemStack.f_41583_;
            NotifiableItemStackHandler handler = (NotifiableItemStackHandler)iterator.next();
            recipe = BacterialRunicMutatorLogic.createBacteriaRecipe(runic, bacteria, handler);
            if (recipe == null) continue;
            return recipe;
        }
        ItemStack runic = ItemStack.f_41583_;
        ItemStack bacteria = ItemStack.f_41583_;
        for (NotifiableItemStackHandler handler : handlers.getOrDefault(false, Collections.emptyList())) {
            recipe = BacterialRunicMutatorLogic.createBacteriaRecipe(runic, bacteria, handler);
            if (recipe == null) continue;
            return recipe;
        }
        return null;
    }

    public static GTRecipe createBacteriaRecipe(ItemStack existingRunic, ItemStack existingBacteria, NotifiableItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack itemInSlot = handler.getStackInSlot(i);
            if (!existingBacteria.m_41619_() && !existingRunic.m_41619_()) break;
            if (itemInSlot == null || itemInSlot.m_41619_()) continue;
            if (existingRunic.m_41619_() && BacterialRunicMutatorLogic.isRunic(itemInSlot)) {
                existingRunic = itemInSlot;
                continue;
            }
            if (!existingBacteria.m_41619_() || StarTBacteriaBehaviour.getBacteriaBehaviour(itemInSlot) == null) continue;
            existingBacteria = itemInSlot;
        }
        if (!existingBacteria.m_41619_() && !existingRunic.m_41619_()) {
            StarTBacteriaBehaviour bacteriaBehaviour = StarTBacteriaBehaviour.getBacteriaBehaviour(existingBacteria);
            if (bacteriaBehaviour == null) {
                return null;
            }
            StarTBacteriaStats existingStats = StarTBacteriaManager.bacteriaStatsFromTag(existingBacteria);
            if (existingStats == null) {
                return null;
            }
            Integer production = StarTCore.RNG.m_216332_(1, StarTBacteriaStats.MAX_STAT_VALUE.intValue());
            Integer metabolism = StarTCore.RNG.m_216332_(1, StarTBacteriaStats.MAX_STAT_VALUE.intValue());
            Integer mutability = StarTCore.RNG.m_216332_(1, StarTBacteriaStats.MAX_STAT_VALUE.intValue());
            List<Fluid> possibleAffinityFluids = bacteriaBehaviour.getBehaviourAffinityFluids();
            Collections.shuffle(possibleAffinityFluids);
            StarTBacteriaStats mutatedStats = new StarTBacteriaStats(production, metabolism, mutability, possibleAffinityFluids.get(0), possibleAffinityFluids.get(1), possibleAffinityFluids.get(2));
            if (existingRunic.m_150930_((Item)ForgeRegistries.ITEMS.getValue(KubeJS.id((String)"runic_pathway_engraved_plating")))) {
                ItemStack output = existingBacteria.m_255036_(1);
                StarTBacteriaManager.writeBacteriaStatsToItem(output.m_41784_(), mutatedStats);
                return StarTRecipeTypes.BACTERIAL_RUNIC_MUTATOR_RECIPES.recipeBuilder("runic_mutator_pathway", new Object[0]).inputItems(existingBacteria.m_255036_(1)).chancedInput(existingRunic.m_255036_(1), 1000, 0).inputFluids(GTMaterials.DistilledWater.getFluid(8000)).inputFluids(GTMaterials.Mutagen.getFluid(400)).outputItems(output).duration(4800 / existingStats.getMutability()).EUt(GTValues.V[8]).buildRawRecipe();
            }
            ItemEntry<ComponentItem> nextType = StarTBacteriaItems.BACTERIA_ITEMS.get(StarTCore.RNG.m_216332_(0, StarTBacteriaItems.BACTERIA_ITEMS.size() - 1));
            ItemStack output = new ItemStack((ItemLike)nextType.get());
            List<Fluid> possibleNewAffinities = StarTBacteriaBehaviour.getBacteriaBehaviour(output).getBehaviourAffinityFluids();
            Collections.shuffle(possibleNewAffinities);
            StarTBacteriaStats newStats = new StarTBacteriaStats(production, metabolism, mutability, possibleAffinityFluids.get(0), possibleAffinityFluids.get(1), possibleAffinityFluids.get(2));
            StarTBacteriaManager.writeBacteriaStatsToItem(output.m_41784_(), newStats);
            return StarTRecipeTypes.BACTERIAL_RUNIC_MUTATOR_RECIPES.recipeBuilder("runic_mutator_total", new Object[0]).inputItems(existingBacteria.m_255036_(1)).chancedInput(existingRunic.m_255036_(1), 1000, 0).inputFluids(GTMaterials.DistilledWater.getFluid(8000)).inputFluids(GTMaterials.Mutagen.getFluid(800)).outputItems(output).duration(4800 / existingStats.getMutability()).EUt(GTValues.V[8]).buildRawRecipe();
        }
        return null;
    }

    public static boolean isRunic(ItemStack potentialRunic) {
        return potentialRunic.m_150930_((Item)ForgeRegistries.ITEMS.getValue(KubeJS.id((String)"runic_engraved_plating"))) || potentialRunic.m_150930_((Item)ForgeRegistries.ITEMS.getValue(KubeJS.id((String)"runic_pathway_engraved_plating")));
    }

    public void buildRepresentativeRecipes() {
        ItemStack runicPathway = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(KubeJS.id((String)"runic_pathway_engraved_plating")));
        ItemStack runic = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(KubeJS.id((String)"runic_engraved_plating")));
        StarTBacteriaItems.BACTERIA_ITEMS.stream().forEach(bacteria -> {
            ItemStack bacteriaInput = new ItemStack((ItemLike)bacteria.m_5456_());
            StarTCustomTooltipsManager.writeCustomTooltipsToItem(bacteriaInput.m_41784_(), "behaviour.start_core.bacteria.input");
            ItemStack bacteriaAffinityMutationOutput = new ItemStack((ItemLike)bacteria.m_5456_());
            StarTCustomTooltipsManager.writeCustomTooltipsToItem(bacteriaAffinityMutationOutput.m_41784_(), "behaviour.start_core.bacteria.mutator_affinity_output");
            ItemStack bacteriaTotalMutationOutput = new ItemStack((ItemLike)bacteria.m_5456_());
            StarTCustomTooltipsManager.writeCustomTooltipsToItem(bacteriaTotalMutationOutput.m_41784_(), "behaviour.start_core.bacteria.mutator_total_output");
            bacteriaTotalMutationOutput.m_41714_((Component)Component.m_237115_((String)"behaviour.start_core.bacteria.mutator_total_output_generic_bacteria"));
            GTRecipe affinityRecipe = StarTRecipeTypes.BACTERIAL_RUNIC_MUTATOR_RECIPES.recipeBuilder(bacteria.getId().m_135815_().toString() + "_affinity", new Object[0]).inputItems(bacteriaInput.m_255036_(1)).chancedInput(runicPathway, 1000, 0).inputFluids(GTMaterials.DistilledWater.getFluid(8000)).inputFluids(GTMaterials.Mutagen.getFluid(400)).outputItems(bacteriaAffinityMutationOutput).duration(240).EUt(GTValues.V[8]).buildRawRecipe();
            GTRecipe totalRecipe = StarTRecipeTypes.BACTERIAL_RUNIC_MUTATOR_RECIPES.recipeBuilder(bacteria.getId().m_135815_().toString() + "_total", new Object[0]).inputItems(bacteriaInput.m_255036_(1)).chancedInput(runic, 1000, 0).inputFluids(GTMaterials.DistilledWater.getFluid(8000)).inputFluids(GTMaterials.Mutagen.getFluid(800)).outputItems(bacteriaTotalMutationOutput).duration(240).EUt(GTValues.V[8]).buildRawRecipe();
            affinityRecipe.setId(affinityRecipe.m_6423_().m_246208_("/"));
            StarTRecipeTypes.BACTERIAL_RUNIC_MUTATOR_RECIPES.addToMainCategory(affinityRecipe);
            totalRecipe.setId(totalRecipe.m_6423_().m_246208_("/"));
            StarTRecipeTypes.BACTERIAL_RUNIC_MUTATOR_RECIPES.addToMainCategory(totalRecipe);
        });
    }
}

