/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.recipe.logic;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.startechnology.start_core.api.bacteria.StarTBacteriaManager;
import com.startechnology.start_core.api.bacteria.StarTBacteriaStats;
import com.startechnology.start_core.api.custom_tooltips.StarTCustomTooltipsManager;
import com.startechnology.start_core.item.StarTBacteriaItems;
import com.startechnology.start_core.item.components.StarTBacteriaBehaviour;
import com.startechnology.start_core.recipe.StarTRecipeTypes;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BacterialHydrocarbonHarvesterLogic
implements GTRecipeType.ICustomRecipeLogic {
    @Nullable
    public GTRecipe createCustomRecipe(IRecipeCapabilityHolder holder) {
        List handlers = Objects.requireNonNullElseGet((List)holder.getCapabilitiesProxy().get((Object)IO.IN, (Object)ItemRecipeCapability.CAP), Collections::emptyList).stream().filter(NotifiableItemStackHandler.class::isInstance).map(NotifiableItemStackHandler.class::cast).filter(i -> i.getSlots() >= 1).collect(Collectors.toList());
        if (handlers.isEmpty()) {
            return null;
        }
        for (NotifiableItemStackHandler handler : handlers) {
            GTRecipe recipe = this.createHarvesterRecipe(handler);
            if (recipe == null) continue;
            return recipe;
        }
        return null;
    }

    private GTRecipe createHarvesterRecipe(NotifiableItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            StarTBacteriaStats existingStats;
            StarTBacteriaBehaviour bacteriaBehaviour;
            ItemStack itemInSlot = handler.getStackInSlot(i);
            if (itemInSlot == null || itemInSlot.m_41619_() || (bacteriaBehaviour = StarTBacteriaBehaviour.getBacteriaBehaviour(itemInSlot)) == null || (existingStats = StarTBacteriaManager.bacteriaStatsFromTag(itemInSlot)) == null) continue;
            FluidStack bacterialInputSludge = GTMaterials.EnrichedBacterialSludge.getFluid(25 * (2 << existingStats.getMetabolism()));
            ItemStack sugar = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "sugar")), 2 << existingStats.getMetabolism());
            FluidStack primaryOutput = new FluidStack(existingStats.getPrimary(), 2000 * existingStats.getProduction());
            FluidStack secondaryOutput = new FluidStack(existingStats.getSecondary(), 1240 * existingStats.getProduction());
            FluidStack tertiaryOutput = new FluidStack(existingStats.getTertiary(), 320 * existingStats.getProduction());
            return StarTRecipeTypes.BACTERIAL_HYDROCARBON_HARVESTER_RECIPES.recipeBuilder("harvesting", new Object[0]).inputItems(itemInSlot.m_255036_(1)).inputFluids(GTMaterials.DistilledWater.getFluid(1000)).inputFluids(bacterialInputSludge).inputItems(sugar).outputFluids(new FluidStack[]{primaryOutput, secondaryOutput, tertiaryOutput}).duration(240).EUt(GTValues.V[7]).buildRawRecipe();
        }
        return null;
    }

    public void buildRepresentativeRecipes() {
        StarTBacteriaItems.BACTERIA_ITEMS.stream().forEach(bacteria -> {
            ItemStack bacteriaInput = new ItemStack((ItemLike)bacteria.m_5456_());
            StarTCustomTooltipsManager.writeCustomTooltipsToItem(bacteriaInput.m_41784_(), "behaviour.start_core.bacteria.input");
            StarTBacteriaBehaviour inputBehaviour = StarTBacteriaBehaviour.getBacteriaBehaviour(bacteriaInput);
            List<Fluid> affinities = inputBehaviour.getBehaviourAffinityFluids();
            FluidStack bacterialInputSludge = GTMaterials.EnrichedBacterialSludge.getFluid(25 * (2 << StarTBacteriaStats.MAX_STAT_VALUE));
            StarTCustomTooltipsManager.writeCustomTooltipsToItem(bacterialInputSludge.getOrCreateTag(), "behaviour.start_core.bacteria.maximum_shown_input", "behaviour.start_core.bacteria.harvester_sludge_input");
            ItemStack sugar = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "sugar")), 2 << StarTBacteriaStats.MAX_STAT_VALUE);
            StarTCustomTooltipsManager.writeCustomTooltipsToItem(sugar.m_41784_(), "behaviour.start_core.bacteria.maximum_shown_input", "behaviour.start_core.bacteria.harvester_sugar_input");
            FluidStack primaryOutputStack = new FluidStack(affinities.get(0), 2000 * StarTBacteriaStats.MAX_STAT_VALUE);
            StarTCustomTooltipsManager.writeCustomTooltipsToItem(primaryOutputStack.getOrCreateTag(), "behaviour.start_core.bacteria.primary_output", "behaviour.start_core.bacteria.any_affinity", "behaviour.start_core.bacteria.maximum_shown_output", "behaviour.start_core.bacteria.harvester_primary_output");
            FluidStack secondaryOutputStack = new FluidStack(affinities.get(1), 1240 * StarTBacteriaStats.MAX_STAT_VALUE);
            StarTCustomTooltipsManager.writeCustomTooltipsToItem(secondaryOutputStack.getOrCreateTag(), "behaviour.start_core.bacteria.secondary_output", "behaviour.start_core.bacteria.any_affinity", "behaviour.start_core.bacteria.maximum_shown_output", "behaviour.start_core.bacteria.harvester_secondary_output");
            FluidStack tertiaryOutputStack = new FluidStack(affinities.get(2), 320 * StarTBacteriaStats.MAX_STAT_VALUE);
            StarTCustomTooltipsManager.writeCustomTooltipsToItem(tertiaryOutputStack.getOrCreateTag(), "behaviour.start_core.bacteria.tertiary_output", "behaviour.start_core.bacteria.any_affinity", "behaviour.start_core.bacteria.maximum_shown_output", "behaviour.start_core.bacteria.harvester_tertiary_output");
            GTRecipe harvesterRecipe = StarTRecipeTypes.BACTERIAL_HYDROCARBON_HARVESTER_RECIPES.recipeBuilder(bacteria.getId().m_135815_().toString() + "_harvest", new Object[0]).inputItems(bacteriaInput.m_255036_(1)).inputFluids(GTMaterials.DistilledWater.getFluid(1000)).inputFluids(bacterialInputSludge).inputItems(sugar).outputFluids(new FluidStack[]{primaryOutputStack, secondaryOutputStack, tertiaryOutputStack}).duration(240).EUt(GTValues.V[7]).buildRawRecipe();
            harvesterRecipe.setId(harvesterRecipe.m_6423_().m_246208_("/"));
            StarTRecipeTypes.BACTERIAL_HYDROCARBON_HARVESTER_RECIPES.addToMainCategory(harvesterRecipe);
        });
    }
}

