/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.recipe.logic;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.startechnology.start_core.api.bacteria.StarTBacteriaManager;
import com.startechnology.start_core.api.bacteria.StarTBacteriaStats;
import com.startechnology.start_core.api.custom_tooltips.StarTCustomTooltipsManager;
import com.startechnology.start_core.item.StarTBacteriaItems;
import com.startechnology.start_core.recipe.StarTRecipeTypes;
import com.startechnology.start_core.recipe.logic.WeightedRandomList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BacteriaVatLogic
implements GTRecipeType.ICustomRecipeLogic {
    public static void bacterialBreeding() {
        StarTBacteriaItems.BACTERIA_ITEMS.stream().forEach(bacteria -> {
            ItemStack bacteriaInput = new ItemStack((ItemLike)bacteria.m_5456_());
            StarTCustomTooltipsManager.writeCustomTooltipsToItem(bacteriaInput.m_41784_(), "behaviour.start_core.bacteria.input");
            ItemStack bacteriaMutationOutput = new ItemStack((ItemLike)bacteria.m_5456_(), 16);
            StarTCustomTooltipsManager.writeCustomTooltipsToItem(bacteriaMutationOutput.m_41784_(), "behaviour.start_core.bacteria.vat_same_output");
            ItemStack bacteriaReplicationOutput = new ItemStack((ItemLike)bacteria.m_5456_(), 16);
            StarTCustomTooltipsManager.writeCustomTooltipsToItem(bacteriaReplicationOutput.m_41784_(), "behaviour.start_core.bacteria.vat_mutated_output");
            GTRecipe recipe = StarTRecipeTypes.BACTERIAL_BREEDING_VAT_RECIPES.recipeBuilder(bacteria.getId().m_135815_(), new Object[0]).inputItems(bacteriaInput).inputFluids(GTMaterials.Water.getFluid(8000)).inputFluids(GTMaterials.Bacteria.getFluid(2000)).outputItems(bacteriaMutationOutput).outputItems(bacteriaReplicationOutput).duration(800).EUt(GTValues.V[8]).buildRawRecipe();
            recipe.setId(recipe.m_6423_().m_246208_("/"));
            StarTRecipeTypes.BACTERIAL_BREEDING_VAT_RECIPES.addToMainCategory(recipe);
        });
    }

    public void buildRepresentativeRecipes() {
        BacteriaVatLogic.bacterialBreeding();
    }

    public GTRecipe createCustomRecipe(IRecipeCapabilityHolder holder) {
        List handlers = Objects.requireNonNullElseGet((List)holder.getCapabilitiesProxy().get((Object)IO.IN, (Object)ItemRecipeCapability.CAP), Collections::emptyList).stream().filter(NotifiableItemStackHandler.class::isInstance).map(NotifiableItemStackHandler.class::cast).filter(i -> i.getSlots() >= 1).collect(Collectors.toList());
        if (handlers.isEmpty()) {
            return null;
        }
        for (NotifiableItemStackHandler handler : handlers) {
            GTRecipe recipe = this.createBacteriaRecipe(handler);
            if (recipe == null) continue;
            return recipe;
        }
        return null;
    }

    private GTRecipe createBacteriaRecipe(NotifiableItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            StarTBacteriaStats stats;
            ItemStack itemInSlot = handler.getStackInSlot(i);
            if (itemInSlot == null || itemInSlot.m_41619_() || (stats = StarTBacteriaManager.bacteriaStatsFromTag(itemInSlot)) == null) continue;
            ItemStack outputMutatedBacteria = new ItemStack((ItemLike)itemInSlot.m_41720_(), 16);
            ItemStack outputReplicatedBacteria = new ItemStack((ItemLike)itemInSlot.m_41720_(), 16);
            StarTBacteriaManager.writeBacteriaStatsToItem(outputReplicatedBacteria.m_41784_(), stats);
            List<Double> weights = BacteriaVatLogic.getMutationWeights(stats.getMutability());
            WeightedRandomList<Integer> productionOutputs = BacteriaVatLogic.getStatWeightedList(stats.getProduction(), weights);
            WeightedRandomList<Integer> metabolismOutputs = BacteriaVatLogic.getStatWeightedList(stats.getMetabolism(), weights);
            WeightedRandomList<Integer> mutabilityOutputs = BacteriaVatLogic.getStatWeightedList(stats.getMutability(), weights);
            StarTBacteriaStats newStats = new StarTBacteriaStats(productionOutputs.getRandom(), metabolismOutputs.getRandom(), mutabilityOutputs.getRandom(), stats.getPrimary(), stats.getSecondary(), stats.getTertiary());
            StarTBacteriaManager.writeBacteriaStatsToItem(outputMutatedBacteria.m_41784_(), newStats);
            return StarTRecipeTypes.BACTERIAL_BREEDING_VAT_RECIPES.recipeBuilder(itemInSlot.m_41720_().m_5524_(), new Object[0]).inputItems(itemInSlot.m_255036_(1)).outputItems(outputReplicatedBacteria).outputItems(outputMutatedBacteria).inputFluids(GTMaterials.Water.getFluid(8000)).inputFluids(GTMaterials.Bacteria.getFluid(2000)).duration(800).EUt(GTValues.V[8]).buildRawRecipe();
        }
        return null;
    }

    private static List<Double> getMutationWeights(Integer mutability) {
        switch (mutability) {
            case 1: {
                return Arrays.asList(0.0, 5.0, 90.0, 5.0, 0.0);
            }
            case 2: {
                return Arrays.asList(2.0, 8.0, 80.0, 8.0, 2.0);
            }
            case 3: {
                return Arrays.asList(5.0, 15.0, 60.0, 15.0, 5.0);
            }
            case 4: {
                return Arrays.asList(12.0, 18.0, 40.0, 18.0, 12.0);
            }
        }
        return Arrays.asList(20.0, 20.0, 20.0, 20.0, 20.0);
    }

    private static WeightedRandomList<Integer> getStatWeightedList(Integer stat, List<Double> weights) {
        WeightedRandomList<Integer> statOutput = new WeightedRandomList<Integer>();
        statOutput.addEntry(Math.max(1, stat - 2), weights.get(0));
        statOutput.addEntry(Math.max(1, stat - 1), weights.get(1));
        statOutput.addEntry(stat, weights.get(2));
        statOutput.addEntry(Math.min(5, stat + 1), weights.get(3));
        statOutput.addEntry(Math.min(5, stat + 2), weights.get(4));
        return statOutput;
    }
}

