/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.recipe;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.recipe.GTRecipeSerializer;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.startechnology.start_core.machine.hellforge.StarTHellForgeMachine;
import com.startechnology.start_core.recipe.StarTPrioritiseCustomLogicRecipeType;
import com.startechnology.start_core.recipe.logic.BacteriaVatLogic;
import com.startechnology.start_core.recipe.logic.BacterialDormantAwakeningLogic;
import com.startechnology.start_core.recipe.logic.BacterialHydrocarbonHarvesterLogic;
import com.startechnology.start_core.recipe.logic.BacterialRunicMutatorLogic;
import com.startechnology.start_core.recipe.logic.HellForgeHeatingLogic;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;

public class StarTRecipeTypes {
    public static final GTRecipeType BLAST_FURNACE_RECIPES = GTRecipeTypes.register((String)"electric_vanilla_blast_furnace", (String)"electric", (RecipeType[])new RecipeType[]{RecipeType.f_44109_}).setMaxIOSize(1, 1, 0, 0).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(4L)).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.FURNACE_OVERLAY_1).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSteamProgressBar(GuiTextures.PROGRESS_BAR_ARROW_STEAM, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.FURNACE);
    public static final GTRecipeType SMOKER_RECIPES = GTRecipeTypes.register((String)"electric_smoker", (String)"electric", (RecipeType[])new RecipeType[]{RecipeType.f_44110_}).setMaxIOSize(1, 1, 0, 0).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(4L)).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.FURNACE_OVERLAY_1).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSteamProgressBar(GuiTextures.PROGRESS_BAR_ARROW_STEAM, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.FURNACE);
    public static final GTRecipeType BACTERIAL_BREEDING_VAT_RECIPES = GTRecipeTypes.register((String)"bacterial_breeding_vat", (String)"multiblock", (RecipeType[])new RecipeType[0]).setMaxIOSize(1, 2, 2, 0).setEUIO(IO.IN).addCustomRecipeLogic((GTRecipeType.ICustomRecipeLogic)new BacteriaVatLogic()).setProgressBar(GuiTextures.PROGRESS_BAR_FUSION, ProgressTexture.FillDirection.LEFT_TO_RIGHT);
    public static final GTRecipeType ABYSSAL_CONTAINMENT_RECIPE_TYPE = GTRecipeTypes.register((String)"abyssal_containment", (String)"multiblock", (RecipeType[])new RecipeType[0]).setMaxIOSize(0, 0, 2, 0).setEUIO(IO.IN);
    public static final GTRecipeType BACTERIAL_RUNIC_MUTATOR_RECIPES = GTRecipeTypes.register((String)"bacterial_runic_mutator", (String)"multiblock", (RecipeType[])new RecipeType[0]).setMaxIOSize(2, 1, 2, 0).setEUIO(IO.IN).addCustomRecipeLogic((GTRecipeType.ICustomRecipeLogic)new BacterialRunicMutatorLogic()).addCustomRecipeLogic((GTRecipeType.ICustomRecipeLogic)new BacterialDormantAwakeningLogic()).setProgressBar(GuiTextures.PROGRESS_BAR_BATH, ProgressTexture.FillDirection.LEFT_TO_RIGHT);
    public static final GTRecipeType BACTERIAL_HYDROCARBON_HARVESTER_RECIPES = GTRecipeTypes.register((String)"bacterial_hydrocarbon_harvester", (String)"multiblock", (RecipeType[])new RecipeType[0]).setMaxIOSize(2, 0, 2, 3).setEUIO(IO.IN).addCustomRecipeLogic((GTRecipeType.ICustomRecipeLogic)new BacterialHydrocarbonHarvesterLogic()).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressTexture.FillDirection.LEFT_TO_RIGHT);
    public static final GTRecipeType HELL_FORGE_RECIPES = StarTRecipeTypes.registerStarTPrioritiseCustomLogic("hellforge", "multiblock", new RecipeType[0]).setMaxIOSize(2, 1, 7, 1).setEUIO(IO.IN).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).addCustomRecipeLogic((GTRecipeType.ICustomRecipeLogic)new HellForgeHeatingLogic()).addDataInfo(data -> {
        int temp = data.m_128451_("ebf_temp");
        if (temp > 0) {
            return LocalizationUtils.format((String)"start_core.recipe.temperature", (Object[])new Object[]{FormattingUtil.formatNumbers((int)temp)});
        }
        return "";
    }).addDataInfo(data -> {
        int temp = data.m_128451_("ebf_temp");
        Material requiredFluid = StarTHellForgeMachine.getHellforgeHeatingLiquid(temp);
        if (temp > 0) {
            return Component.m_237110_((String)"start_core.recipe.heating_fluid", (Object[])new Object[]{requiredFluid.getLocalizedName().getString()}).getString();
        }
        return "";
    }).setUiBuilder((recipe, widgetGroup) -> {}).setSound(GTSoundEntries.FURNACE);
    public static final GTRecipeType ABYSSAL_HARVESTER_RECIPES = GTRecipeTypes.register((String)"abyssal_harvester", (String)"multiblock", (RecipeType[])new RecipeType[0]).setMaxIOSize(1, 0, 1, 4).setEUIO(IO.IN).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).addDataInfo(data -> {
        int minSaturation = data.m_128451_("min_saturation");
        if (minSaturation > 0) {
            return LocalizationUtils.format((String)"start_core.recipe.min_saturation", (Object[])new Object[]{FormattingUtil.formatPercent((double)((double)minSaturation / 100.0))});
        }
        return LocalizationUtils.format((String)"start_core.recipe.min_saturation.0", (Object[])new Object[0]);
    }).addDataInfo(data -> {
        int maxSaturation = data.m_128451_("max_saturation");
        if (maxSaturation > 0) {
            return LocalizationUtils.format((String)"start_core.recipe.max_saturation", (Object[])new Object[]{FormattingUtil.formatPercent((double)((double)maxSaturation / 100.0))});
        }
        return LocalizationUtils.format((String)"start_core.recipe.max_saturation.0", (Object[])new Object[0]);
    }).setSound(GTSoundEntries.CENTRIFUGE);

    public static GTRecipeType registerStarTPrioritiseCustomLogic(String name, String group, RecipeType<?> ... proxyRecipes) {
        StarTPrioritiseCustomLogicRecipeType recipeType = new StarTPrioritiseCustomLogicRecipeType(GTCEu.id((String)name), group, proxyRecipes);
        GTRegistries.register((Registry)BuiltInRegistries.f_256990_, (ResourceLocation)recipeType.registryName, (Object)((Object)recipeType));
        GTRegistries.register((Registry)BuiltInRegistries.f_256769_, (ResourceLocation)recipeType.registryName, (Object)new GTRecipeSerializer());
        GTRegistries.RECIPE_TYPES.register((Object)recipeType.registryName, (Object)recipeType);
        return recipeType;
    }

    public static final void init() {
    }
}

