/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.recipe;

import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.common.machine.multiblock.generator.LargeTurbineMachine;
import com.startechnology.start_core.machine.boosting.BoostedPlasmaTurbine;
import com.startechnology.start_core.machine.hellforge.StarTHellForgeMachine;
import com.startechnology.start_core.machine.parallel.IStarTAbsoluteParallelHatch;
import com.startechnology.start_core.machine.steam.StarTSteamParallelMultiblockMachine;
import com.startechnology.start_core.machine.threading.StarTThreadingCapableMachine;

public class StarTRecipeModifiers {
    public static final RecipeModifier ABSOLUTE_PARALLEL = StarTRecipeModifiers::hatchAbsoluteParallel;
    public static final RecipeModifier HELL_FORGE_OC = StarTRecipeModifiers::hellforgeOverclock;
    public static final RecipeModifier BULK_PROCESSING = StarTRecipeModifiers::bulkThroughputProcessing;
    public static final RecipeModifier THOUGHPUT_BOOSTING = StarTRecipeModifiers::thoughputBoosting;
    public static final RecipeModifier EBF_OVERCLOCK = GTRecipeModifiers::ebfOverclock;
    public static final RecipeModifier MS_COIL_PARALLELS = GTRecipeModifiers::multiSmelterParallel;
    public static final RecipeModifier LARGE_TURBINE = LargeTurbineMachine::recipeModifier;
    public static final RecipeModifier BOOSTED_PLASMA_TURBINE = BoostedPlasmaTurbine::recipeModifier;
    public static final RecipeModifier THREADING_MACHINE = StarTThreadingCapableMachine::recipeModifier;
    public static final RecipeModifier START_STEAM_PARALLEL = StarTSteamParallelMultiblockMachine::recipeModifier;

    public static ModifierFunction hatchAbsoluteParallel(MetaMachine machine, GTRecipe recipe) {
        IMultiController controller;
        if (machine instanceof IMultiController && (controller = (IMultiController)machine).isFormed()) {
            int parallels = controller.getParallelHatch().filter(hatch -> hatch instanceof IStarTAbsoluteParallelHatch).map(hatch -> ParallelLogic.getParallelAmountFast((MetaMachine)machine, (GTRecipe)recipe, (int)hatch.getCurrentParallel())).orElse(1);
            if (parallels == 1) {
                return ModifierFunction.IDENTITY;
            }
            return ModifierFunction.builder().modifyAllContents(ContentModifier.multiplier((double)parallels)).parallels(parallels).build();
        }
        return ModifierFunction.IDENTITY;
    }

    public static ModifierFunction hellforgeOverclock(MetaMachine machine, GTRecipe recipe) {
        if (!(machine instanceof StarTHellForgeMachine)) {
            return RecipeModifier.nullWrongType(StarTHellForgeMachine.class, (MetaMachine)machine);
        }
        StarTHellForgeMachine coilMachine = (StarTHellForgeMachine)machine;
        int hellforgeTemp = coilMachine.getCrucibleTemperature();
        int recipeTemp = recipe.data.m_128451_("ebf_temp");
        if (!recipe.data.m_128441_("ebf_temp")) {
            return ModifierFunction.IDENTITY;
        }
        if (recipeTemp > hellforgeTemp) {
            return ModifierFunction.NULL;
        }
        double timesScaled = Math.floor(Math.max(0.0, (double)(hellforgeTemp - recipeTemp) / 450.0));
        int hellforgeParallels = (int)Math.pow(2.0, timesScaled);
        int maxPossibleParallels = ParallelLogic.getParallelAmountFast((MetaMachine)machine, (GTRecipe)recipe, (int)hellforgeParallels);
        return ModifierFunction.builder().modifyAllContents(ContentModifier.multiplier((double)maxPossibleParallels)).parallels(maxPossibleParallels).build();
    }

    public static ModifierFunction bulkThroughputProcessing(MetaMachine machine, GTRecipe recipe) {
        int bulkLimit = 64;
        int maxBulking = ParallelLogic.getParallelAmountFast((MetaMachine)machine, (GTRecipe)recipe, (int)bulkLimit);
        double timesBulkingApplied = Math.floor(Math.max(0.0, (double)(maxBulking / 4)));
        int thoughputBulkingApplied = (int)timesBulkingApplied * 4;
        int durationBulkingApplied = (int)timesBulkingApplied * 3;
        if (timesBulkingApplied >= 1.0) {
            return ModifierFunction.builder().modifyAllContents(ContentModifier.multiplier((double)thoughputBulkingApplied)).durationMultiplier((double)durationBulkingApplied).parallels(thoughputBulkingApplied).build();
        }
        return ModifierFunction.IDENTITY;
    }

    public static ModifierFunction thoughputBoosting(MetaMachine machine, GTRecipe recipe) {
        int thoughputModifier = 4;
        double durationModifier = 1.4;
        double eutModifier = 0.9;
        int parallelsAvailable = Math.max(0, ParallelLogic.getParallelAmountFast((MetaMachine)machine, (GTRecipe)recipe, (int)thoughputModifier));
        if (parallelsAvailable >= thoughputModifier) {
            return ModifierFunction.builder().modifyAllContents(ContentModifier.multiplier((double)thoughputModifier)).durationMultiplier(durationModifier).eutMultiplier(eutModifier).parallels(thoughputModifier).build();
        }
        return ModifierFunction.IDENTITY;
    }
}

