/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.mixin;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.generated.WireRecipeHandler;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={WireRecipeHandler.class}, remap=false)
public class WireRecipeHandlerMixin {
    private static final Map<TagPrefix, Integer> INSULATION_AMOUNT = ImmutableMap.of((Object)TagPrefix.cableGtSingle, (Object)1, (Object)TagPrefix.cableGtDouble, (Object)1, (Object)TagPrefix.cableGtQuadruple, (Object)2, (Object)TagPrefix.cableGtOctal, (Object)3, (Object)TagPrefix.cableGtHex, (Object)5);

    private static void generateManualRecipe(TagPrefix wirePrefix, Material material, TagPrefix cablePrefix, int cableAmount, Consumer<FinishedRecipe> provider) {
        int insulationAmount = INSULATION_AMOUNT.get(cablePrefix);
        Object[] ingredients = new Object[insulationAmount + 1];
        ingredients[0] = new UnificationEntry(wirePrefix, material);
        for (int i = 1; i <= insulationAmount; ++i) {
            ingredients[i] = ChemicalHelper.get((TagPrefix)TagPrefix.plate, (Material)GTMaterials.Rubber);
        }
        VanillaRecipeHelper.addShapelessRecipe(provider, (String)String.format("%s_cable_%d", material.getName(), cableAmount), (ItemStack)ChemicalHelper.get((TagPrefix)cablePrefix, (Material)material), (Object[])ingredients);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + String.valueOf(wirePrefix), new Object[0]).inputItems(wirePrefix, material).inputItems(TagPrefix.plate, GTMaterials.Rubber, insulationAmount).outputItems(cablePrefix, material).duration(100).EUt((long)GTValues.VA[0]).save(provider);
    }

    @Overwrite
    public static void generateCableCovering(TagPrefix wirePrefix, Material material, WireProperties property, Consumer<FinishedRecipe> provider) {
        GTRecipeBuilder builder;
        if (property.isSuperconductor()) {
            return;
        }
        int cableAmount = (int)(wirePrefix.getMaterialAmount(material) * 2L / 3628800L);
        TagPrefix cablePrefix = TagPrefix.get((String)("cable" + wirePrefix.name().substring(4)));
        byte voltageTier = GTUtil.getTierByVoltage((long)property.getVoltage());
        int insulationAmount = INSULATION_AMOUNT.get(cablePrefix);
        if (voltageTier <= 1) {
            WireRecipeHandlerMixin.generateManualRecipe(wirePrefix, material, cablePrefix, cableAmount, provider);
        }
        if (voltageTier <= 4) {
            builder = GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + String.valueOf(wirePrefix) + "_rubber", new Object[0]).EUt((long)GTValues.VA[0]).duration(100).inputItems(wirePrefix, material).outputItems(cablePrefix, material).inputFluids(GTMaterials.Rubber.getFluid(144 * insulationAmount));
            if (voltageTier == 4) {
                builder.inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride, insulationAmount);
            }
            builder.save(provider);
        }
        if (voltageTier <= 8) {
            builder = GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + String.valueOf(wirePrefix) + "_silicone", new Object[0]).EUt((long)GTValues.VA[0]).duration(100).inputItems(wirePrefix, material).outputItems(cablePrefix, material);
            if (voltageTier >= 4) {
                builder.inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride, insulationAmount);
            }
            if (voltageTier >= 6) {
                builder.inputItems(TagPrefix.foil, GTMaterials.PolyphenyleneSulfide, insulationAmount);
            }
            builder.inputFluids(GTMaterials.SiliconeRubber.getFluid(144 * insulationAmount / 2)).save(provider);
        }
        if (voltageTier <= 9) {
            builder = GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + String.valueOf(wirePrefix) + "_styrene_butadiene", new Object[0]).EUt((long)GTValues.VA[0]).duration(100).inputItems(wirePrefix, material).outputItems(cablePrefix, material);
            if (voltageTier >= 4) {
                builder.inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride, insulationAmount);
            }
            if (voltageTier >= 6) {
                builder.inputItems(TagPrefix.foil, GTMaterials.PolyphenyleneSulfide, insulationAmount);
            }
            if (voltageTier >= 9) {
                builder.inputItems(TagPrefix.foil, GTMaterials.get((String)"polyimide"), insulationAmount);
            }
            builder.inputFluids(GTMaterials.StyreneButadieneRubber.getFluid(144 * insulationAmount / 4)).save(provider);
        }
        builder = GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_" + material.getName() + "_" + String.valueOf(wirePrefix) + "_perfluoroelastomer", new Object[0]).EUt((long)GTValues.VA[0]).duration(100).inputItems(wirePrefix, material).outputItems(cablePrefix, material);
        if (voltageTier >= 4) {
            builder.inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride, insulationAmount);
        }
        if (voltageTier >= 6) {
            builder.inputItems(TagPrefix.foil, GTMaterials.PolyphenyleneSulfide, insulationAmount);
        }
        if (voltageTier >= 9) {
            builder.inputItems(TagPrefix.foil, GTMaterials.get((String)"polyimide"), insulationAmount);
        }
        builder.inputFluids(GTMaterials.get((String)"perfluoroelastomer_rubber").getFluid(144 * insulationAmount / 8)).save(provider);
    }
}

