/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.mixin;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.steam.SimpleSteamMachine;
import com.gregtechceu.gtceu.client.util.TooltipHelper;
import com.gregtechceu.gtceu.common.machine.multiblock.steam.SteamParallelMultiblockMachine;
import com.gregtechceu.gtceu.integration.jade.provider.RecipeLogicProvider;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.startechnology.start_core.machine.steam.StarTSteamParallelMultiblockMachine;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

@Mixin(value={RecipeLogicProvider.class}, remap=false)
public class RecipeLogicProviderMixin {
    @Overwrite
    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor block, BlockEntity blockEntity, IPluginConfig config) {
        CompoundTag recipeInfo;
        if (capData.m_128471_("Working") && !(recipeInfo = capData.m_128469_("Recipe")).m_128456_()) {
            long EUt = recipeInfo.m_128454_("EUt");
            boolean isInput = recipeInfo.m_128471_("isInput");
            boolean isSteam = false;
            if (blockEntity instanceof MetaMachineBlockEntity) {
                MetaMachineBlockEntity mbe = (MetaMachineBlockEntity)blockEntity;
                MetaMachine machine = mbe.getMetaMachine();
                if (machine instanceof SimpleSteamMachine) {
                    SimpleSteamMachine ssm = (SimpleSteamMachine)machine;
                    EUt = (long)((double)EUt * ssm.getConversionRate());
                    isSteam = true;
                } else if (machine instanceof SteamParallelMultiblockMachine) {
                    SteamParallelMultiblockMachine smb = (SteamParallelMultiblockMachine)machine;
                    EUt = (long)((double)EUt * smb.getConversionRate());
                    isSteam = true;
                } else if (machine instanceof StarTSteamParallelMultiblockMachine) {
                    StarTSteamParallelMultiblockMachine smb = (StarTSteamParallelMultiblockMachine)machine;
                    EUt = (long)((double)EUt * smb.getConversionRate());
                    isSteam = true;
                }
            }
            if (EUt > 0L) {
                MutableComponent text;
                if (isSteam) {
                    text = Component.m_237113_((String)FormattingUtil.formatNumbers((long)EUt)).m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)" mB/t").m_130940_(ChatFormatting.RESET));
                } else {
                    byte tier = GTUtil.getOCTierByVoltage((long)EUt);
                    text = Component.m_237113_((String)FormattingUtil.formatNumbers((long)EUt)).m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237113_((String)" EU/t").m_130940_(ChatFormatting.RESET).m_7220_((Component)Component.m_237113_((String)" (").m_130940_(ChatFormatting.GREEN)));
                    if (tier < GTValues.TIER_COUNT) {
                        text = text.m_7220_((Component)Component.m_237113_((String)GTValues.VNF[tier]).m_130938_(style -> style.m_178520_(GTValues.VC[tier])));
                    } else {
                        int speed = tier - 14;
                        text = text.m_7220_((Component)Component.m_237113_((String)"MAX").m_130938_(style -> style.m_131148_(TooltipHelper.rainbowColor((float)speed))).m_7220_((Component)Component.m_237113_((String)"+").m_130938_(style -> style.m_178520_(GTValues.VC[speed])).m_7220_((Component)Component.m_237113_((String)FormattingUtil.formatNumbers((int)(tier - 14)))).m_130938_(style -> style.m_178520_(GTValues.VC[speed]))));
                    }
                    text = text.m_7220_((Component)Component.m_237113_((String)")").m_130940_(ChatFormatting.GREEN));
                }
                if (isInput) {
                    tooltip.add((Component)Component.m_237115_((String)"gtceu.top.energy_consumption").m_130946_(" ").m_7220_((Component)text));
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"gtceu.top.energy_production").m_130946_(" ").m_7220_((Component)text));
                }
            }
        }
    }
}

