/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.mixin;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.BlastProperty;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.CraftingComponent;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.generated.MaterialRecipeHandler;
import dev.architectury.patchedmixin.staticmixin.spongepowered.asm.mixin.Overwrite;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={MaterialRecipeHandler.class}, remap=false)
public class MaterialRecipeHandlerMixin {
    @Overwrite
    private static void processEBFRecipe(Material material, BlastProperty property, ItemStack output, Consumer<FinishedRecipe> provider) {
        int EUt;
        int blastTemp = property.getBlastTemperature();
        BlastProperty.GasTier gasTier = property.getGasTier();
        int duration = property.getDurationOverride();
        if (duration <= 0) {
            duration = Math.max(1, (int)(material.getMass() * (long)blastTemp / 50L));
        }
        if ((EUt = property.getEUtOverride()) <= 0) {
            EUt = GTValues.VA[2];
        }
        GTRecipeBuilder blastBuilder = GTRecipeTypes.BLAST_RECIPES.recipeBuilder("blast_" + material.getName(), new Object[0]).inputItems(TagPrefix.dust, material).outputItems(output).blastFurnaceTemp(blastTemp).EUt((long)EUt);
        if (gasTier != null) {
            FluidIngredient gas = ((FluidIngredient)CraftingComponent.EBF_GASES.get(gasTier)).copy();
            blastBuilder.copy("blast_" + material.getName()).circuitMeta(1).duration(duration).save(provider);
            blastBuilder.copy("blast_" + material.getName() + "_gas").circuitMeta(2).inputFluids(new FluidIngredient[]{gas}).duration((int)((double)duration * 0.67)).save(provider);
        } else {
            blastBuilder.duration(duration);
            if (material == GTMaterials.Silicon) {
                blastBuilder.circuitMeta(1);
            }
            blastBuilder.save(provider);
        }
        if (TagPrefix.ingotHot.doGenerateItem(material)) {
            int vacuumDuration;
            int vacuumEUt = property.getVacuumEUtOverride() != -1 ? property.getVacuumEUtOverride() : GTValues.VA[2];
            int n = vacuumDuration = property.getVacuumDurationOverride() != -1 ? property.getVacuumDurationOverride() : (int)material.getMass() * 3;
            if (blastTemp < 5000) {
                GTRecipeTypes.VACUUM_RECIPES.recipeBuilder("cool_hot_" + material.getName() + "_ingot", new Object[0]).inputItems(TagPrefix.ingotHot, material).outputItems(TagPrefix.ingot, material).duration(vacuumDuration).EUt((long)vacuumEUt).save(provider);
            } else if (blastTemp < 15000) {
                GTRecipeTypes.VACUUM_RECIPES.recipeBuilder("cool_hot_" + material.getName() + "_ingot", new Object[0]).inputItems(TagPrefix.ingotHot, material).inputFluids(GTMaterials.Helium.getFluid(FluidStorageKeys.LIQUID, 500)).outputItems(TagPrefix.ingot, material).outputFluids(GTMaterials.Helium.getFluid(250)).duration(vacuumDuration).EUt((long)vacuumEUt).save(provider);
            } else {
                vacuumEUt = property.getVacuumEUtOverride() != -1 ? property.getVacuumEUtOverride() : GTValues.VA[8];
                GTRecipeTypes.VACUUM_RECIPES.recipeBuilder("cool_hot_" + material.getName() + "_ingot", new Object[0]).inputItems(TagPrefix.ingotHot, material).inputFluids(GTMaterials.get((String)"superstate_helium_3").getFluid(FluidStorageKeys.LIQUID, 500)).outputItems(TagPrefix.ingot, material).outputFluids(GTMaterials.Helium3.getFluid(250)).duration(vacuumDuration).EUt((long)vacuumEUt).save(provider);
            }
        }
    }
}

