/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.mixin;

import com.gregtechceu.gtceu.client.TooltipsHandler;
import com.startechnology.start_core.api.custom_tooltips.StarTCustomTooltip;
import com.startechnology.start_core.api.custom_tooltips.StarTCustomTooltipsManager;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TooltipsHandler.class})
public class CustomStackTooltipsHandlerMixin {
    @Inject(method={"appendTooltips"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void onAppendTooltips(ItemStack stack, TooltipFlag flag, List<Component> tooltips, CallbackInfo ci) {
        if (stack == null) {
            return;
        }
        if (stack.m_41619_()) {
            return;
        }
        if (!stack.m_41782_()) {
            return;
        }
        if (StarTCustomTooltipsManager.hasCustomTooltip(stack.m_41784_())) {
            ci.cancel();
        }
    }

    @Inject(method={"appendFluidTooltips"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void onAppendFluidTooltips(FluidStack fluidStack, Consumer<Component> tooltips, TooltipFlag flag, CallbackInfo ci) {
        if (fluidStack == null) {
            return;
        }
        if (fluidStack.isEmpty()) {
            return;
        }
        if (!fluidStack.hasTag()) {
            return;
        }
        if (StarTCustomTooltipsManager.hasCustomTooltip(fluidStack.getOrCreateTag())) {
            StarTCustomTooltip customTooltips = StarTCustomTooltipsManager.customTooltipFromTag(fluidStack.getOrCreateTag());
            customTooltips.getTooltips().forEach(tooltip -> tooltips.accept((Component)tooltip));
            ci.cancel();
        }
    }
}

