/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.machine.threading;

import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.startechnology.start_core.machine.threading.StarTThreadingStatBlocks;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.Predicate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class StarTThreadingStatsPredicate {
    public static String THREADING_STATS_HEADER = "threading_stats_";
    public static Predicate<MultiblockState> threadingStatBlocksPredicate = StarTThreadingStatsPredicate::traceThreadingStatBlocks;

    public static boolean traceThreadingStatBlocks(MultiblockState blockWorldState) {
        BlockState state = blockWorldState.getBlockState();
        for (BlockEntry<StarTThreadingStatBlocks.StarTThreadingStatBlock> blockEntry : StarTThreadingStatBlocks.statBlocks) {
            if (!state.m_60713_((Block)blockEntry.get())) continue;
            ThreadingStatsBlockTracker stats = ((StarTThreadingStatBlocks.StarTThreadingStatBlock)((Object)blockEntry.get())).getThreadingStats();
            ThreadingStatsBlockTracker currentStats = (ThreadingStatsBlockTracker)blockWorldState.getMatchContext().getOrDefault(stats.name, (Object)new ThreadingStatsBlockTracker(stats.name, stats.general, stats.speed, stats.efficiency, stats.parallels, stats.threading));
            currentStats.increment();
            blockWorldState.getMatchContext().set(stats.name, (Object)currentStats);
            return true;
        }
        return false;
    }

    public static TraceabilityPredicate threadingStatBlocks() {
        return new TraceabilityPredicate(threadingStatBlocksPredicate, () -> (BlockInfo[])StarTThreadingStatBlocks.statBlocks.stream().map(entry -> new BlockInfo(((StarTThreadingStatBlocks.StarTThreadingStatBlock)((Object)((Object)((Object)entry.get())))).m_49966_(), null)).toArray(BlockInfo[]::new));
    }

    public static class ThreadingStatsBlockTracker {
        public int general;
        public int speed;
        public int efficiency;
        public int parallels;
        public int threading;
        public int amount;
        public String name;

        public ThreadingStatsBlockTracker(String name, int general, int speed, int efficiency, int parallels, int threading) {
            this.general = general;
            this.name = THREADING_STATS_HEADER + name;
            this.speed = speed;
            this.efficiency = efficiency;
            this.parallels = parallels;
            this.threading = threading;
            this.amount = 0;
        }

        public void increment() {
            ++this.amount;
        }

        public Integer getStatString(String stat) {
            switch (stat) {
                case "general": {
                    return this.general;
                }
                case "speed": {
                    return this.speed;
                }
                case "efficiency": {
                    return this.efficiency;
                }
                case "parallels": {
                    return this.parallels;
                }
                case "threading": {
                    return this.threading;
                }
            }
            return -1;
        }
    }
}

