/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.machine.threading;

import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.startechnology.start_core.StarTCore;
import com.startechnology.start_core.machine.threading.StarTThreadingStatsPredicate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;

public class StarTThreadingStatBlocks {
    public static List<BlockEntry<StarTThreadingStatBlock>> statBlocks = new ArrayList<BlockEntry<StarTThreadingStatBlock>>();
    public static List<String> statList = List.of("general", "speed", "efficiency", "parallels", "threading");
    public static final BlockEntry<StarTThreadingStatBlock> SUPREME_HELIX_0 = StarTThreadingStatBlocks.createThreadingStatBlock(new StarTThreadingStatsPredicate.ThreadingStatsBlockTracker("uv_supreme_thread_helix", 15, 0, 0, 0, 0));
    public static final BlockEntry<StarTThreadingStatBlock> SUPREME_HELIX_1 = StarTThreadingStatBlocks.createThreadingStatBlock(new StarTThreadingStatsPredicate.ThreadingStatsBlockTracker("uev_supreme_thread_helix", 30, 0, 0, 0, 0));
    public static final BlockEntry<StarTThreadingStatBlock> SUPREME_HELIX_2 = StarTThreadingStatBlocks.createThreadingStatBlock(new StarTThreadingStatsPredicate.ThreadingStatsBlockTracker("uxv_supreme_thread_helix", 60, 0, 0, 0, 0));
    public static final BlockEntry<StarTThreadingStatBlock> SUPREME_HELIX_3 = StarTThreadingStatBlocks.createThreadingStatBlock(new StarTThreadingStatsPredicate.ThreadingStatsBlockTracker("max_supreme_thread_helix", 90, 0, 0, 0, 0));
    public static final BlockEntry<StarTThreadingStatBlock> OVERDRIVE_HELIX_1 = StarTThreadingStatBlocks.createThreadingStatBlock(new StarTThreadingStatsPredicate.ThreadingStatsBlockTracker("uhv_overdrive_thread_helix", 6, 15, 4, 0, 0));
    public static final BlockEntry<StarTThreadingStatBlock> OVERDRIVE_HELIX_2 = StarTThreadingStatBlocks.createThreadingStatBlock(new StarTThreadingStatsPredicate.ThreadingStatsBlockTracker("uxv_overdrive_thread_helix", 12, 30, 8, 0, 0));
    public static final BlockEntry<StarTThreadingStatBlock> OVERDRIVE_HELIX_3 = StarTThreadingStatBlocks.createThreadingStatBlock(new StarTThreadingStatsPredicate.ThreadingStatsBlockTracker("max_overdrive_thread_helix", 18, 45, 12, 0, 0));
    public static final BlockEntry<StarTThreadingStatBlock> COPROCESSOR_HELIX_1 = StarTThreadingStatBlocks.createThreadingStatBlock(new StarTThreadingStatsPredicate.ThreadingStatsBlockTracker("uhv_coprocessor_thread_helix", 5, 8, 2, 10, 0));
    public static final BlockEntry<StarTThreadingStatBlock> COPROCESSOR_HELIX_2 = StarTThreadingStatBlocks.createThreadingStatBlock(new StarTThreadingStatsPredicate.ThreadingStatsBlockTracker("uiv_coprocessor_thread_helix", 10, 16, 4, 20, 0));
    public static final BlockEntry<StarTThreadingStatBlock> COPROCESSOR_HELIX_3 = StarTThreadingStatBlocks.createThreadingStatBlock(new StarTThreadingStatsPredicate.ThreadingStatsBlockTracker("opv_coprocessor_thread_helix", 15, 24, 6, 30, 0));
    public static final BlockEntry<StarTThreadingStatBlock> WEAVER_HELIX_1 = StarTThreadingStatBlocks.createThreadingStatBlock(new StarTThreadingStatsPredicate.ThreadingStatsBlockTracker("uhv_weaving_thread_helix", 5, 2, 8, 0, 10));
    public static final BlockEntry<StarTThreadingStatBlock> WEAVER_HELIX_2 = StarTThreadingStatBlocks.createThreadingStatBlock(new StarTThreadingStatsPredicate.ThreadingStatsBlockTracker("uiv_weaving_thread_helix", 10, 4, 16, 0, 20));
    public static final BlockEntry<StarTThreadingStatBlock> WEAVER_HELIX_3 = StarTThreadingStatBlocks.createThreadingStatBlock(new StarTThreadingStatsPredicate.ThreadingStatsBlockTracker("opv_weaving_thread_helix", 15, 6, 24, 0, 30));
    public static final BlockEntry<StarTThreadingStatBlock> TEST_HELIX = StarTThreadingStatBlocks.createThreadingStatBlock(new StarTThreadingStatsPredicate.ThreadingStatsBlockTracker("test", 200, 0, 0, 0, 0));

    public static NonNullBiConsumer<DataGenContext<Block, StarTThreadingStatBlock>, RegistrateBlockstateProvider> createActiveModel(String blockName) {
        return (ctx, prov) -> {
            ActiveBlock block = (ActiveBlock)ctx.getEntry();
            String modelName = ctx.getName();
            ResourceLocation textureBase = StarTCore.resourceLocation("block/threading/" + blockName + "/thread");
            BlockModelBuilder inactiveModel = (BlockModelBuilder)prov.models().cubeAll(modelName, textureBase);
            BlockModelBuilder activeModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName + "_active", new ResourceLocation("block/cube_all"))).texture("all", StarTCore.resourceLocation("block/threading/" + blockName + "/thread_active"))).texture("particle", StarTCore.resourceLocation("block/threading/" + blockName + "/thread_active"));
            ((VariantBlockStateBuilder)prov.getVariantBuilder((Block)block).partialState().with((Property)ActiveBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)inactiveModel).addModel()).partialState().with((Property)ActiveBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)activeModel).addModel();
        };
    }

    public static BlockEntry<StarTThreadingStatBlock> createThreadingStatBlock(StarTThreadingStatsPredicate.ThreadingStatsBlockTracker stats) {
        String name = stats.name.replace(StarTThreadingStatsPredicate.THREADING_STATS_HEADER, "");
        BlockEntry block = ((BlockBuilder)StarTCore.START_REGISTRATE.block(name, props -> new StarTThreadingStatBlock((BlockBehaviour.Properties)props, stats)).initialProperties(() -> Blocks.f_50075_).addLayer(() -> RenderType::m_110457_).blockstate(StarTThreadingStatBlocks.createActiveModel(name)).tag(new TagKey[]{(TagKey)GTToolType.WRENCH.harvestTags.get(0), BlockTags.f_144282_, CustomTags.TOOL_TIERS[4]}).item((blockA, props) -> new BlockItem((Block)blockA, (Item.Properties)props){

            public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
                BlockItem blockItem;
                Block block;
                super.m_7373_(stack, level, tooltipComponents, isAdvanced);
                tooltipComponents.add(1, (Component)Component.m_237115_((String)"block.start_core.helix_tooltip_title"));
                Item item = stack.m_41720_();
                if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof StarTThreadingStatBlock) {
                    StarTThreadingStatBlock statBlock = (StarTThreadingStatBlock)block;
                    StarTThreadingStatsPredicate.ThreadingStatsBlockTracker stats = statBlock.getThreadingStats();
                    statList.forEach(stat -> {
                        ChatFormatting color = switch (stat) {
                            case "speed" -> ChatFormatting.GREEN;
                            case "efficiency" -> ChatFormatting.LIGHT_PURPLE;
                            case "parallels" -> ChatFormatting.RED;
                            case "threading" -> ChatFormatting.BLUE;
                            default -> ChatFormatting.WHITE;
                        };
                        tooltipComponents.add((Component)Component.m_237110_((String)("block.start_core.stat." + stat + ".display"), (Object[])new Object[]{Component.m_237115_((String)("start_core.machine.threading.stat." + stat)), Component.m_237113_((String)FormattingUtil.formatNumbers((Object)stats.getStatString((String)stat))).m_130940_(color)}));
                    });
                }
            }
        }).model((ctx, prov) -> prov.withExistingParent(prov.name((NonNullSupplier)ctx), StarTCore.resourceLocation("block/" + name))).build()).register();
        statBlocks.add((BlockEntry<StarTThreadingStatBlock>)block);
        return block;
    }

    public static void init() {
    }

    public static class StarTThreadingStatBlock
    extends ActiveBlock {
        private StarTThreadingStatsPredicate.ThreadingStatsBlockTracker threadingStats;

        public StarTThreadingStatBlock(BlockBehaviour.Properties properties, StarTThreadingStatsPredicate.ThreadingStatsBlockTracker threadingStats) {
            super(properties);
            this.threadingStats = threadingStats;
        }

        public StarTThreadingStatsPredicate.ThreadingStatsBlockTracker getThreadingStats() {
            return this.threadingStats;
        }

        public void setThreadingStats(StarTThreadingStatsPredicate.ThreadingStatsBlockTracker threadingStats) {
            this.threadingStats = threadingStats;
        }
    }
}

