/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.machine.threading;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.startechnology.start_core.machine.threading.StarTThreadingCapableMachine;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;

public class StarTThreadingControllerPartMachine
extends MultiblockPartMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(StarTThreadingControllerPartMachine.class, MultiblockPartMachine.MANAGED_FIELD_HOLDER);
    private Supplier<StarTThreadingCapableMachine> machineSupplier;

    public StarTThreadingControllerPartMachine(IMachineBlockEntity holder) {
        super(holder);
    }

    public void setAssociatedController(StarTThreadingCapableMachine controller) {
        this.machineSupplier = () -> controller;
    }

    public void clearController() {
        this.machineSupplier = null;
    }

    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return true;
    }

    public boolean canShared() {
        return false;
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    private void addComponentPanelText(List<Component> componentList) {
        if (this.machineSupplier == null) {
            componentList.add((Component)Component.m_237113_((String)"No controller connected").m_130940_(ChatFormatting.RED));
            return;
        }
        StarTThreadingCapableMachine machine = this.machineSupplier.get();
        componentList.add((Component)Component.m_237115_((String)"start_core.machine.threading_controller.stat.display").m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.threading_controller.stat.display.hover")))));
        componentList.add((Component)Component.m_237110_((String)"start_core.machine.threading_controller.stat.display_general_remaining", (Object[])new Object[]{Component.m_237115_((String)"start_core.machine.threading.stat.general"), Component.m_237113_((String)FormattingUtil.formatNumbers((Object)machine.getRemainingAssignable())).m_130940_(ChatFormatting.YELLOW)}).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.threading_controller.stat.general_hover")))));
        for (String stat : machine.getStatTypes()) {
            componentList.add((Component)Component.m_237113_((String)""));
            MutableComponent statPointLine = Component.m_237110_((String)"start_core.machine.threading_controller.stat.display_assign", (Object[])new Object[]{Component.m_237115_((String)("start_core.machine.threading.stat." + stat)), Component.m_237113_((String)FormattingUtil.formatNumbers((Object)machine.getStatAssigned(stat))).m_130940_(ChatFormatting.YELLOW), Component.m_237113_((String)FormattingUtil.formatNumbers((Object)machine.getStatTotal(stat))).m_130940_(ChatFormatting.YELLOW)}).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)("start_core.machine.threading_controller.stat." + stat + ".hover")))));
            statPointLine.m_130946_(" ");
            statPointLine.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)"start_core.machine.threading_controller.stat.assign").m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.threading_controller.stat.assign.hover")))), (String)("add_" + stat)));
            statPointLine.m_130946_(" ");
            statPointLine.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)"start_core.machine.threading_controller.stat.remove").m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.threading_controller.stat.remove.hover")))), (String)("remove_" + stat)));
            componentList.add((Component)statPointLine);
            componentList.add((Component)machine.getPrettyFormat(stat).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)("start_core.machine.threading_controller.stat." + stat + ".hover"))))));
        }
        componentList.add((Component)Component.m_237113_((String)""));
        componentList.add((Component)Component.m_237115_((String)"start_core.machine.threading_controller.list_components").m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.threading_controller.list_components.hover")))));
        machine.getStats().forEach((name, stats) -> {
            MutableComponent component = Component.m_237110_((String)"start_core.machine.threading_controller.component_format", (Object[])new Object[]{Component.m_237115_((String)("block.start_core." + name)).m_130940_(ChatFormatting.GRAY), Component.m_237113_((String)FormattingUtil.formatNumbers((int)stats.amount)).m_130940_(ChatFormatting.AQUA)});
            componentList.add((Component)component);
        });
        componentList.add((Component)Component.m_237113_((String)""));
    }

    public void onThreadingControllerPanelClick(String componentData, ClickData clickData) {
        if (this.machineSupplier == null) {
            return;
        }
        StarTThreadingCapableMachine machine = this.machineSupplier.get();
        if (!clickData.isRemote) {
            int amount = 1;
            if (clickData.isShiftClick && !clickData.isCtrlClick) {
                amount = 5;
            } else if (clickData.isCtrlClick && !clickData.isShiftClick) {
                amount = 20;
            } else if (clickData.isCtrlClick && clickData.isShiftClick) {
                amount = Integer.MAX_VALUE;
            }
            if (componentData.startsWith("add_")) {
                String stat = componentData.replace("add_", "");
                machine.assignStat(stat, amount);
            } else if (componentData.startsWith("remove_")) {
                String stat = componentData.replace("remove_", "");
                machine.unassignStat(stat, amount);
            }
        }
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 250, 125);
        group.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, 242, 117).setBackground((IGuiTexture)GuiTextures.DISPLAY).addWidget((Widget)new LabelWidget(4, 5, Component.m_237115_((String)"block.start_core.threading_controller").getString())).addWidget((Widget)new ComponentPanelWidget(4, 20, this::addComponentPanelText).clickHandler(this::onThreadingControllerPanelClick)));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }
}

