/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.machine.threading;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockDisplayText;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.pattern.util.PatternMatchContext;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeSerializer;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifierList;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.accessor.CustomObjectAccessor;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.syncdata.payload.FriendlyBufPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.startechnology.start_core.machine.threading.StarTThreadingControllerPartMachine;
import com.startechnology.start_core.machine.threading.StarTThreadingStatsPredicate;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class StarTThreadingCapableMachine
extends WorkableElectricMultiblockMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(StarTThreadingCapableMachine.class, WorkableElectricMultiblockMachine.MANAGED_FIELD_HOLDER);
    private HashMap<String, StarTThreadingStatsPredicate.ThreadingStatsBlockTracker> stats = new HashMap();
    @Persisted
    @DescSynced
    private Integer generalTotal = 0;
    @Persisted
    @DescSynced
    private Integer assignedSpeed = 0;
    @Persisted
    @DescSynced
    private Integer speed = 0;
    @Persisted
    @DescSynced
    private Integer assignedEfficiency = 0;
    @Persisted
    @DescSynced
    private Integer efficiency = 0;
    @Persisted
    @DescSynced
    private Integer assignedParallels = 0;
    @Persisted
    @DescSynced
    private Integer parallels = 0;
    @Persisted
    @DescSynced
    private Integer assignedThreading = 0;
    @Persisted
    @DescSynced
    private Integer threading = 0;
    @Persisted
    @DescSynced
    private List<ThreadedRecipeExecution> activeThreads = new ArrayList<ThreadedRecipeExecution>();
    protected TickableSubscription threadTickableSubscription;

    public StarTThreadingCapableMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    public void resetStats() {
        this.generalTotal = 0;
        this.speed = 0;
        this.efficiency = 0;
        this.parallels = 0;
        this.threading = 0;
    }

    public void ensureAssignment() {
        Integer remaining = this.getRemainingAssignable();
        if (remaining < 0) {
            Integer toSubtract;
            Integer deficit = Math.abs(remaining);
            if (this.assignedSpeed > 0) {
                toSubtract = Math.min(deficit, this.assignedSpeed);
                this.assignedSpeed = this.assignedSpeed - toSubtract;
                deficit = deficit - toSubtract;
            }
            if (deficit > 0 && this.assignedEfficiency > 0) {
                toSubtract = Math.min(deficit, this.assignedEfficiency);
                this.assignedEfficiency = this.assignedEfficiency - toSubtract;
                deficit = deficit - toSubtract;
            }
            if (deficit > 0 && this.assignedParallels > 0) {
                toSubtract = Math.min(deficit, this.assignedParallels);
                this.assignedParallels = this.assignedParallels - toSubtract;
                deficit = deficit - toSubtract;
            }
            if (deficit > 0 && this.assignedThreading > 0) {
                toSubtract = Math.min(deficit, this.assignedThreading);
                this.assignedThreading = this.assignedThreading - toSubtract;
                Integer n = deficit - toSubtract;
            }
        }
        this.activeThreads = new ArrayList<ThreadedRecipeExecution>(this.activeThreads.subList(0, Math.min(this.getEffectiveThreads(), this.activeThreads.size())));
    }

    public Integer getRemainingAssignable() {
        return this.generalTotal - (this.assignedEfficiency + this.assignedParallels + this.assignedSpeed + this.assignedThreading);
    }

    private Integer getEffectiveDurationReduction() {
        if (this.assignedSpeed == null) {
            this.assignedSpeed = 0;
        }
        if (this.speed == null) {
            this.speed = 0;
        }
        return this.assignedSpeed + this.speed;
    }

    public MutableComponent getSpeedPrettyFormat() {
        double multiplier = this.calculateDurationMultiplier();
        double reductionPercent = (1.0 - multiplier) * 100.0;
        return Component.m_237110_((String)"start_core.machine.threading_controller.speed.pretty_format", (Object[])new Object[]{Component.m_237113_((String)FormattingUtil.formatNumber2Places((double)reductionPercent)).m_130940_(ChatFormatting.GREEN), Component.m_237113_((String)"%").m_130940_(ChatFormatting.GREEN)});
    }

    private Integer getEffectivePowerReduction() {
        if (this.assignedEfficiency == null) {
            this.assignedEfficiency = 0;
        }
        if (this.efficiency == null) {
            this.efficiency = 0;
        }
        return this.assignedEfficiency + this.efficiency;
    }

    public MutableComponent getEfficiencyPrettyFormat() {
        double multiplier = this.calculateEnergyMultiplier();
        double reductionPercent = (1.0 - multiplier) * 100.0;
        return Component.m_237110_((String)"start_core.machine.threading_controller.efficiency.pretty_format", (Object[])new Object[]{Component.m_237113_((String)FormattingUtil.formatNumber2Places((double)reductionPercent)).m_130940_(ChatFormatting.LIGHT_PURPLE), Component.m_237113_((String)"%").m_130940_(ChatFormatting.LIGHT_PURPLE)});
    }

    private Integer getEffectiveParallels() {
        if (this.assignedParallels == null) {
            this.assignedParallels = 0;
        }
        if (this.parallels == null) {
            this.parallels = 0;
        }
        return Math.floorDiv(this.assignedParallels + this.parallels, 20) + 1;
    }

    public MutableComponent getParallelsPrettyFormat() {
        return Component.m_237110_((String)"start_core.machine.threading_controller.parallels.pretty_format", (Object[])new Object[]{Component.m_237113_((String)FormattingUtil.formatNumbers((Object)this.getEffectiveParallels())).m_130940_(ChatFormatting.RED)});
    }

    private Integer getEffectiveThreads() {
        if (this.assignedThreading == null) {
            this.assignedThreading = 0;
        }
        if (this.threading == null) {
            this.threading = 0;
        }
        return Math.floorDiv(this.assignedThreading + this.threading, 5);
    }

    public MutableComponent getThreadsPrettyFormat() {
        return Component.m_237110_((String)"start_core.machine.threading_controller.threading.pretty_format", (Object[])new Object[]{Component.m_237113_((String)FormattingUtil.formatNumbers((Object)this.getEffectiveThreads())).m_130940_(ChatFormatting.BLUE)});
    }

    public MutableComponent getActualDurationPrettyFormat() {
        double efficiencyMultiplier = this.calculateDurationMultiplier();
        double parallelMultiplier = Math.sqrt(this.getEffectiveParallels().intValue());
        double actualDurationMultiplier = efficiencyMultiplier * parallelMultiplier * 100.0;
        return Component.m_237110_((String)"start_core.machine.threading_controller.duration.pretty_format", (Object[])new Object[]{Component.m_237113_((String)FormattingUtil.formatNumber2Places((double)actualDurationMultiplier)).m_130940_(ChatFormatting.GREEN), Component.m_237113_((String)"%").m_130940_(ChatFormatting.GREEN)});
    }

    public Integer getStatAssigned(String stat) {
        switch (stat) {
            case "speed": {
                return this.assignedSpeed;
            }
            case "efficiency": {
                return this.assignedEfficiency;
            }
            case "parallels": {
                return this.assignedParallels;
            }
            case "threading": {
                return this.assignedThreading;
            }
        }
        return -1;
    }

    public Integer getStatTotal(String stat) {
        switch (stat) {
            case "speed": {
                return this.assignedSpeed + this.speed;
            }
            case "efficiency": {
                return this.assignedEfficiency + this.efficiency;
            }
            case "parallels": {
                return this.assignedParallels + this.parallels;
            }
            case "threading": {
                return this.assignedThreading + this.threading;
            }
        }
        return -1;
    }

    public MutableComponent getPrettyFormat(String stat) {
        switch (stat) {
            case "speed": {
                return this.getSpeedPrettyFormat();
            }
            case "efficiency": {
                return this.getEfficiencyPrettyFormat();
            }
            case "parallels": {
                return this.getParallelsPrettyFormat();
            }
            case "threading": {
                return this.getThreadsPrettyFormat();
            }
        }
        return Component.m_237113_((String)"Invalid");
    }

    public void assignStat(String stat, int amount) {
        amount = Math.min(this.getRemainingAssignable(), amount);
        if (this.getRemainingAssignable() - amount < 0) {
            return;
        }
        switch (stat) {
            case "speed": {
                this.assignedSpeed = this.assignedSpeed + amount;
                break;
            }
            case "efficiency": {
                this.assignedEfficiency = this.assignedEfficiency + amount;
                break;
            }
            case "parallels": {
                this.assignedParallels = this.assignedParallels + amount;
                break;
            }
            case "threading": {
                this.assignedThreading = this.assignedThreading + amount;
            }
        }
        this.ensureAssignment();
    }

    public void unassignStat(String stat, int amount) {
        switch (stat) {
            case "speed": {
                amount = Math.min(this.assignedSpeed, amount);
                if (this.assignedSpeed - amount < 0) break;
                this.assignedSpeed = this.assignedSpeed - amount;
                break;
            }
            case "efficiency": {
                amount = Math.min(this.assignedEfficiency, amount);
                if (this.assignedEfficiency - amount < 0) break;
                this.assignedEfficiency = this.assignedEfficiency - amount;
                break;
            }
            case "parallels": {
                amount = Math.min(this.assignedParallels, amount);
                if (this.assignedParallels - amount < 0) break;
                this.assignedParallels = this.assignedParallels - amount;
                break;
            }
            case "threading": {
                amount = Math.min(this.assignedThreading, amount);
                if (this.assignedThreading - amount < 0) break;
                this.assignedThreading = this.assignedThreading - amount;
            }
        }
        this.ensureAssignment();
    }

    public String[] getStatTypes() {
        return new String[]{"speed", "efficiency", "parallels", "threading"};
    }

    public void increaseStats(StarTThreadingStatsPredicate.ThreadingStatsBlockTracker stats) {
        this.generalTotal = this.generalTotal + stats.general * stats.amount;
        this.speed = this.speed + stats.speed * stats.amount;
        this.efficiency = this.efficiency + stats.efficiency * stats.amount;
        this.parallels = this.parallels + stats.parallels * stats.amount;
        this.threading = this.threading + stats.threading * stats.amount;
    }

    public void updateStats() {
        if (this.getLevel().f_46443_) {
            return;
        }
        this.resetStats();
        PatternMatchContext matchContext = this.getMultiblockState().getMatchContext();
        for (Map.Entry entry : matchContext.entrySet()) {
            if (!((String)entry.getKey()).startsWith(StarTThreadingStatsPredicate.THREADING_STATS_HEADER)) continue;
            StarTThreadingStatsPredicate.ThreadingStatsBlockTracker stats = (StarTThreadingStatsPredicate.ThreadingStatsBlockTracker)entry.getValue();
            this.stats.put(stats.name.replace(StarTThreadingStatsPredicate.THREADING_STATS_HEADER, ""), stats);
            this.increaseStats(stats);
        }
        this.ensureAssignment();
    }

    private double calculateDurationMultiplier() {
        int spdPointsPerMark = 100;
        int speedPoints = this.getEffectiveDurationReduction();
        double amountSpdMark = (double)speedPoints / (double)spdPointsPerMark;
        double timesDurationHalved = (-1.0 + Math.sqrt(1.0 + 8.0 * amountSpdMark)) / 2.0;
        return Math.pow(2.0, -1.0 * timesDurationHalved);
    }

    private double calculateEnergyMultiplier() {
        int effPointsPerMark = 30;
        int efficiencyPoints = this.getEffectivePowerReduction();
        return (double)effPointsPerMark / (double)(effPointsPerMark + efficiencyPoints);
    }

    public static ModifierFunction recipeModifier(MetaMachine machine, GTRecipe recipe) {
        StarTThreadingCapableMachine controller;
        if (machine instanceof StarTThreadingCapableMachine && (controller = (StarTThreadingCapableMachine)machine).isFormed()) {
            int parallels = ParallelLogic.getParallelAmountFast((MetaMachine)machine, (GTRecipe)recipe, (int)controller.getEffectiveParallels());
            double durationMultiplier = controller.calculateDurationMultiplier();
            double energyMultiplier = controller.calculateEnergyMultiplier();
            double finalDurationMultiplier = durationMultiplier * Math.sqrt(parallels);
            return ModifierFunction.builder().modifyAllContents(ContentModifier.multiplier((double)parallels)).durationMultiplier(finalDurationMultiplier).eutMultiplier(energyMultiplier).parallels(parallels).build();
        }
        return ModifierFunction.IDENTITY;
    }

    public void onStructureInvalid() {
        this.getParts().forEach(part -> {
            if (part instanceof StarTThreadingControllerPartMachine) {
                StarTThreadingControllerPartMachine threadingController = (StarTThreadingControllerPartMachine)((Object)part);
                threadingController.clearController();
            }
        });
        this.activeThreads.clear();
        if (this.threadTickableSubscription != null) {
            this.threadTickableSubscription.unsubscribe();
            this.threadTickableSubscription = null;
        }
        super.onStructureInvalid();
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.stats.clear();
        this.updateStats();
        this.getParts().forEach(part -> {
            if (part instanceof StarTThreadingControllerPartMachine) {
                StarTThreadingControllerPartMachine threadingController = (StarTThreadingControllerPartMachine)((Object)part);
                threadingController.setAssociatedController(this);
            }
        });
        if (Objects.isNull(this.threadTickableSubscription)) {
            this.threadTickableSubscription = this.subscribeServerTick(this::tickThreads);
        } else {
            this.threadTickableSubscription.unsubscribe();
            this.threadTickableSubscription = this.subscribeServerTick(this::tickThreads);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.getLevel().f_46443_) {
            return;
        }
        this.threadTickableSubscription = this.subscribeServerTick(this::tickThreads);
    }

    public void onUnload() {
        super.onUnload();
        if (Objects.nonNull(this.threadTickableSubscription)) {
            this.threadTickableSubscription.unsubscribe();
            this.threadTickableSubscription = null;
        }
    }

    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        if (this.isFormed()) {
            textList.add((Component)Component.m_237119_());
            textList.add((Component)Component.m_237115_((String)"start_core.machine.threading_controller.header"));
            textList.add((Component)this.getActualDurationPrettyFormat());
            textList.add((Component)this.getEfficiencyPrettyFormat());
            textList.add((Component)this.getParallelsPrettyFormat());
            textList.add((Component)this.getThreadsPrettyFormat());
            if (this.activeThreads.size() > 0) {
                textList.add((Component)Component.m_237119_());
                textList.add((Component)Component.m_237115_((String)"start_core.machine.threading_controller.active_threads"));
                int threadNum = 1;
                for (ThreadedRecipeExecution thread : this.activeThreads) {
                    textList.add((Component)Component.m_237119_());
                    textList.add((Component)Component.m_237110_((String)"start_core.machine.threading_controller.thread_header", (Object[])new Object[]{Component.m_237113_((String)FormattingUtil.formatNumbers((int)threadNum)).m_130940_(ChatFormatting.GOLD)}));
                    MultiblockDisplayText.builder(textList, (boolean)true).setWorkingStatus(true, true).addProgressLine((double)(thread.totalDuration - thread.ticksRemaining), (double)thread.totalDuration, (double)(thread.totalDuration - thread.ticksRemaining) / (double)thread.totalDuration).addOutputLines(thread.recipe);
                    ++threadNum;
                }
            }
            textList.add((Component)Component.m_237119_());
            textList.add((Component)Component.m_237110_((String)"start_core.machine.threading_controller.threads_available", (Object[])new Object[]{Component.m_237113_((String)FormattingUtil.formatNumbers((int)(this.getEffectiveThreads() - this.activeThreads.size()))).m_130940_(ChatFormatting.RED)}));
        }
    }

    private List<GTRecipe> findThreadedRecipes() {
        Set allMatches;
        int maxThreads = this.getEffectiveThreads();
        if (maxThreads < 1 || this.recipeLogic == null) {
            return List.of();
        }
        int availableThreads = maxThreads - (this.activeThreads != null ? this.activeThreads.size() : 0);
        if (availableThreads <= 0) {
            return List.of();
        }
        GTRecipeType recipeType = this.recipeLogic.machine.getRecipeType();
        if (recipeType == null) {
            return List.of();
        }
        HashSet<ResourceLocation> excludedIds = new HashSet<ResourceLocation>(maxThreads + 4);
        GTRecipe lastRecipe = this.recipeLogic.getLastRecipe();
        if (lastRecipe != null && lastRecipe.m_6423_() != null) {
            excludedIds.add(lastRecipe.m_6423_());
        }
        if (this.activeThreads != null && !this.activeThreads.isEmpty()) {
            for (ThreadedRecipeExecution thread : this.activeThreads) {
                GTRecipe r = thread.recipe;
                if (r == null || r.m_6423_() == null) continue;
                excludedIds.add(r.m_6423_());
            }
        }
        if ((allMatches = recipeType.getLookup().findRecipeCollisions((IRecipeCapabilityHolder)this.recipeLogic.machine)) == null || allMatches.isEmpty()) {
            return List.of();
        }
        ArrayList<GTRecipe> result = new ArrayList<GTRecipe>(Math.min(availableThreads, allMatches.size()));
        for (GTRecipe candidate : allMatches) {
            ResourceLocation id;
            if (candidate == null || (id = candidate.m_6423_()) == null || excludedIds.contains(id) || !this.canConsumeRecipeInputs(candidate)) continue;
            result.add(candidate);
            if (result.size() < availableThreads) continue;
            break;
        }
        return result;
    }

    private boolean canConsumeRecipeInputs(GTRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        return recipe.matchRecipe((IRecipeCapabilityHolder)this.recipeLogic.machine).isSuccess() && recipe.matchTickRecipe((IRecipeCapabilityHolder)this.recipeLogic.machine).isSuccess() && recipe.checkConditions(this.recipeLogic).isSuccess();
    }

    private void consumeRecipeInputs(GTRecipe recipe) {
        if (recipe == null) {
            return;
        }
        HashMap chanceCaches = new HashMap();
        recipe.handleRecipeIO(IO.IN, (IRecipeCapabilityHolder)this.recipeLogic.machine, chanceCaches);
    }

    private void tickThreads() {
        if (!this.isWorkingEnabled() || this.getLevel().f_46443_ || !this.isFormed()) {
            return;
        }
        if (this.activeThreads != null && !this.activeThreads.isEmpty()) {
            ArrayList<ThreadedRecipeExecution> completedThreads = new ArrayList<ThreadedRecipeExecution>();
            for (ThreadedRecipeExecution thread : this.activeThreads) {
                GTRecipe recipe = thread.recipe;
                if (recipe.matchTickRecipe((IRecipeCapabilityHolder)this.recipeLogic.machine).isSuccess()) {
                    this.handleThreadPerTickInputs(thread);
                    this.handleThreadPerTickOutputs(thread);
                    --thread.ticksRemaining;
                    thread.isWorking = true;
                    if (thread.ticksRemaining > 0) continue;
                    completedThreads.add(thread);
                    continue;
                }
                thread.isWorking = false;
                thread.ticksRemaining = Math.min(thread.ticksRemaining + 1, thread.totalDuration);
            }
            for (ThreadedRecipeExecution completed : completedThreads) {
                this.handleThreadCompletion(completed);
                this.activeThreads.remove(completed);
            }
        }
        if (this.getEffectiveThreads() > 0 && this.activeThreads.size() < this.getEffectiveThreads()) {
            this.setupThreadedExecution();
        }
    }

    private void setupThreadedExecution() {
        List<GTRecipe> recipes = this.findThreadedRecipes();
        if (recipes.size() < 1) {
            return;
        }
        for (int i = 0; i < recipes.size(); ++i) {
            GTRecipe recipe = recipes.get(i);
            if (!this.canConsumeRecipeInputs(recipe)) continue;
            GTRecipe modifiedRecipe = recipe;
            if (this.getDefinition().getRecipeModifier() != null) {
                RecipeModifier recipeModifier = this.getDefinition().getRecipeModifier();
                if (recipeModifier instanceof RecipeModifierList) {
                    RecipeModifierList list = (RecipeModifierList)recipeModifier;
                    modifiedRecipe = list.applyModifier((MetaMachine)this, modifiedRecipe);
                } else {
                    modifiedRecipe = this.getDefinition().getRecipeModifier().applyModifier((MetaMachine)this, modifiedRecipe);
                }
            }
            try {
                this.consumeRecipeInputs(modifiedRecipe);
                this.activeThreads.add(new ThreadedRecipeExecution(modifiedRecipe, modifiedRecipe.duration));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void handleThreadPerTickInputs(ThreadedRecipeExecution thread) {
        if (thread.recipe == null) {
            return;
        }
        HashMap chanceCaches = new HashMap();
        thread.recipe.handleTickRecipeIO(IO.IN, (IRecipeCapabilityHolder)this.recipeLogic.machine, chanceCaches);
    }

    private void handleThreadPerTickOutputs(ThreadedRecipeExecution thread) {
        if (thread.recipe == null) {
            return;
        }
        HashMap chanceCaches = new HashMap();
        thread.recipe.handleTickRecipeIO(IO.OUT, (IRecipeCapabilityHolder)this.recipeLogic.machine, chanceCaches);
    }

    private void handleThreadCompletion(ThreadedRecipeExecution thread) {
        if (thread.recipe == null) {
            return;
        }
        HashMap chanceCaches = new HashMap();
        thread.recipe.handleRecipeIO(IO.OUT, (IRecipeCapabilityHolder)this.recipeLogic.machine, chanceCaches);
    }

    public void afterWorking() {
        super.afterWorking();
        if (this.getLevel().f_46443_) {
            return;
        }
        if (this.recipeLogic.getProgress() == 0 && this.activeThreads != null) {
            this.activeThreads.clear();
        }
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public HashMap<String, StarTThreadingStatsPredicate.ThreadingStatsBlockTracker> getStats() {
        return this.stats;
    }

    public List<ThreadedRecipeExecution> getActiveThreads() {
        return this.activeThreads;
    }

    public static class ThreadedRecipeExecution {
        public GTRecipe recipe;
        public int ticksRemaining;
        public int totalDuration;
        public boolean isWorking;

        public ThreadedRecipeExecution(GTRecipe recipe, int duration) {
            this.recipe = recipe;
            this.ticksRemaining = duration;
            this.totalDuration = duration;
            this.isWorking = false;
        }

        public ThreadedRecipeExecution(GTRecipe recipe, int duration, int ticksRemaining, boolean isWorking) {
            this.recipe = recipe;
            this.ticksRemaining = ticksRemaining;
            this.totalDuration = duration;
            this.isWorking = isWorking;
        }
    }

    public static class ThreadedRecipeExecutionAccessor
    extends CustomObjectAccessor<ThreadedRecipeExecution> {
        public ThreadedRecipeExecutionAccessor() {
            super(ThreadedRecipeExecution.class, true);
        }

        public ITypedPayload<?> serialize(AccessorOp accessorOp, ThreadedRecipeExecution threadedRecipeExecution) {
            FriendlyByteBuf serializedHolder = new FriendlyByteBuf(Unpooled.buffer());
            serializedHolder.writeInt(threadedRecipeExecution.ticksRemaining);
            serializedHolder.writeInt(threadedRecipeExecution.totalDuration);
            serializedHolder.writeBoolean(threadedRecipeExecution.isWorking);
            serializedHolder.m_130070_(threadedRecipeExecution.recipe.id.toString());
            GTRecipeSerializer.SERIALIZER.toNetwork(serializedHolder, threadedRecipeExecution.recipe);
            return FriendlyBufPayload.of((FriendlyByteBuf)serializedHolder);
        }

        public ThreadedRecipeExecution deserialize(AccessorOp accessorOp, ITypedPayload<?> payload) {
            if (payload instanceof FriendlyBufPayload) {
                FriendlyBufPayload buffer = (FriendlyBufPayload)payload;
                int ticksRemaining = ((FriendlyByteBuf)buffer.getPayload()).readInt();
                int totalDuration = ((FriendlyByteBuf)buffer.getPayload()).readInt();
                boolean isWorking = ((FriendlyByteBuf)buffer.getPayload()).readBoolean();
                ResourceLocation id = new ResourceLocation(((FriendlyByteBuf)buffer.getPayload()).m_130277_());
                GTRecipe innerRecipe = GTRecipeSerializer.SERIALIZER.fromNetwork(id, (FriendlyByteBuf)buffer.getPayload());
                return new ThreadedRecipeExecution(innerRecipe, totalDuration, ticksRemaining, isWorking);
            }
            return null;
        }
    }
}

