/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.machine.steam;

import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamEnergyRecipeHandler;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.common.machine.multiblock.part.SteamHatchPartMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StarTSteamParallelMultiblockMachine
extends WorkableMultiblockMachine
implements IDisplayUIMachine {
    public int maxParallels = 6;
    public static final double CONVERSION_RATE = 3.0;

    public StarTSteamParallelMultiblockMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, new Object[0]);
        Object object;
        if (args.length > 0 && (object = args[0]) instanceof Integer) {
            Integer i = (Integer)object;
            this.maxParallels = i;
        }
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        List handlers = (List)this.capabilitiesProxy.get((Object)IO.IN, (Object)FluidRecipeCapability.CAP);
        if (handlers == null) {
            return;
        }
        Iterator itr = handlers.iterator();
        while (itr.hasNext()) {
            IRecipeHandler handler = (IRecipeHandler)itr.next();
            if (!(handler instanceof NotifiableFluidTank)) continue;
            NotifiableFluidTank tank = (NotifiableFluidTank)handler;
            if (!(((NotifiableFluidTank)handler).getMachine() instanceof SteamHatchPartMachine)) continue;
            itr.remove();
            this.capabilitiesProxy.put((Object)IO.IN, (Object)EURecipeCapability.CAP, new ArrayList());
            ((List)this.capabilitiesProxy.get((Object)IO.IN, (Object)EURecipeCapability.CAP)).add(new SteamEnergyRecipeHandler(tank, 3.0));
            return;
        }
    }

    public double getConversionRate() {
        return 3.0;
    }

    public static ModifierFunction recipeModifier(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        int parallelAmount;
        if (!(machine instanceof StarTSteamParallelMultiblockMachine)) {
            return RecipeModifier.nullWrongType(StarTSteamParallelMultiblockMachine.class, (MetaMachine)machine);
        }
        StarTSteamParallelMultiblockMachine steamMachine = (StarTSteamParallelMultiblockMachine)machine;
        if (RecipeHelper.getRecipeEUtTier((GTRecipe)recipe) > 1) {
            return ModifierFunction.NULL;
        }
        long eut = RecipeHelper.getInputEUt((GTRecipe)recipe);
        double eutMultiplier = (double)eut * 0.8888 * (double)(parallelAmount = ParallelLogic.getParallelAmount((MetaMachine)machine, (GTRecipe)recipe, (int)steamMachine.maxParallels)) <= 32.0 ? 0.8888 * (double)parallelAmount : 32.0 / (double)eut;
        return ModifierFunction.builder().inputModifier(ContentModifier.multiplier((double)parallelAmount)).outputModifier(ContentModifier.multiplier((double)parallelAmount)).durationMultiplier(1.05).eutMultiplier(eutMultiplier).parallels(parallelAmount).build();
    }

    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        if (this.isFormed()) {
            SteamEnergyRecipeHandler steamHandler;
            Object e;
            List handlers = (List)this.capabilitiesProxy.get((Object)IO.IN, (Object)EURecipeCapability.CAP);
            if (handlers != null && handlers.size() > 0 && (e = handlers.get(0)) instanceof SteamEnergyRecipeHandler && (steamHandler = (SteamEnergyRecipeHandler)e).getCapacity() > 0L) {
                long steamStored = steamHandler.getStored();
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.steam.steam_stored", (Object[])new Object[]{steamStored, steamHandler.getCapacity()}));
            }
            if (!this.isWorkingEnabled()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.work_paused"));
            } else if (this.isActive()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.running"));
                if (this.maxParallels > 1) {
                    textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.parallel", (Object[])new Object[]{this.maxParallels}));
                }
                int currentProgress = (int)(this.recipeLogic.getProgressPercent() * 100.0);
                double maxInSec = (float)this.recipeLogic.getDuration() / 20.0f;
                double currentInSec = (float)this.recipeLogic.getProgress() / 20.0f;
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.progress", (Object[])new Object[]{String.format("%.2f", Float.valueOf((float)currentInSec)), String.format("%.2f", Float.valueOf((float)maxInSec)), currentProgress}));
            } else {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.idling"));
            }
            if (this.recipeLogic.isWaiting()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.steam.low_steam").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            }
        }
    }

    public IGuiTexture getScreenTexture() {
        return GuiTextures.DISPLAY_STEAM.get(ConfigHolder.INSTANCE.machines.steelSteamMultiblocks);
    }

    public ModularUI createUI(Player entityPlayer) {
        DraggableScrollableWidgetGroup screen = new DraggableScrollableWidgetGroup(7, 4, 162, 121).setBackground(this.getScreenTexture());
        screen.addWidget((Widget)new LabelWidget(4, 5, this.self().getBlockState().m_60734_().m_7705_()));
        screen.addWidget((Widget)new ComponentPanelWidget(4, 17, this::addDisplayText).setMaxWidthLimit(150).clickHandler((arg_0, arg_1) -> ((StarTSteamParallelMultiblockMachine)this).handleDisplayClick(arg_0, arg_1)));
        return new ModularUI(176, 216, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND_STEAM.get(ConfigHolder.INSTANCE.machines.steelSteamMultiblocks)}).widget((Widget)screen).widget((Widget)UITemplate.bindPlayerInventory((Inventory)entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT_STEAM.get(ConfigHolder.INSTANCE.machines.steelSteamMultiblocks), (int)7, (int)134, (boolean)true));
    }
}

