/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.machine.parallel;

import com.gregtechceu.gtceu.api.capability.IParallelHatch;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredPartMachine;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.startechnology.start_core.machine.parallel.IStarTAbsoluteParallelHatch;
import net.minecraft.util.Mth;

public class StarTAbsoluteParallelHatchMachine
extends TieredPartMachine
implements IFancyUIMachine,
IStarTAbsoluteParallelHatch,
IParallelHatch {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(StarTAbsoluteParallelHatchMachine.class, MultiblockPartMachine.MANAGED_FIELD_HOLDER);
    private static final int MIN_PARALLEL = 1;
    private final int maxParallel;
    @Persisted
    private int currentParallel = 1;

    public StarTAbsoluteParallelHatchMachine(IMachineBlockEntity holder, int tier) {
        super(holder, tier);
        this.maxParallel = 4 * (int)Math.pow(2.0, tier - 9);
    }

    public void setCurrentParallel(int parallelAmount) {
        this.currentParallel = Mth.m_14045_((int)parallelAmount, (int)1, (int)this.maxParallel);
        for (IMultiController controller : this.getControllers()) {
            if (!(controller instanceof IRecipeLogicMachine)) continue;
            IRecipeLogicMachine rlm = (IRecipeLogicMachine)controller;
            rlm.getRecipeLogic().markLastRecipeDirty();
        }
    }

    public Widget createUIWidget() {
        WidgetGroup parallelAmountGroup = new WidgetGroup(0, 0, 100, 20);
        parallelAmountGroup.addWidget((Widget)new IntInputWidget(this::getCurrentParallel, this::setCurrentParallel).setMin((Number)1).setMax((Number)this.maxParallel));
        return parallelAmountGroup;
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public boolean canShared() {
        return false;
    }

    public int getCurrentParallel() {
        return this.currentParallel;
    }
}

