/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.machine.hellforge;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTRecipeCapabilities;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.startechnology.start_core.machine.redstone.StarTRedstoneInterfacePartMachine;
import com.startechnology.start_core.materials.StarTHellForgeHeatingLiquids;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class StarTHellForgeMachine
extends WorkableElectricMultiblockMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(StarTHellForgeMachine.class, WorkableElectricMultiblockMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    protected Integer temperature = 0;
    protected TickableSubscription tryTickSub;
    private boolean startHeatLoss = false;
    private boolean isWorking = false;
    public ArrayList<StarTRedstoneInterfacePartMachine> redstoneOutputHatches = new ArrayList();
    public static Map<Material, Integer> fluidsMap = Map.of(StarTHellForgeHeatingLiquids.FlamewakeSolvent, 900, StarTHellForgeHeatingLiquids.EmberheartNectar, 1800, StarTHellForgeHeatingLiquids.IgniferousElixir, 2700, StarTHellForgeHeatingLiquids.BlazingPhlogiston, 3600, StarTHellForgeHeatingLiquids.CinderbrewSolvent, 1350, StarTHellForgeHeatingLiquids.CorefireNectar, 2250, StarTHellForgeHeatingLiquids.InfernumElixir, 3150, StarTHellForgeHeatingLiquids.HellfireEssence, 4050);

    public StarTHellForgeMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.isWorking = false;
        this.startHeatLoss = true;
        this.getParts().stream().filter(StarTRedstoneInterfacePartMachine.class::isInstance).forEach(part -> this.redstoneOutputHatches.add((StarTRedstoneInterfacePartMachine)((Object)part)));
        this.temperatureChanged();
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.isWorking = false;
    }

    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        textList.add((Component)Component.m_237110_((String)"ui.start_core.hellforge_crucible", (Object[])new Object[]{this.temperature}));
    }

    public static Material getHellforgeHeatingLiquid(Integer temperature) {
        Material selectedFluid = null;
        int smallestCapAboveTemperature = Integer.MAX_VALUE;
        for (Map.Entry<Material, Integer> entry : fluidsMap.entrySet()) {
            int fluidCap = entry.getValue();
            if (fluidCap < temperature || fluidCap >= smallestCapAboveTemperature) continue;
            smallestCapAboveTemperature = fluidCap;
            selectedFluid = entry.getKey();
        }
        return selectedFluid;
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onLoad() {
        super.onLoad();
        if (this.getLevel().f_46443_) {
            return;
        }
        this.tryTickSub = this.subscribeServerTick(this.tryTickSub, this::tryRemoveHeat);
    }

    public void onUnload() {
        super.onUnload();
        if (this.getLevel().f_46443_) {
            return;
        }
        if (this.tryTickSub != null) {
            this.tryTickSub.unsubscribe();
            this.tryTickSub = null;
        }
    }

    protected void tryRemoveHeat() {
        if (this.getOffsetTimer() % 200L == 0L && this.startHeatLoss) {
            boolean machineActive = this.getRecipeLogic().isWorking();
            this.temperature = machineActive ? Integer.valueOf(Math.max(this.temperature - 5, 0)) : Integer.valueOf(Math.max(this.temperature - 125, 0));
            this.temperatureChanged();
        }
    }

    public boolean beforeWorking(@Nullable GTRecipe recipe) {
        boolean isWorking = super.beforeWorking(recipe);
        if (isWorking) {
            this.isWorking = true;
        }
        return isWorking;
    }

    private void temperatureChanged() {
        if (this.redstoneOutputHatches.isEmpty()) {
            return;
        }
        fluidsMap.entrySet().stream().forEach(entry -> {
            double percentageOfTier = (double)this.temperature.intValue() / (double)((Integer)entry.getValue()).intValue() * 15.0;
            this.redstoneOutputHatches.forEach(hatch -> hatch.setIndicatorSignal("Percentage to " + ((Integer)entry.getValue()).toString() + "MK", (int)Math.floor(percentageOfTier)));
        });
    }

    public void afterWorking() {
        FluidIngredient ingredient;
        FluidStack ingredientFluid;
        Material material;
        super.afterWorking();
        this.isWorking = false;
        GTRecipe lastRecipe = this.getRecipeLogic().getLastRecipe();
        List content = lastRecipe.getInputContents(GTRecipeCapabilities.FLUID);
        if (content.size() < 1) {
            return;
        }
        Object object = ((Content)content.get(0)).getContent();
        if (object instanceof FluidIngredient && fluidsMap.containsKey(material = ChemicalHelper.getMaterial((Fluid)(ingredientFluid = (ingredient = (FluidIngredient)object).getStacks()[0]).getFluid()))) {
            Integer maxHeat = fluidsMap.get(material);
            if (this.temperature < maxHeat) {
                Integer addTemperature = ingredientFluid.getFluid().getFluidType().getTemperature() / 1000000;
                Integer amountToAdd = (int)Math.floor(ingredientFluid.getAmount() / 1000);
                this.temperature = Math.min(this.temperature + addTemperature * amountToAdd, maxHeat);
                this.temperatureChanged();
            }
        }
    }

    public Integer getCrucibleTemperature() {
        return this.temperature;
    }
}

