/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.machine.drum;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.item.DrumMachineItem;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.client.renderer.machine.MachineRenderer;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gregtechceu.gtceu.common.machine.storage.DrumMachine;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.startechnology.start_core.StarTCore;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

public class StarTDrumMachines {
    public static MachineDefinition ENRICHED_NAQUADAH_DRUM = StarTDrumMachines.registerDrum(GTMaterials.NaquadahEnriched, 2048000, "Enriched Naquadah Drum");
    public static MachineDefinition NEUTRONIUM_DRUM = StarTDrumMachines.registerDrum(GTMaterials.Neutronium, 4096000, "Neutronium Drum");

    public static MachineDefinition registerDrum(Material material, int capacity, String lang) {
        MachineDefinition definition = StarTCore.START_REGISTRATE.machine(material.getName() + "_drum", MachineDefinition::createDefinition, holder -> new DrumMachine(holder, material, capacity, new Object[0]), MetaMachineBlock::new, (holder, prop) -> DrumMachineItem.create((IMachineBlock)holder, (Item.Properties)prop, (Material)material), MetaMachineBlockEntity::createBlockEntity).langValue(lang).rotationState(RotationState.NONE).renderer(() -> new MachineRenderer(GTCEu.id((String)"block/machine/metal_drum"))).tooltipBuilder((stack, list) -> {
            GTMachineUtils.TANK_TOOLTIPS.accept(stack, list);
            if (material.hasProperty(PropertyKey.FLUID_PIPE)) {
                FluidPipeProperties pipeprops = (FluidPipeProperties)material.getProperty(PropertyKey.FLUID_PIPE);
                pipeprops.appendTooltips(list, false, true);
            }
        }).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.quantum_tank.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers((int)capacity)})}).paintingColor(material.getMaterialRGB()).itemColor((s, i) -> material.getMaterialRGB()).register();
        GTMachineUtils.DRUM_CAPACITY.put((Object)definition, capacity);
        return definition;
    }

    public static void init() {
    }
}

