/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.machine.dreamlink;

import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.startechnology.start_core.api.capability.IStarTDreamLinkNetworkMachine;
import com.startechnology.start_core.api.capability.IStarTDreamLinkNetworkRecieveEnergy;
import com.startechnology.start_core.api.capability.IStarTGetMachineUUIDSafe;
import com.startechnology.start_core.machine.dreamlink.StarTDreamLinkManager;
import com.startechnology.start_core.machine.dreamlink.StarTDreamLinkRangeRenderer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import rx.Observable;

public class StarTDreamLinkTransmissionMachine
extends WorkableMultiblockMachine
implements IStarTDreamLinkNetworkMachine,
IFancyUIMachine,
IDisplayUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(StarTDreamLinkTransmissionMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    private EnergyContainerList inputHatches;
    protected ConditionalSubscriptionHandler tickSubscription;
    protected TickableSubscription tryTickSub;
    private ArrayList<IStarTDreamLinkNetworkRecieveEnergy> receiverCache = new ArrayList();
    private boolean isReadyToTransmit = false;
    @Persisted
    protected String network = "Untitled Network";
    protected String tempNetwork;
    private Integer range;
    private Integer connections;
    private Integer receiverCount;
    private Boolean checkDimension;

    public StarTDreamLinkTransmissionMachine(IMachineBlockEntity holder, Integer range, Integer connections, Boolean checkDimension) {
        super(holder, new Object[0]);
        this.tickSubscription = new ConditionalSubscriptionHandler((ITickSubscription)this, this::transferEnergyTick, () -> ((StarTDreamLinkTransmissionMachine)this).isFormed());
        this.inputHatches = new EnergyContainerList(new ArrayList());
        this.range = range;
        this.checkDimension = checkDimension;
        this.receiverCount = 0;
        this.connections = connections;
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        ArrayList<IEnergyContainer> inputs = new ArrayList<IEnergyContainer>();
        Map ioMap = (Map)this.getMultiblockState().getMatchContext().getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
        for (IMultiPart part : this.getParts()) {
            IO io = ioMap.getOrDefault(part.self().getPos().m_121878_(), IO.IN);
            if (io == IO.NONE) continue;
            for (IRecipeHandlerTrait handler : part.getRecipeHandlers()) {
                IO handlerIO = handler.getHandlerIO();
                if (io != IO.IN && handlerIO != IO.IN && io != handlerIO || handler.getCapability() != EURecipeCapability.CAP || !(handler instanceof IEnergyContainer)) continue;
                IEnergyContainer container = (IEnergyContainer)handler;
                inputs.add(container);
                this.traitSubscriptions.add(handler.addChangedListener(() -> ((ConditionalSubscriptionHandler)this.tickSubscription).updateSubscription()));
            }
        }
        this.inputHatches = new EnergyContainerList(inputs);
        this.isReadyToTransmit = true;
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        StarTDreamLinkRangeRenderer.toggleOffBoxAtPositionWithRange(this.getPos(), this.range);
    }

    public void onLoad() {
        super.onLoad();
        if (this.getLevel().f_46443_) {
            return;
        }
        this.tryTickSub = this.subscribeServerTick(this.tryTickSub, this::tryTransferEnergy);
    }

    public void onUnload() {
        super.onUnload();
        if (this.getLevel().f_46443_) {
            return;
        }
        if (this.tryTickSub != null) {
            this.tryTickSub.unsubscribe();
            this.tryTickSub = null;
            this.tickSubscription.unsubscribe();
            this.tickSubscription = null;
        }
        this.receiverCache.clear();
    }

    protected void tryTransferEnergy() {
        if (this.getOffsetTimer() % 60L == 0L && this.isReadyToTransmit) {
            this.updateTransferCache();
            this.transferEnergyTick();
        }
    }

    private void updateTransferCache() {
        if (this.getLevel().f_46443_ || !this.isReadyToTransmit || !this.isWorkingEnabled()) {
            return;
        }
        BlockPos centre = this.getPos();
        int x = centre.m_123341_();
        int z = centre.m_123343_();
        UUID thisUUID = IStarTGetMachineUUIDSafe.getUUIDSafeMetaMachine((MetaMachine)this);
        Observable<Entry<IStarTDreamLinkNetworkRecieveEnergy, Geometry>> machines = this.range != -1 ? StarTDreamLinkManager.getDevices(x + this.range, z + this.range, x - this.range, z - this.range, thisUUID) : StarTDreamLinkManager.getAllDevices(thisUUID);
        List deviceEntries = (List)machines.filter(machine -> ((IStarTDreamLinkNetworkRecieveEnergy)machine.value()).canRecieve(this, this.checkDimension)).toList().toBlocking().single();
        deviceEntries.sort((entryA, entryB) -> {
            BlockPos posA = ((IStarTDreamLinkNetworkRecieveEnergy)entryA.value()).devicePos();
            BlockPos posB = ((IStarTDreamLinkNetworkRecieveEnergy)entryB.value()).devicePos();
            return Double.compare(this.getSquaredDistanceToThis(posA), this.getSquaredDistanceToThis(posB));
        });
        if (this.connections != -1 && deviceEntries.size() > this.connections) {
            deviceEntries = deviceEntries.subList(0, this.connections);
        }
        this.receiverCache.clear();
        this.receiverCache.ensureCapacity(deviceEntries.size());
        for (Entry entry : deviceEntries) {
            this.receiverCache.add((IStarTDreamLinkNetworkRecieveEnergy)entry.value());
        }
        this.receiverCount = this.receiverCache.size();
    }

    private Double getSquaredDistanceToThis(BlockPos otherPos) {
        Vec3 thisCenter = this.getPos().m_252807_();
        Vec3 otherCenter = otherPos.m_252807_();
        return thisCenter.m_82557_(otherCenter);
    }

    protected void transferEnergyTick() {
        if (this.getLevel().f_46443_ || !this.isReadyToTransmit || !this.isWorkingEnabled()) {
            return;
        }
        int receiverCount = this.receiverCache.size();
        if (receiverCount == 0) {
            return;
        }
        long energyStored = this.inputHatches.getEnergyStored();
        if (energyStored <= 0L) {
            return;
        }
        long totalEnergyTransferred = 0L;
        Object[] receivers = this.receiverCache.toArray();
        for (int i = 0; i < receiverCount && energyStored > 0L; ++i) {
            IStarTDreamLinkNetworkRecieveEnergy device = (IStarTDreamLinkNetworkRecieveEnergy)receivers[i];
            long energyToTransfer = device.recieveEnergy(energyStored);
            if (energyToTransfer <= 0L) continue;
            totalEnergyTransferred += energyToTransfer;
            energyStored -= energyToTransfer;
        }
        if (totalEnergyTransferred > 0L) {
            this.inputHatches.removeEnergy(totalEnergyTransferred);
        }
    }

    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        if (this.isFormed() && this.isReadyToTransmit) {
            if (this.inputHatches.getOutputPerSec() > 0L) {
                textList.add((Component)Component.m_237115_((String)"start_core.machine.dream_link.active"));
            } else {
                textList.add((Component)Component.m_237115_((String)"start_core.machine.dream_link.not_active"));
            }
            this.addTowerStatsDisplay(textList);
        }
        this.getDefinition().getAdditionalDisplay().accept(this, textList);
    }

    private void addTowerStatsDisplay(List<Component> textList) {
        MutableComponent ownerComponent = Component.m_237113_((String)this.getHolder().getOwner().getName());
        textList.add((Component)Component.m_237115_((String)"start_core.machine.dream_link.owner_title").m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.dream_link.tower.owner_hover")))));
        textList.add((Component)Component.m_237110_((String)"start_core.machine.dream_link.owner", (Object[])new Object[]{ownerComponent}).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.dream_link.tower.owner_hover")))));
        MutableComponent inAmountComponent = Component.m_237113_((String)FormattingUtil.formatNumbers((long)(this.inputHatches.getInputPerSec() / 20L))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN));
        textList.add((Component)Component.m_237110_((String)"start_core.machine.dream_link.input_per_sec", (Object[])new Object[]{inAmountComponent}).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.dream_link.tower.input_per_sec_hover")))));
        MutableComponent outAmountComponent = Component.m_237113_((String)FormattingUtil.formatNumbers((long)(this.inputHatches.getOutputPerSec() / 20L))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        textList.add((Component)Component.m_237110_((String)"start_core.machine.dream_link.output_per_sec", (Object[])new Object[]{outAmountComponent}).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.dream_link.tower.output_per_sec_hover")))));
        MutableComponent totalBufferComponent = Component.m_237113_((String)FormattingUtil.formatNumbers((long)this.inputHatches.getEnergyStored())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD));
        textList.add((Component)Component.m_237115_((String)"start_core.machine.dream_link.total_buffer").m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.dream_link.tower.total_buffer_hover")))));
        textList.add((Component)Component.m_237110_((String)"start_core.machine.dream_link.total_buffer_value", (Object[])new Object[]{totalBufferComponent}).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.dream_link.tower.total_buffer_hover")))));
        if (this.range != -1) {
            MutableComponent rangeComponent = Component.m_237113_((String)FormattingUtil.formatNumbers((Object)this.range)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD));
            textList.add((Component)Component.m_237110_((String)"start_core.machine.dream_link.range", (Object[])new Object[]{rangeComponent}).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.dream_link.tower.range_hover")))));
            textList.add(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)"start_core.machine.dream_link.tower.range_show").m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.dream_link.tower.range_button_hover")))), (String)"range"));
        } else if (this.checkDimension.booleanValue()) {
            textList.add((Component)Component.m_237115_((String)"start_core.machine.dream_link.unlimited_range").m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.dream_link.tower.range_hover")))));
        } else {
            textList.add((Component)Component.m_237115_((String)"start_core.machine.dream_link.paragon_range").m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.dream_link.tower.range_hover")))));
        }
        MutableComponent currentConnections = Component.m_237113_((String)FormattingUtil.formatNumbers((Object)this.receiverCount)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE));
        MutableComponent maxConnections = Component.m_237113_((String)(this.connections == -1 ? "\u221e" : FormattingUtil.formatNumbers((Object)this.connections))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA));
        MutableComponent connectionsDisplay = Component.m_237113_((String)"").m_7220_((Component)currentConnections).m_7220_((Component)Component.m_237113_((String)" / ").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY))).m_7220_((Component)maxConnections);
        textList.add((Component)Component.m_237110_((String)"start_core.machine.dream_link.connections_display", (Object[])new Object[]{connectionsDisplay}).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.dream_link.tower.connections_display_hover")))));
    }

    public void onDreamLinkComponentPanelClicked(String componentData, ClickData clickData) {
        if (clickData.isRemote && Objects.equals(componentData, "range")) {
            StarTDreamLinkRangeRenderer.toggleBoxAtPositionWithRange(this.getPos(), this.range);
        }
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 190, 125);
        group.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, 182, 117).setBackground((IGuiTexture)GuiTextures.DISPLAY).addWidget((Widget)new LabelWidget(4, 5, "Dream-link Transmission Node")).addWidget((Widget)new LabelWidget(4, 20, "\u00a77Dream-Network Identifier")).addWidget(new TextFieldWidget(4, 32, 174, 12, this::getTempNetwork, this::setTempNetwork).setMaxStringLength(64).setValidator(input -> {
            if (input == null) {
                return "";
            }
            return input;
        }).setHoverTooltips(new Component[]{Component.m_237115_((String)"start_core.machine.dream_link.network_set_hover")})).addWidget((Widget)new ComponentPanelWidget(4, 50, this::addDisplayText).clickHandler(this::onDreamLinkComponentPanelClicked)));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return true;
    }

    private void closeUI() {
        this.network = this.tempNetwork;
        if (this.tempNetwork.isBlank()) {
            this.network = "Untitled Network";
        }
    }

    public ModularUI createUI(Player entityPlayer) {
        this.tempNetwork = this.network;
        ModularUI ui = new ModularUI(198, 208, (IUIHolder)this, entityPlayer).widget((Widget)new FancyMachineUIWidget((IFancyUIProvider)this, 198, 208));
        ui.registerCloseListener(this::closeUI);
        return ui;
    }

    public List<IFancyUIProvider> getSubTabs() {
        return this.getParts().stream().filter(IFancyUIProvider.class::isInstance).map(IFancyUIProvider.class::cast).toList();
    }

    public void attachTooltips(TooltipsPanel tooltipsPanel) {
        for (IMultiPart part : this.getParts()) {
            part.attachFancyTooltipsToController((IMultiController)this, tooltipsPanel);
        }
    }

    @Override
    public void setNetwork(String network) {
        this.network = network;
    }

    @Override
    public String getNetwork() {
        return this.network;
    }

    @Override
    public final InteractionResult onDreamCopyShiftUse(Player player, ItemStack copyItem) {
        if (!this.isRemote()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("dream_network", this.getNetwork());
            copyItem.m_41751_(tag);
            copyItem.m_41714_((Component)Component.m_237110_((String)"start_core.machine.dream_link.lucinducer.name", (Object[])new Object[]{this.getNetwork()}));
            player.m_213846_((Component)Component.m_237115_((String)"start_core.machine.dream_link.copy_network"));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public final InteractionResult onDreamCopyUse(Player player, ItemStack copyItem) {
        CompoundTag tag = copyItem.m_41783_();
        if (tag == null || !tag.m_128441_("dream_network")) {
            return InteractionResult.PASS;
        }
        if (!this.isRemote()) {
            String network = tag.m_128461_("dream_network");
            this.setNetwork(network);
            player.m_213846_((Component)Component.m_237115_((String)"start_core.machine.dream_link.set_network"));
        }
        return InteractionResult.m_19078_((boolean)this.isRemote());
    }

    @Override
    public boolean isDreaming() {
        return this.inputHatches.getOutputPerSec() > 0L;
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public String getTempNetwork() {
        return this.tempNetwork;
    }

    public void setTempNetwork(String tempNetwork) {
        this.tempNetwork = tempNetwork;
    }
}

