/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.machine.dreamlink;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="start_core", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class StarTDreamLinkRangeRenderer {
    private static final Set<ActiveBoxData> activeBoxes = new HashSet<ActiveBoxData>();
    private static final RenderStateShard.TransparencyStateShard TRANSLUCENT_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("translucent", () -> {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }, RenderSystem::disableBlend);
    private static final RenderStateShard.WriteMaskStateShard CUSTOM_COLOR_DEPTH_WRITE = new RenderStateShard.WriteMaskStateShard(true, true);
    private static final RenderType TRANSLUCENT_FILL = RenderType.m_173215_((String)"bounding_box_fill", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172811_)).m_110685_(TRANSLUCENT_TRANSPARENCY).m_110687_(CUSTOM_COLOR_DEPTH_WRITE).m_110661_(new RenderStateShard.CullStateShard(false)).m_110691_(true));

    public static void toggleBoxAtPositionWithRange(BlockPos position, Integer range) {
        ActiveBoxData boxData = new ActiveBoxData(position, range);
        if (activeBoxes.contains(boxData)) {
            activeBoxes.remove(boxData);
        } else {
            activeBoxes.add(boxData);
        }
    }

    public static void toggleOnBoxAtPositionWithRange(BlockPos position, Integer range) {
        ActiveBoxData boxData = new ActiveBoxData(position, range);
        if (!activeBoxes.contains(boxData)) {
            activeBoxes.add(boxData);
        }
    }

    public static void toggleOffBoxAtPositionWithRange(BlockPos position, Integer range) {
        ActiveBoxData boxData = new ActiveBoxData(position, range);
        if (activeBoxes.contains(boxData)) {
            activeBoxes.remove(boxData);
        }
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || activeBoxes.isEmpty() || mc.f_91073_ == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Camera camera = mc.f_91063_.m_109153_();
        double camX = camera.m_90583_().f_82479_;
        double camY = camera.m_90583_().f_82480_;
        double camZ = camera.m_90583_().f_82481_;
        poseStack.m_85836_();
        poseStack.m_85837_(-camX, -camY, -camZ);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::m_172811_);
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        VertexConsumer buffer = bufferSource.m_6299_(TRANSLUCENT_FILL);
        for (ActiveBoxData boxData : activeBoxes) {
            BlockPos pos = boxData.position;
            double radius = (double)boxData.range.intValue() - (double)0.01f;
            double x1 = (double)pos.m_123341_() - radius;
            double z1 = (double)pos.m_123343_() - radius;
            double x2 = (double)pos.m_123341_() + radius + 1.0;
            double z2 = (double)pos.m_123343_() + radius + 1.0;
            double minY = mc.f_91073_.m_141937_();
            double maxY = mc.f_91073_.m_151558_();
            int posColour = pos.hashCode();
            StarTDreamLinkRangeRenderer.renderWalls(poseStack, buffer, x1, minY, z1, x2, maxY, z2, posColour, 0.3f);
        }
        bufferSource.m_109912_(TRANSLUCENT_FILL);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private static void renderWalls(PoseStack poseStack, VertexConsumer buffer, double x1, double y1, double z1, double x2, double y2, double z2, int hashCode, float a) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float baseHue = (float)(hashCode & 0xFFFFFF) / 1.6777215E7f;
        Function<Float, float[]> hsvToRgb = h -> {
            float s = 1.0f;
            float v = 1.0f;
            float c = v * s;
            float x = c * (1.0f - Math.abs(h.floatValue() * 6.0f % 2.0f - 1.0f));
            float m = v - c;
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            if (h.floatValue() < 0.16666667f) {
                r = c;
                g = x;
            } else if (h.floatValue() < 0.33333334f) {
                r = x;
                g = c;
            } else if (h.floatValue() < 0.5f) {
                g = c;
                b = x;
            } else if (h.floatValue() < 0.6666667f) {
                g = x;
                b = c;
            } else if (h.floatValue() < 0.8333333f) {
                r = x;
                b = c;
            } else {
                r = c;
                b = x;
            }
            return new float[]{r + m, g + m, b + m};
        };
        float hueStep = 0.125f;
        float[][] colors = new float[8][3];
        for (int i = 0; i < 8; ++i) {
            colors[i] = hsvToRgb.apply(Float.valueOf((baseHue + (float)i * hueStep) % 1.0f));
        }
        buffer.m_252986_(matrix, (float)x1, (float)y1, (float)z1).m_85950_(colors[0][0], colors[0][1], colors[0][2], a).m_5752_();
        buffer.m_252986_(matrix, (float)x2, (float)y1, (float)z1).m_85950_(colors[1][0], colors[1][1], colors[1][2], a).m_5752_();
        buffer.m_252986_(matrix, (float)x2, (float)y2, (float)z1).m_85950_(colors[2][0], colors[2][1], colors[2][2], a).m_5752_();
        buffer.m_252986_(matrix, (float)x1, (float)y2, (float)z1).m_85950_(colors[3][0], colors[3][1], colors[3][2], a).m_5752_();
        buffer.m_252986_(matrix, (float)x2, (float)y1, (float)z2).m_85950_(colors[4][0], colors[4][1], colors[4][2], a).m_5752_();
        buffer.m_252986_(matrix, (float)x1, (float)y1, (float)z2).m_85950_(colors[5][0], colors[5][1], colors[5][2], a).m_5752_();
        buffer.m_252986_(matrix, (float)x1, (float)y2, (float)z2).m_85950_(colors[6][0], colors[6][1], colors[6][2], a).m_5752_();
        buffer.m_252986_(matrix, (float)x2, (float)y2, (float)z2).m_85950_(colors[7][0], colors[7][1], colors[7][2], a).m_5752_();
        buffer.m_252986_(matrix, (float)x1, (float)y1, (float)z2).m_85950_(colors[5][0], colors[5][1], colors[5][2], a).m_5752_();
        buffer.m_252986_(matrix, (float)x1, (float)y1, (float)z1).m_85950_(colors[0][0], colors[0][1], colors[0][2], a).m_5752_();
        buffer.m_252986_(matrix, (float)x1, (float)y2, (float)z1).m_85950_(colors[3][0], colors[3][1], colors[3][2], a).m_5752_();
        buffer.m_252986_(matrix, (float)x1, (float)y2, (float)z2).m_85950_(colors[6][0], colors[6][1], colors[6][2], a).m_5752_();
        buffer.m_252986_(matrix, (float)x2, (float)y1, (float)z1).m_85950_(colors[1][0], colors[1][1], colors[1][2], a).m_5752_();
        buffer.m_252986_(matrix, (float)x2, (float)y1, (float)z2).m_85950_(colors[4][0], colors[4][1], colors[4][2], a).m_5752_();
        buffer.m_252986_(matrix, (float)x2, (float)y2, (float)z2).m_85950_(colors[7][0], colors[7][1], colors[7][2], a).m_5752_();
        buffer.m_252986_(matrix, (float)x2, (float)y2, (float)z1).m_85950_(colors[2][0], colors[2][1], colors[2][2], a).m_5752_();
    }

    private static class ActiveBoxData {
        public BlockPos position;
        public Integer range;

        public ActiveBoxData(BlockPos position, Integer range) {
            this.position = position;
            this.range = range;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
            result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ActiveBoxData)) {
                return false;
            }
            ActiveBoxData other = (ActiveBoxData)obj;
            if (this.position == null ? other.position != null : !this.position.equals((Object)other.position)) {
                return false;
            }
            return !(this.range == null ? other.range != null : !this.range.equals(other.range));
        }
    }
}

