/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.machine.dreamlink;

import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.RTree;
import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.startechnology.start_core.api.capability.IStarTDreamLinkNetworkRecieveEnergy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import rx.Observable;

public class StarTDreamLinkManager {
    private HashMap<UUID, RTree<IStarTDreamLinkNetworkRecieveEnergy, Geometry>> DREAM_LINK_TREE = new HashMap();
    private HashSet<IStarTDreamLinkNetworkRecieveEnergy> INSERTED_SET = new HashSet();
    private static final StarTDreamLinkManager MANAGER = new StarTDreamLinkManager();

    private StarTDreamLinkManager() {
    }

    public static void addDevice(IStarTDreamLinkNetworkRecieveEnergy machine, UUID machineOwner) {
        BlockPos position = machine.devicePos();
        int x = position.m_123341_();
        int z = position.m_123343_();
        if (StarTDreamLinkManager.MANAGER.INSERTED_SET.contains(machine)) {
            return;
        }
        StarTDreamLinkManager.MANAGER.DREAM_LINK_TREE.putIfAbsent(machineOwner, (RTree<IStarTDreamLinkNetworkRecieveEnergy, Geometry>)RTree.create());
        StarTDreamLinkManager.MANAGER.INSERTED_SET.add(machine);
        StarTDreamLinkManager.MANAGER.DREAM_LINK_TREE.compute(machineOwner, (owner, tree) -> tree.add((Object)machine, (Geometry)Geometries.point((float)x, (float)z)));
    }

    public static void removeDevice(IStarTDreamLinkNetworkRecieveEnergy machine, UUID machineOwner) {
        BlockPos position = machine.devicePos();
        int x = position.m_123341_();
        int z = position.m_123343_();
        StarTDreamLinkManager.MANAGER.DREAM_LINK_TREE.putIfAbsent(machineOwner, (RTree<IStarTDreamLinkNetworkRecieveEnergy, Geometry>)RTree.create());
        StarTDreamLinkManager.MANAGER.INSERTED_SET.remove(machine);
        StarTDreamLinkManager.MANAGER.DREAM_LINK_TREE.compute(machineOwner, (owner, tree) -> tree.delete((Object)machine, (Geometry)Geometries.point((float)x, (float)z)));
    }

    public static Observable<Entry<IStarTDreamLinkNetworkRecieveEnergy, Geometry>> getDevices(int tx, int tz, int bx, int bz, UUID machineOwner) {
        StarTDreamLinkManager.MANAGER.DREAM_LINK_TREE.putIfAbsent(machineOwner, (RTree<IStarTDreamLinkNetworkRecieveEnergy, Geometry>)RTree.create());
        RTree<IStarTDreamLinkNetworkRecieveEnergy, Geometry> tree = StarTDreamLinkManager.MANAGER.DREAM_LINK_TREE.get(machineOwner);
        return tree.search(Geometries.rectangle((float)bx, (float)bz, (float)tx, (float)tz));
    }

    public static Observable<Entry<IStarTDreamLinkNetworkRecieveEnergy, Geometry>> getAllDevices(UUID machineOwner) {
        StarTDreamLinkManager.MANAGER.DREAM_LINK_TREE.putIfAbsent(machineOwner, (RTree<IStarTDreamLinkNetworkRecieveEnergy, Geometry>)RTree.create());
        RTree<IStarTDreamLinkNetworkRecieveEnergy, Geometry> tree = StarTDreamLinkManager.MANAGER.DREAM_LINK_TREE.get(machineOwner);
        return tree.entries();
    }
}

