/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.machine.dreamlink;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredIOPartMachine;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.startechnology.start_core.api.capability.IStarTDreamLinkNetworkMachine;
import com.startechnology.start_core.api.capability.IStarTDreamLinkNetworkRecieveEnergy;
import com.startechnology.start_core.api.capability.IStarTGetMachineUUIDSafe;
import com.startechnology.start_core.api.capability.StarTNotifiableDreamLinkContainer;
import com.startechnology.start_core.machine.dreamlink.StarTDreamLinkTransmissionMachine;
import com.startechnology.start_core.machine.dreamlink.StarTDreamWidgetGroup;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;

public class StarTDreamLinkHatchPartMachine
extends TieredIOPartMachine
implements IStarTDreamLinkNetworkMachine,
IStarTDreamLinkNetworkRecieveEnergy {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(StarTDreamLinkHatchPartMachine.class, TieredIOPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    protected StarTNotifiableDreamLinkContainer container;
    @Persisted
    protected String network;
    protected String tempNetwork;

    public StarTDreamLinkHatchPartMachine(IMachineBlockEntity holder, int tier, int amperage) {
        super(holder, tier, IO.IN);
        this.container = StarTNotifiableDreamLinkContainer.receiverContainer((MetaMachine)this, GTValues.V[tier] * 64L * (long)amperage, GTValues.V[tier], amperage);
        this.tempNetwork = this.network = "Untitled Network";
    }

    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return true;
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public int tintColor(int index) {
        if (index == 2) {
            return GTValues.VC[this.getTier()];
        }
        return super.tintColor(index);
    }

    private void addComponentPanelText(List<Component> componentList) {
        if (this.container.getInputPerSec() > 0L) {
            componentList.add((Component)Component.m_237115_((String)"start_core.machine.dream_link.active"));
        } else {
            componentList.add((Component)Component.m_237115_((String)"start_core.machine.dream_link.not_active"));
        }
        if (this.getHolder().getOwner() != null) {
            componentList.add((Component)Component.m_237115_((String)"start_core.machine.dream_link.owned_title").m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.dream_link.hatch.owned_hover")))));
            MutableComponent ownerComponent = Component.m_237113_((String)this.getHolder().getOwner().getName());
            componentList.add((Component)Component.m_237110_((String)"start_core.machine.dream_link.owner", (Object[])new Object[]{ownerComponent}).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.dream_link.hatch.owned_hover")))));
        }
        MutableComponent inAmountComponent = Component.m_237113_((String)FormattingUtil.formatNumbers((long)(this.container.getInputPerSec() / 20L))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN));
        componentList.add((Component)Component.m_237110_((String)"start_core.machine.dream_link.input_per_sec", (Object[])new Object[]{inAmountComponent}).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"start_core.machine.dream_link.hatch.input_per_sec_hover")))));
    }

    public Widget createUIWidget() {
        this.tempNetwork = this.network;
        StarTDreamWidgetGroup group = new StarTDreamWidgetGroup(0, 0, 190, 125, this::closeUI);
        group.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, 182, 117).setBackground((IGuiTexture)GuiTextures.DISPLAY).addWidget((Widget)new LabelWidget(4, 5, "Dream-Link Hatch")).addWidget((Widget)new LabelWidget(4, 20, "\u00a77Dream-Network Identifier")).addWidget(new TextFieldWidget(4, 32, 174, 12, this::getTempNetwork, this::setTempNetwork).setMaxStringLength(64).setValidator(input -> {
            if (input == null) {
                return "";
            }
            return input;
        }).setHoverTooltips(new Component[]{Component.m_237115_((String)"start_core.machine.dream_link.network_set_hover")})).addWidget((Widget)new ComponentPanelWidget(4, 52, this::addComponentPanelText)));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    private void closeUI() {
        this.network = this.tempNetwork;
        if (this.tempNetwork.isBlank()) {
            this.network = "Untitled Network";
        }
    }

    public ModularUI createUI(Player entityPlayer) {
        ModularUI ui = new ModularUI(198, 208, (IUIHolder)this, entityPlayer).widget((Widget)new FancyMachineUIWidget((IFancyUIProvider)this, 198, 208));
        return ui;
    }

    @Override
    public void setNetwork(String network) {
        this.network = network;
    }

    @Override
    public String getNetwork() {
        return this.network;
    }

    @Override
    public InteractionResult onDreamCopyShiftUse(Player player, ItemStack copyItem) {
        if (!this.isRemote()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("dream_network", this.getNetwork());
            copyItem.m_41751_(tag);
            copyItem.m_41714_((Component)Component.m_237110_((String)"start_core.machine.dream_link.lucinducer.name", (Object[])new Object[]{this.getNetwork()}));
            player.m_213846_((Component)Component.m_237115_((String)"start_core.machine.dream_link.copy_network"));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public final InteractionResult onDreamCopyUse(Player player, ItemStack copyItem) {
        CompoundTag tag = copyItem.m_41783_();
        if (tag == null || !tag.m_128441_("dream_network")) {
            return InteractionResult.PASS;
        }
        if (!this.isRemote()) {
            String network = tag.m_128461_("dream_network");
            this.setNetwork(network);
            player.m_213846_((Component)Component.m_237115_((String)"start_core.machine.dream_link.set_network"));
        }
        return InteractionResult.m_19078_((boolean)this.isRemote());
    }

    @Override
    public boolean isDreaming() {
        return this.container.getInputPerSec() > 0L;
    }

    @Override
    public long recieveEnergy(long recieved) {
        return this.container.changeEnergy(Math.min(recieved, this.container.getInputVoltage() * this.container.getInputAmperage()));
    }

    @Override
    public BlockPos devicePos() {
        return this.getPos();
    }

    @Override
    public boolean canRecieve(StarTDreamLinkTransmissionMachine tower, Boolean checkDimension) {
        if (!Objects.equals(this.getNetwork(), tower.getNetwork())) {
            return false;
        }
        if (!Objects.equals(IStarTGetMachineUUIDSafe.getUUIDSafeMetaMachine((MetaMachine)this), IStarTGetMachineUUIDSafe.getUUIDSafeMetaMachine((MetaMachine)tower))) {
            return false;
        }
        return checkDimension == false || Objects.equals(this.getLevel().m_220362_(), tower.getLevel().m_220362_());
    }

    public String getTempNetwork() {
        return this.tempNetwork;
    }

    public void setTempNetwork(String tempNetwork) {
        this.tempNetwork = tempNetwork;
    }
}

