/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.machine.dreamlink;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.startechnology.start_core.api.capability.IStarTDreamLinkNetworkRecieveEnergy;
import com.startechnology.start_core.api.capability.IStarTGetMachineUUIDSafe;
import com.startechnology.start_core.api.dreamlink.IStarTDreamCopyInteractable;
import com.startechnology.start_core.machine.dreamlink.StarTDreamLinkManager;
import com.startechnology.start_core.machine.dreamlink.StarTDreamLinkTransmissionMachine;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StarTDreamLinkCover
extends CoverBehavior
implements IStarTDreamLinkNetworkRecieveEnergy,
IStarTDreamCopyInteractable,
IUICover {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(StarTDreamLinkCover.class, CoverBehavior.MANAGED_FIELD_HOLDER);
    private int tier;
    private int amperage;
    @Persisted
    private String network = "Untitled Network";
    private TickableSubscription addTickSubscription;
    private UUID ownerUUID;

    public StarTDreamLinkCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide, int tier, int amperage) {
        super(definition, coverHolder, attachedSide);
        this.tier = tier;
        this.amperage = amperage;
    }

    public void onLoad() {
        super.onLoad();
        if (this.coverHolder.getLevel().f_46443_) {
            return;
        }
        this.addTickSubscription = this.coverHolder.subscribeServerTick(this.addTickSubscription, this::addToTreeSubscription);
    }

    protected void addToTreeSubscription() {
        BlockEntity machine;
        if (this.coverHolder.getOffsetTimer() % 5L == 0L && (machine = this.coverHolder.getLevel().m_7702_(this.coverHolder.getPos())) instanceof MetaMachineBlockEntity) {
            UUID ownerUUID;
            MetaMachineBlockEntity metaMachineBlockEntity = (MetaMachineBlockEntity)machine;
            this.ownerUUID = ownerUUID = IStarTGetMachineUUIDSafe.getUUIDSafeMetaMachineBlockEntity(metaMachineBlockEntity);
            StarTDreamLinkManager.addDevice(this, ownerUUID);
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.coverHolder.getLevel().f_46443_) {
            return;
        }
        StarTDreamLinkManager.removeDevice(this, this.ownerUUID);
        if (Objects.nonNull(this.addTickSubscription)) {
            this.addTickSubscription.unsubscribe();
        }
    }

    protected IEnergyContainer getEnergyContainer() {
        return GTCapabilityHelper.getEnergyContainer((Level)this.coverHolder.getLevel(), (BlockPos)this.coverHolder.getPos(), (Direction)this.attachedSide);
    }

    public void stupidExplosion(IExplosionMachine machine, BlockPos centrePos) {
        double gap = 20.0;
        double maxRadius = (double)(this.tier - 8 + 1) * gap / 2.0;
        int explosionPower = 128;
        for (double radius = 0.0; radius <= maxRadius; radius += gap) {
            if (radius == 0.0) {
                machine.doExplosion(centrePos, (float)explosionPower);
                continue;
            }
            int latSteps = (int)Math.ceil(Math.PI * radius / gap);
            for (int i = 0; i <= latSteps; ++i) {
                double theta = Math.PI * (double)i / (double)latSteps;
                double sinTheta = Math.sin(theta);
                if (sinTheta == 0.0) {
                    int x = centrePos.m_123341_();
                    int y = centrePos.m_123342_() + (int)Math.round(radius * Math.cos(theta));
                    int z = centrePos.m_123343_();
                    BlockPos pos = new BlockPos(x, y, z);
                    machine.doExplosion(pos, (float)explosionPower);
                    continue;
                }
                int lonSteps = (int)Math.ceil(Math.PI * 2 * radius * sinTheta / gap);
                for (int j = 0; j < lonSteps; ++j) {
                    double phi = Math.PI * 2 * (double)j / (double)lonSteps;
                    int x = centrePos.m_123341_() + (int)Math.round(radius * sinTheta * Math.cos(phi));
                    int y = centrePos.m_123342_() + (int)Math.round(radius * Math.cos(theta));
                    int z = centrePos.m_123343_() + (int)Math.round(radius * sinTheta * Math.sin(phi));
                    BlockPos pos = new BlockPos(x, y, z);
                    machine.doExplosion(pos, (float)explosionPower);
                }
            }
        }
    }

    public void onRemoved() {
        if (this.coverHolder.getLevel().f_46443_) {
            return;
        }
        StarTDreamLinkManager.removeDevice(this, this.ownerUUID);
        if (Objects.nonNull(this.addTickSubscription)) {
            this.addTickSubscription.unsubscribe();
        }
    }

    @Override
    public long recieveEnergy(long recieved) {
        BlockEntity entity;
        IEnergyContainer container = this.getEnergyContainer();
        if (Objects.isNull(container)) {
            return 0L;
        }
        if (container.getInputVoltage() < GTValues.V[this.tier] && recieved > container.getInputVoltage() && (entity = this.coverHolder.getLevel().m_7702_(this.coverHolder.getPos())) instanceof MetaMachineBlockEntity) {
            MetaMachineBlockEntity metaMachineBlockEntity = (MetaMachineBlockEntity)entity;
            BlockPos centrePos = metaMachineBlockEntity.m_58899_();
            MetaMachine metaMachine = metaMachineBlockEntity.getMetaMachine();
            if (metaMachine instanceof IExplosionMachine) {
                IExplosionMachine explode = (IExplosionMachine)metaMachine;
                this.stupidExplosion(explode, centrePos);
            }
        }
        return container.changeEnergy(Math.min(Math.min(recieved, container.getInputVoltage() * container.getInputAmperage()), (long)this.amperage * GTValues.V[this.tier]));
    }

    @Override
    public BlockPos devicePos() {
        return this.coverHolder.getPos();
    }

    @Override
    public boolean canRecieve(StarTDreamLinkTransmissionMachine tower, Boolean checkDimension) {
        if (!Objects.equals(this.network, tower.getNetwork())) {
            return false;
        }
        BlockEntity entity = this.coverHolder.getLevel().m_7702_(this.coverHolder.getPos());
        if (entity instanceof MetaMachineBlockEntity) {
            MetaMachineBlockEntity machine = (MetaMachineBlockEntity)entity;
            if (!Objects.equals(IStarTGetMachineUUIDSafe.getUUIDSafeMetaMachineBlockEntity(machine), IStarTGetMachineUUIDSafe.getUUIDSafeMetaMachine((MetaMachine)tower))) {
                return false;
            }
        } else {
            return false;
        }
        return checkDimension == false || Objects.equals(this.coverHolder.getLevel().m_220362_(), tower.getLevel().m_220362_());
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public InteractionResult onDreamCopyShiftUse(Player player, ItemStack copyItem) {
        if (!this.isRemote()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("dream_network", this.getNetwork());
            copyItem.m_41751_(tag);
            copyItem.m_41714_((Component)Component.m_237110_((String)"start_core.machine.dream_link.lucinducer.name", (Object[])new Object[]{this.getNetwork()}));
            player.m_213846_((Component)Component.m_237115_((String)"start_core.machine.dream_link.copy_network"));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public final InteractionResult onDreamCopyUse(Player player, ItemStack copyItem) {
        CompoundTag tag = copyItem.m_41783_();
        if (tag == null || !tag.m_128441_("dream_network")) {
            return InteractionResult.PASS;
        }
        if (!this.isRemote()) {
            String network = tag.m_128461_("dream_network");
            this.setNetwork(network);
            player.m_213846_((Component)Component.m_237115_((String)"start_core.machine.dream_link.set_network"));
        }
        return InteractionResult.m_19078_((boolean)this.isRemote());
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 190, 125);
        group.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, 182, 117).addWidget((Widget)new LabelWidget(4, 5, "Dream-Link Cover")).addWidget((Widget)new LabelWidget(4, 20, "Dream-Network Identifier")).addWidget(new TextFieldWidget(4, 32, 174, 12, this::getNetwork, this::setNetwork).setMaxStringLength(64).setValidator(input -> {
            if (input == null || input.isBlank()) {
                return "Untitled Network";
            }
            return input;
        }).setHoverTooltips(new Component[]{Component.m_237115_((String)"start_core.machine.dream_link.network_set_hover")})));
        return group;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public String getNetwork() {
        return this.network;
    }
}

