/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.machine.boosting;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.machine.multiblock.generator.LargeTurbineMachine;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class BoostedPlasmaTurbine
extends LargeTurbineMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(BoostedPlasmaTurbine.class, LargeTurbineMachine.MANAGED_FIELD_HOLDER);
    private static final int SUPREME_TURBINE_TIER = 9;
    private static final int NYINSANE_TURBINE_TIER = 11;
    private Integer tier;
    private boolean isActiveBoosting;
    private boolean isPassiveBoosting;
    private int runningTimer = 0;
    private Material WS2_FLUID = GTMaterials.get((String)"tungsten_disulfide");
    private Material SS_HE3_FLUID = GTMaterials.get((String)"superstate_helium_3");
    private Material BEC_OG_FLUID = GTMaterials.get((String)"bec_og");

    public BoostedPlasmaTurbine(IMachineBlockEntity holder, int tier) {
        super(holder, 5);
        this.tier = tier;
    }

    private Integer getParallelBonus() {
        switch (this.tier) {
            case 9: {
                return 6;
            }
            case 11: {
                return 12;
            }
        }
        return 1;
    }

    private double getBoostingBonus() {
        switch (this.tier) {
            case 9: {
                return this.isActiveBoosting ? 2.0 : 1.25;
            }
            case 11: {
                return this.isActiveBoosting ? 3.0 : 1.5;
            }
        }
        return 1.0;
    }

    private double getNonBoostingBonus() {
        switch (this.tier) {
            case 9: {
                return 0.9;
            }
            case 11: {
                return 0.8;
            }
        }
        return 1.0;
    }

    private GTRecipe getPassiveBoostingRecipe() {
        switch (this.tier) {
            case 9: {
                return GTRecipeBuilder.ofRaw().inputFluids(this.WS2_FLUID.getFluid(1000)).buildRawRecipe();
            }
            case 11: {
                return GTRecipeBuilder.ofRaw().inputFluids(this.WS2_FLUID.getFluid(2500)).buildRawRecipe();
            }
        }
        return GTRecipeBuilder.ofRaw().buildRawRecipe();
    }

    private GTRecipe getActiveBoostingRecipe() {
        switch (this.tier) {
            case 9: {
                return GTRecipeBuilder.ofRaw().inputFluids(this.SS_HE3_FLUID.getFluid(2500)).buildRawRecipe();
            }
            case 11: {
                return GTRecipeBuilder.ofRaw().inputFluids(this.BEC_OG_FLUID.getFluid(800)).buildRawRecipe();
            }
        }
        return GTRecipeBuilder.ofRaw().buildRawRecipe();
    }

    private double getBonus() {
        if (this.isPassiveBoosting) {
            return this.getBoostingBonus();
        }
        return this.getNonBoostingBonus();
    }

    public long getOverclockVoltage() {
        long largeTurbineOCVoltage = super.getOverclockVoltage();
        return (long)((double)largeTurbineOCVoltage * (double)this.getParallelBonus().intValue());
    }

    public ModifierFunction getModifierFunction() {
        return ModifierFunction.builder().eutMultiplier(this.getBonus()).build();
    }

    private MutableComponent getActiveBoostingComponent() {
        switch (this.tier) {
            case 9: {
                return Component.m_237115_((String)"start_core.multiblock.supreme_turbine.ss_h32_boosting").m_130940_(ChatFormatting.YELLOW);
            }
            case 11: {
                return Component.m_237115_((String)"start_core.multiblock.nyinsane_turbine.bec_og_boosting").m_130940_(ChatFormatting.LIGHT_PURPLE);
            }
        }
        return Component.m_237119_();
    }

    private MutableComponent getPassiveBoostingComponent() {
        return Component.m_237115_((String)"start_core.multiblock.boosted_plasma_turbine.ws2_boosting").m_130940_(ChatFormatting.GREEN);
    }

    private MutableComponent getNotPassiveBoostingComponent() {
        return Component.m_237115_((String)"start_core.multiblock.boosted_plasma_turbine.no_ws2_boosting").m_130940_(ChatFormatting.RED);
    }

    public static ModifierFunction recipeModifier(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        if (!(machine instanceof BoostedPlasmaTurbine)) {
            return RecipeModifier.nullWrongType(BoostedPlasmaTurbine.class, (MetaMachine)machine);
        }
        BoostedPlasmaTurbine engineMachine = (BoostedPlasmaTurbine)machine;
        long EUt = RecipeHelper.getOutputEUt((GTRecipe)recipe);
        if (EUt > 0L) {
            return engineMachine.getModifierFunction();
        }
        return ModifierFunction.NULL;
    }

    public boolean onWorking() {
        boolean value = super.onWorking();
        if (this.runningTimer % 72 == 0) {
            GTRecipe passiveBoosterRecipe = this.getPassiveBoostingRecipe();
            boolean bl = this.isPassiveBoosting = passiveBoosterRecipe.matchRecipe((IRecipeCapabilityHolder)this).isSuccess() && passiveBoosterRecipe.handleRecipeIO(IO.IN, (IRecipeCapabilityHolder)this, this.recipeLogic.getChanceCaches());
            if (this.isPassiveBoosting) {
                GTRecipe activeBoosterRecipe = this.getActiveBoostingRecipe();
                this.isActiveBoosting = activeBoosterRecipe.matchRecipe((IRecipeCapabilityHolder)this).isSuccess() && activeBoosterRecipe.handleRecipeIO(IO.IN, (IRecipeCapabilityHolder)this, this.recipeLogic.getChanceCaches());
            }
        }
        ++this.runningTimer;
        if (this.runningTimer > 72000) {
            this.runningTimer %= 72000;
        }
        return value;
    }

    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        if (this.isFormed()) {
            if (this.isActive()) {
                long maxProduction = (long)((double)this.getOverclockVoltage() * this.getBonus());
                long currentProduction = this.isActive() && this.recipeLogic.getLastRecipe() != null ? RecipeHelper.getOutputEUt((GTRecipe)this.recipeLogic.getLastRecipe()) : 0L;
                textList.remove(3);
                textList.add(3, (Component)Component.m_237110_((String)"gtceu.multiblock.turbine.energy_per_tick", (Object[])new Object[]{FormattingUtil.formatNumbers((long)currentProduction), FormattingUtil.formatNumbers((long)maxProduction)}));
            }
            if (this.isPassiveBoosting) {
                textList.add((Component)this.getPassiveBoostingComponent());
            } else {
                textList.add((Component)this.getNotPassiveBoostingComponent());
            }
            if (this.isActiveBoosting) {
                textList.add((Component)this.getActiveBoostingComponent());
            }
        }
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }
}

