/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.machine.abyssal_harvester;

import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.startechnology.start_core.machine.redstone.StarTRedstoneInterfacePartMachine;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StarTAbyssalHarvesterMachine
extends WorkableElectricMultiblockMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(StarTAbyssalHarvesterMachine.class, WorkableElectricMultiblockMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    protected Integer saturation = 0;
    protected TickableSubscription tryTickSub;
    private boolean startSaturationGain = false;
    private boolean isWorking = false;
    public ArrayList<StarTRedstoneInterfacePartMachine> redstoneOutputHatches = new ArrayList();
    private static final List<Integer> redstoneSaturationMarkers = List.of(Integer.valueOf(12000), Integer.valueOf(9000), Integer.valueOf(6000), Integer.valueOf(3000));

    public StarTAbyssalHarvesterMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    public static ModifierFunction recipeModifier(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        if (!(machine instanceof StarTAbyssalHarvesterMachine)) {
            return RecipeModifier.nullWrongType(StarTAbyssalHarvesterMachine.class, (MetaMachine)machine);
        }
        StarTAbyssalHarvesterMachine abyssalHarvesterMachine = (StarTAbyssalHarvesterMachine)machine;
        if (!recipe.data.m_128441_("min_saturation") || !recipe.data.m_128441_("max_saturation")) {
            return ModifierFunction.IDENTITY;
        }
        int machineSaturation = abyssalHarvesterMachine.getSaturation();
        int minRecipeSaturation = recipe.data.m_128451_("min_saturation");
        int maxRecipeSaturation = recipe.data.m_128451_("max_saturation");
        if (minRecipeSaturation > machineSaturation || maxRecipeSaturation < machineSaturation) {
            return ModifierFunction.NULL;
        }
        if (1750 <= machineSaturation && machineSaturation <= 2750 || 4750 <= machineSaturation && machineSaturation <= 5750 || 7750 <= machineSaturation && machineSaturation <= 8750) {
            int maxPossibleParallels = ParallelLogic.getParallelAmountFast((MetaMachine)machine, (GTRecipe)recipe, (int)2);
            return ModifierFunction.builder().modifyAllContents(ContentModifier.multiplier((double)maxPossibleParallels)).parallels(maxPossibleParallels).build();
        }
        return ModifierFunction.IDENTITY;
    }

    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        textList.add((Component)Component.m_237110_((String)"ui.start_core.abyssal_harvester", (Object[])new Object[]{String.format("%.2f", (double)this.getSaturation().intValue() / 100.0)}));
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onUnload() {
        super.onUnload();
        if (this.getLevel().f_46443_) {
            return;
        }
        if (this.tryTickSub != null) {
            this.tryTickSub.unsubscribe();
            this.tryTickSub = null;
        }
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.isWorking = false;
        this.startSaturationGain = true;
        this.getParts().stream().filter(StarTRedstoneInterfacePartMachine.class::isInstance).forEach(part -> this.redstoneOutputHatches.add((StarTRedstoneInterfacePartMachine)((Object)part)));
        this.saturationChanged();
    }

    private void saturationChanged() {
        if (this.redstoneOutputHatches.isEmpty()) {
            return;
        }
        redstoneSaturationMarkers.forEach(marker -> {
            double percentSaturation = Math.min((double)this.saturation.intValue() / (double)marker.intValue() * 15.0, 15.0);
            this.redstoneOutputHatches.forEach(hatch -> {
                BigDecimal label = BigDecimal.valueOf(marker.intValue()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
                hatch.setIndicatorSignal("Ratio of \u00a75" + label.toString() + "%% \u00a7fAbyssal Saturation", (int)Math.floor(percentSaturation));
            });
        });
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.isWorking = false;
        this.startSaturationGain = false;
    }

    public void onLoad() {
        super.onLoad();
        if (this.getLevel().f_46443_) {
            return;
        }
        this.tryTickSub = this.subscribeServerTick(this.tryTickSub, this::tryGainSaturation);
    }

    public Integer getSaturation() {
        return this.saturation;
    }

    protected void tryGainSaturation() {
        if (this.getOffsetTimer() % 100L == 0L && this.startSaturationGain) {
            this.saturation = Math.min(this.saturation + 55, 12000);
            this.saturationChanged();
        }
    }

    public boolean beforeWorking(@Nullable GTRecipe recipe) {
        boolean isWorking = super.beforeWorking(recipe);
        if (isWorking) {
            this.isWorking = true;
        }
        return isWorking;
    }

    public void afterWorking() {
        super.afterWorking();
        this.isWorking = false;
        this.tryAbsorbSaturation();
    }

    private void tryAbsorbSaturation() {
        this.saturation = Math.max(this.saturation - 500, 0);
        this.saturationChanged();
    }
}

