/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.machine.abyssal_containment;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.data.GCYMBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.CleanroomMachine;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.startechnology.start_core.machine.StarTMachineUtils;
import com.startechnology.start_core.recipe.logic.AbyssalContainmentRoomLogic;
import dev.latvian.mods.kubejs.KubeJS;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class StarTAbyssalContainmentMachine
extends CleanroomMachine {
    private Material END_AIR = GTMaterials.EnderAir;
    private Material DRAGON_BREATH = GTMaterials.get((String)"dragon_breath");
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(StarTAbyssalContainmentMachine.class, CleanroomMachine.MANAGED_FIELD_HOLDER);
    public static final CleanroomType ABYSSAL_CONTAINMENT_ROOM = new CleanroomType("abyssal_containment_room", "start_core:abyssal_containment_room.display_name");
    private ItemStack talismanStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(KubeJS.id((String)"end_talisman")));
    private CleanroomType cleanroomType;
    private MobEffect abyssalDrain;
    private boolean isSuppliedFluids;
    private AABB cleanroomBoundingBox;
    private int runningTimer = 0;

    public StarTAbyssalContainmentMachine(IMachineBlockEntity metaTileEntityId) {
        super(metaTileEntityId);
    }

    public boolean isFluidsSupplied() {
        return this.isSuppliedFluids;
    }

    public Set<CleanroomType> getTypes() {
        return this.cleanroomType == null ? Set.of() : Set.of(this.cleanroomType);
    }

    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new AbyssalContainmentRoomLogic(this);
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        BlockPos controller = this.getPos();
        Direction front = this.getFrontFacing();
        Direction up = this.getUpwardsFacing();
        BlockPos minWorld = RelativeDirection.offsetPos((BlockPos)controller, (Direction)front, (Direction)up, (boolean)false, (int)-9, (int)7, (int)-14);
        BlockPos maxWorld = RelativeDirection.offsetPos((BlockPos)controller, (Direction)front, (Direction)up, (boolean)false, (int)9, (int)-7, (int)0);
        this.cleanroomBoundingBox = AABB.m_82321_((BoundingBox)new BoundingBox(minWorld.m_123341_(), minWorld.m_123342_(), minWorld.m_123343_(), maxWorld.m_123341_(), maxWorld.m_123342_(), maxWorld.m_123343_()));
        this.abyssalDrain = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(KubeJS.id((String)"abyssal_drain"));
        this.cleanroomType = ABYSSAL_CONTAINMENT_ROOM;
        this.getRecipeLogic().setDuration(4000);
    }

    public void updateStructureDimensions() {
    }

    @NotNull
    public BlockPattern getPattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"AAAAAAAAAAAAAAAAA", "A######A#A######A", "A####AA###AA####A", "A###A#######A###A", "A##A#########A##A", "A#A###########A#A", "A#A###########A#A", "AA=============AA", "A=============##A", "A=============##A", "A=============##A", "A=============##A", "A=============##A", "AA=============AA", "A#A###########A#A", "A#A###########A#A", "A##A#########A##A", "A###A#######A###A", "A####AA###AA####A", "A######A#A######A", "AAAAAAAAAAAAAAAAA"}).aisle(new String[]{"A######A#A######A", "#BBBBBBCDCBBBBBB#", "#BBBBCCCDCCCBBBB#", "#BBBCCCCDCCCCBBB#", "#BBCCCCEEECCCCBB#", "#BCCCEEEEEEECCCB#", "#BCCCEEFFFEECCCB#", "ACCCEEFFDFFEECCCA", "#CCCEEFFFFFEECCC#", "#CCEEFFFDFFFEECC#", "#DDEEFDFDFDFEEDD#", "#CCEEFFFDFFFEECC#", "#CCCEEFFFFFEECCC#", "ACCCEEFFDFFEECCCA", "#BCCCEEFFFEECCCB#", "#BCCCEEEEEEECCCB#", "#BBCCCCEEECCCCBB#", "#BBBCCCCDCCCCBBB#", "#BBBBCCCDCCCBBBB#", "#BBBBBBCDCBBBBBB#", "A######A#A######A"}).aisle(new String[]{"A####AA###AA####A", "#BBBBCCCDCCCBBBB#", "#B=============B#", "#B=============B#", "#B=============B#", "AC=============CA", "AC=============CA", "#C=============C#", "#C=============C#", "#C=============C#", "#D=============D#", "#C=============C#", "#C=============C#", "#C=============C#", "AC=============CA", "AC=============CA", "#B=============B#", "#B=============B#", "#B=============B#", "#BBBBCCCDCCCBBBB#", "A####AA###AA####A"}).aisle(new String[]{"A###A#######A###A", "#BBBCCCCDCCCCBBB#", "#B=============B#", "#B=============B#", "AC=============CA", "#C=============C#", "#C=============C#", "#C=============C#", "#C=============C#", "#E=============E#", "#E=============E#", "#E=============E#", "#C=============C#", "#C=============C#", "#C=============C#", "#C=============C#", "AC=============CA", "#B=============B#", "#B=============B#", "#BBBCCCCDCCCCBBB#", "A###A#######A###A"}).aisle(new String[]{"A##A#########A##A", "#BBCCCCEEECCCCBB#", "#B=============B#", "AC=============CA", "#C=============C#", "#C=============C#", "#C=============C#", "#E=============E#", "#E=============E#", "#E=============E#", "#E=============E#", "#E=============E#", "#E=============E#", "#E=============E#", "#C=============C#", "#C=============C#", "#C=============C#", "AC=============CA", "#B=============B#", "#BBCCCCEEECCCCBB#", "A##A#########A##A"}).aisle(new String[]{"A#A###########A#A", "#BCCCEEEEEEECCCB#", "AC=============CA", "#C=============C#", "#C=============C#", "#E=============E#", "#E=============E#", "#E=============E#", "#E=============E#", "#F=============F#", "#F=============F#", "#F=============F#", "#E=============E#", "#E=============E#", "#E=============E#", "#E=============E#", "#C=============C#", "#C=============C#", "AC=============CA", "#BCCCEEEEEEECCCB#", "A#A###########A#A"}).aisle(new String[]{"A#A###########A#A", "#BCCCEEFFFEECCCB#", "AC=============CA", "#C=============C#", "#C=============C#", "#E=============E#", "#E=============E#", "#F=============F#", "#F=============F#", "#F=============F#", "#D=============D#", "#F=============F#", "#F=============F#", "#F=============F#", "#E=============E#", "#E=============E#", "#C=============C#", "#C=============C#", "AC=============CA", "#BCCCEEFFFEECCCB#", "A#A###########A#A"}).aisle(new String[]{"AA#############AA", "ACCCEEFFFFFEECCCA", "#C=============C#", "#C=============C#", "#E=============E#", "#E=============E#", "#F=============F#", "#F=============F#", "#F=============F#", "#F=============F#", "#F=============F#", "#F=============F#", "#F=============F#", "#F=============F#", "#F=============F#", "#E=============E#", "#E=============E#", "#C=============C#", "#C=============C#", "ACCCEEFFFFFEECCCA", "AA#############AA"}).aisle(new String[]{"A###############A", "#DDDEEFFDFFEEDDD#", "#D=============D#", "#D=============D#", "#E=============E#", "#E=============E#", "#F=============F#", "#D=============D#", "#F=============F#", "#D=============D#", "#D=============D#", "#D=============D#", "#F=============F#", "#D=============D#", "#F=============F#", "#E=============E#", "#E=============E#", "#D=============D#", "#D=============D#", "#DDDEEFFDFFEEDDD#", "A###############A"}).aisle(new String[]{"AA#############AA", "ACCCEEFFFFFEECCCA", "#C=============C#", "#C=============C#", "#E=============E#", "#E=============E#", "#F=============F#", "#F=============F#", "#F=============F#", "#F=============F#", "#F=============F#", "#F=============F#", "#F=============F#", "#F=============F#", "#F=============F#", "#E=============E#", "#E=============E#", "#C=============C#", "#C=============C#", "ACCCEEFFFFFEECCCA", "AA#############AA"}).aisle(new String[]{"A#A###########A#A", "#BCCCEEFFFEECCCB#", "AC=============CA", "#C=============C#", "#C=============C#", "#E=============E#", "#E=============E#", "#F=============F#", "#F=============F#", "#F=============F#", "#D=============D#", "#F=============F#", "#F=============F#", "#F=============F#", "#E=============E#", "#E=============E#", "#C=============C#", "#C=============C#", "AC=============CA", "#BCCCEEFFFEECCCB#", "A#A###########A#A"}).aisle(new String[]{"A#A###########A#A", "#BCCCEEEEEEECCCB#", "AC=============CA", "#C=============C#", "#C=============C#", "#E=============E#", "#E=============E#", "#E=============E#", "#E=============E#", "#F=============F#", "#F=============F#", "#F=============F#", "#E=============E#", "#E=============E#", "#E=============E#", "#E=============E#", "#C=============C#", "#C=============C#", "AC=============CA", "#BCCCEEEEEEECCCB#", "A#A###########A#A"}).aisle(new String[]{"A##A#########A##A", "#BBCCCCEEECCCCBB#", "#B=============B#", "AC=============CA", "#C=============C#", "#C=============C#", "#C=============C#", "#E=============E#", "#E=============E#", "#E=============E#", "#E=============E#", "#E=============E#", "#E=============E#", "#E=============E#", "#C=============C#", "#C=============C#", "#C=============C#", "AC=============CA", "#B=============B#", "#BBCCCCEEECCCCBB#", "A##A#########A##A"}).aisle(new String[]{"A###A#######A###A", "#BBBCCCCDCCCCBBB#", "#B=============B#", "#B=============B#", "AC=============CA", "#C=============C#", "#C=============C#", "#C=============C#", "#C=============C#", "#E=============E#", "#E=============E#", "#E=============E#", "#C=============C#", "#C=============C#", "#C=============C#", "#C=============C#", "AC=============CA", "#B=============B#", "#B=============B#", "#BBBCCCCDCCCCBBB#", "A###A#######A###A"}).aisle(new String[]{"A####AA###AA####A", "#BBBBCCCDCCCBBBB#", "#B=============B#", "#B=============B#", "#B=============B#", "AC=============CA", "AC=============CA", "#C=============C#", "#C=============C#", "#C=============C#", "#D=============D#", "#C=============C#", "#C=============C#", "#C=============C#", "AC=============CA", "AC=============CA", "#B=============B#", "#B=============B#", "#B=============B#", "#BBBBCCCDCCCBBBB#", "A####AA###AA####A"}).aisle(new String[]{"A######A#A######A", "#BBBBBBCDCBBBBBB#", "#BBBBCCCDCCCBBBB#", "#BBBCCCCDCCCCBBB#", "#BBCCCCEEECCCCBB#", "#BCCCEEEEEEECCCB#", "#BCCCEEFFFEECCCB#", "ACCCEEFFDFFEECCCA", "#CCCEEFFFFFEECCC#", "#CCEEFFFDFFFEECC#", "#DDEEFDF@FDFEEDD#", "#CCEEFFFDFFFEECC#", "#CCCEEFFFFFEECCC#", "ACCCEEFFDFFEECCCA", "#BCCCEEFFFEECCCB#", "#BCCCEEEEEEECCCB#", "#BBCCCCEEECCCCBB#", "#BBBCCCCDCCCCBBB#", "#BBBBCCCDCCCBBBB#", "#BBBBBBCDCBBBBBB#", "A######A#A######A"}).aisle(new String[]{"AAAAAAAAAAAAAAAAA", "A######A#A######A", "A####AA###AA####A", "A###A#######A###A", "A##A#########A##A", "A#A###########A#A", "A#A###########A#A", "AA=============AA", "A=============##A", "A=============##A", "A=============##A", "A=============##A", "A=============##A", "AA=============AA", "A#A###########A#A", "A#A###########A#A", "A##A#########A##A", "A###A#######A###A", "A####AA###AA####A", "A######A#A######A", "AAAAAAAAAAAAAAAAA"}).where("A", Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTCEuAPI.materialManager.getMaterial("abyssal_alloy"))})).where("#", Predicates.any()).where("=", this.innerPredicate()).where("B", Predicates.blocks((Block[])new Block[]{StarTMachineUtils.getKjsBlock("draneko_casing")})).where("C", Predicates.blocks((Block[])new Block[]{(Block)GCYMBlocks.CASING_ATOMIC.get()})).where("D", Predicates.blocks((Block[])new Block[]{StarTMachineUtils.getKjsBlock("draco_ware_casing")}).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.IMPORT_FLUIDS}).setMaxGlobalLimited(2)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.INPUT_ENERGY}).setMaxGlobalLimited(2)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.MAINTENANCE}).setExactLimit(1))).where("E", Predicates.blocks((Block[])new Block[]{StarTMachineUtils.getKjsBlock("abyssal_inductor_hull")})).where("F", Predicates.blocks((Block[])new Block[]{StarTMachineUtils.getKjsBlock("draco_resilient_fusion_glass")})).where("@", Predicates.controller((TraceabilityPredicate)Predicates.blocks((IMachineBlock[])new IMachineBlock[]{this.getDefinition().get()}))).build();
    }

    public boolean shouldAddPartToController(IMultiPart part) {
        return true;
    }

    private GTRecipe getAbyssalContainmentRecipe() {
        return GTRecipeBuilder.ofRaw().inputFluids(this.END_AIR.getFluid(100000)).inputFluids(this.DRAGON_BREATH.getFluid(50)).buildRawRecipe();
    }

    private static final String endArmourId(String pieceName) {
        return KubeJS.id((String)("end_" + pieceName)).toString();
    }

    public boolean onWorking() {
        boolean value = super.onWorking();
        if (this.runningTimer % 72 == 0) {
            GTRecipe abyssalContainmentRecipe = this.getAbyssalContainmentRecipe();
            this.isSuppliedFluids = abyssalContainmentRecipe.matchRecipe((IRecipeCapabilityHolder)this).isSuccess() && abyssalContainmentRecipe.handleRecipeIO(IO.IN, (IRecipeCapabilityHolder)this, this.recipeLogic.getChanceCaches());
            List playersInside = this.getLevel().m_45976_(Player.class, this.cleanroomBoundingBox);
            playersInside.forEach(player -> {
                String headId = player.kjs$getHeadArmorItem().kjs$getId();
                String chestId = player.kjs$getChestArmorItem().kjs$getId();
                String legsId = player.kjs$getLegsArmorItem().kjs$getId();
                String feetId = player.kjs$getFeetArmorItem().kjs$getId();
                if (StarTAbyssalContainmentMachine.endArmourId("helmet").equals(headId) && StarTAbyssalContainmentMachine.endArmourId("chestplate").equals(chestId) && StarTAbyssalContainmentMachine.endArmourId("leggings").equals(legsId) && StarTAbyssalContainmentMachine.endArmourId("boots").equals(feetId)) {
                    player.m_21195_(this.abyssalDrain);
                    return;
                }
                if (player.m_150109_().m_36063_(this.talismanStack)) {
                    player.m_21195_(this.abyssalDrain);
                    return;
                }
                player.m_7292_(new MobEffectInstance(this.abyssalDrain, 600));
            });
        }
        ++this.runningTimer;
        if (this.runningTimer > 72000) {
            this.runningTimer %= 72000;
        }
        return value;
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        if (this.isFormed()) {
            if (!this.isSuppliedFluids) {
                textList.add((Component)Component.m_237115_((String)"start_core.abyssal_containment_room.not_provided_fluids").m_130940_(ChatFormatting.RED));
            } else {
                textList.add((Component)Component.m_237115_((String)"start_core.abyssal_containment_room.provided_fluids").m_130940_(ChatFormatting.GREEN));
            }
        }
    }

    public static void init() {
    }
}

