/*
 * Decompiled with CFR 0.152.
 */
package com.startechnology.start_core.item.components;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.startechnology.start_core.api.bacteria.StarTBacteriaManager;
import com.startechnology.start_core.api.bacteria.StarTBacteriaStats;
import com.startechnology.start_core.item.components.StarTNBTTooltipsBehaviour;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class StarTBacteriaBehaviour
extends StarTNBTTooltipsBehaviour {
    private List<Material> possibleBacteriaAffinities;

    public List<Material> getPossibleBacteriaAffinities() {
        return this.possibleBacteriaAffinities;
    }

    public List<Fluid> getBehaviourAffinityFluids() {
        return this.possibleBacteriaAffinities.stream().filter(Material::hasFluid).map(material -> material.getFluid()).collect(Collectors.toList());
    }

    public StarTBacteriaBehaviour(Material ... materials) {
        this.possibleBacteriaAffinities = Arrays.asList(materials);
    }

    public static StarTBacteriaBehaviour getBacteriaBehaviour(ItemStack bacteria) {
        Item bacteriaItem = bacteria.m_41720_();
        if (!(bacteriaItem instanceof ComponentItem)) {
            return null;
        }
        List components = ((ComponentItem)bacteriaItem).getComponents();
        return components.stream().filter(StarTBacteriaBehaviour.class::isInstance).map(StarTBacteriaBehaviour.class::cast).findFirst().orElse(null);
    }

    public MutableComponent prettyPossibleBacteriaAffinities() {
        List translatableAffinities = this.possibleBacteriaAffinities.stream().map(material -> Component.m_237115_((String)material.getFluid().getFluidType().getDescriptionId()).m_130940_(ChatFormatting.DARK_PURPLE)).collect(Collectors.toList());
        return Component.m_237110_((String)"behaviour.start_core.bacteria.possible_affinities", (Object[])translatableAffinities.toArray());
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        StarTBacteriaStats stats = StarTBacteriaManager.bacteriaStatsFromTag(stack);
        if (stats == null) {
            tooltipComponents.add((Component)Component.m_237115_((String)"behaviour.start_core.bacteria.no_stats"));
            tooltipComponents.add((Component)Component.m_237113_((String)""));
            tooltipComponents.add((Component)this.prettyPossibleBacteriaAffinities());
        } else {
            tooltipComponents.add((Component)Component.m_237115_((String)"behaviour.start_core.bacteria.affinities_header"));
            tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.start_core.bacteria.affinity_primary", (Object[])new Object[]{stats.getFluidPretty(stats.getPrimary()).m_130940_(ChatFormatting.LIGHT_PURPLE)}));
            tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.start_core.bacteria.affinity_secondary", (Object[])new Object[]{stats.getFluidPretty(stats.getSecondary()).m_130940_(ChatFormatting.LIGHT_PURPLE)}));
            tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.start_core.bacteria.affinity_tertiary", (Object[])new Object[]{stats.getFluidPretty(stats.getTertiary()).m_130940_(ChatFormatting.LIGHT_PURPLE)}));
            tooltipComponents.add((Component)Component.m_237115_((String)""));
            tooltipComponents.add((Component)Component.m_237115_((String)"behaviour.start_core.bacteria.stats_header"));
            tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.start_core.bacteria.stat_production", (Object[])new Object[]{stats.getProductionPretty()}));
            tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.start_core.bacteria.stat_metabolism", (Object[])new Object[]{stats.getMetabolismPretty()}));
            tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.start_core.bacteria.stat_mutability", (Object[])new Object[]{stats.getMutabilityPretty()}));
        }
        super.appendHoverText(stack, level, tooltipComponents, isAdvanced);
    }
}

